/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.launching;

import java.io.IOException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.ui.ICDebuggerPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchMessages;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.gdb.internal.ui.launching.AbstractCDebuggerTab;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CDebuggerTab
extends AbstractCDebuggerTab {
    protected final GDBControl.SessionType fSessionType;
    protected Button fAdvancedButton;
    protected Button fStopInMain;
    protected Text fStopInMainSymbol;
    protected Button fAttachButton;
    private Map fAdvancedAttributes = new HashMap(5);
    private ScrolledComposite fContainer;
    private Composite fContents;

    public CDebuggerTab(GDBControl.SessionType type) {
        this.fSessionType = type;
        ICDebugConfiguration dc = CDebugCorePlugin.getDefault().getDefaultDefaultDebugConfiguration();
        if (dc == null) {
            CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_DEFAULT_DEBUGGER_TYPE, "org.eclipse.cdt.debug.mi.core.CDebuggerNew");
        }
    }

    public void createControl(Composite parent) {
        this.fContainer = new ScrolledComposite(parent, 768);
        this.fContainer.setLayoutData((Object)new GridData(1808));
        this.fContainer.setLayout((Layout)new FillLayout());
        this.fContainer.setExpandHorizontal(true);
        this.fContainer.setExpandVertical(true);
        this.fContents = new Composite((Composite)this.fContainer, 0);
        this.setControl((Control)this.fContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.dd.gdb.ui.launch_configuration_dialog_debugger_tab");
        int numberOfColumns = this.fSessionType == GDBControl.SessionType.ATTACH ? 2 : 1;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        this.fContents.setLayout((Layout)layout);
        GridData gd = new GridData(1, 2, true, false);
        this.fContents.setLayoutData((Object)gd);
        this.createDebuggerCombo(this.fContents, this.fSessionType == GDBControl.SessionType.ATTACH ? 1 : 2);
        this.createOptionsComposite(this.fContents);
        this.createDebuggerGroup(this.fContents, 2);
        this.fContainer.setContent((Control)this.fContents);
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration config, String selection) {
        String configPlatform = this.getPlatform(config);
        ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getActiveDebugConfigurations();
        Arrays.sort(debugConfigs, new Comparator<ICDebugConfiguration>(){

            @Override
            public int compare(ICDebugConfiguration c1, ICDebugConfiguration c2) {
                return Collator.getInstance().compare(c1.getName(), c2.getName());
            }
        });
        ArrayList<ICDebugConfiguration> list = new ArrayList<ICDebugConfiguration>();
        String mode = this.fSessionType == GDBControl.SessionType.ATTACH ? "attach" : (this.fSessionType == GDBControl.SessionType.REMOTE ? "remote" : "run");
        if (selection.equals("")) {
            ICDebugConfiguration dc = CDebugCorePlugin.getDefault().getDefaultDebugConfiguration();
            if (dc == null) {
                CDebugCorePlugin.getDefault().saveDefaultDebugConfiguration("org.eclipse.cdt.debug.mi.core.CDebuggerNew");
                dc = CDebugCorePlugin.getDefault().getDefaultDebugConfiguration();
            }
            if (dc != null) {
                selection = dc.getID();
            }
        }
        String defaultSelection = selection;
        for (int i = 0; i < debugConfigs.length; ++i) {
            if (!(mode.equals("remote") && debugConfigs[i].getName().equals("gdbserver Debugger") || mode.equals("run") && debugConfigs[i].getName().equals("gdb/mi") && debugConfigs[i].supportsMode(mode)) && (!mode.equals("attach") || !debugConfigs[i].getName().equals("gdb/mi") || !debugConfigs[i].supportsMode(mode))) continue;
            String debuggerPlatform = debugConfigs[i].getPlatform();
            if (!this.validatePlatform(config, debugConfigs[i])) continue;
            list.add(debugConfigs[i]);
        }
        this.setInitializeDefault(selection.equals(""));
        this.loadDebuggerCombo(list.toArray(new ICDebugConfiguration[list.size()]), defaultSelection);
    }

    protected void updateComboFromSelection() {
        super.updateComboFromSelection();
        this.initializeCommonControls(this.getLaunchConfiguration());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        ICDebugConfiguration dc;
        String defaultDebugger;
        block9: {
            super.setDefaults(config);
            if (this.fSessionType == GDBControl.SessionType.ATTACH) {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
            } else if (this.fSessionType == GDBControl.SessionType.REMOTE) {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
            } else {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
            }
            config.setAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false);
            config.setAttribute("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", false);
            defaultDebugger = null;
            try {
                String projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                if (projectName.length() <= 0) break block9;
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                ICProjectDescription projDesc = CoreModel.getDefault().getProjectDescription(project);
                ICConfigurationDescription configDesc = projDesc.getActiveConfiguration();
                String configId = configDesc.getId();
                ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getActiveDebugConfigurations();
                for (int i = 0; i < debugConfigs.length; ++i) {
                    ICDebugConfiguration debugConfig = debugConfigs[i];
                    String[] patterns = debugConfig.getSupportedBuildConfigPatterns();
                    if (patterns == null) continue;
                    for (int j = 0; j < patterns.length; ++j) {
                        if (!configId.matches(patterns[j])) continue;
                        defaultDebugger = debugConfig.getID();
                        break block9;
                    }
                }
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        if (defaultDebugger == null && (dc = CDebugCorePlugin.getDefault().getDefaultDebugConfiguration()) != null) {
            defaultDebugger = dc.getID();
        }
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", defaultDebugger);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setInitializing(true);
        super.initializeFrom(config);
        try {
            String id = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            this.loadDebuggerComboBox(config, id);
            this.initializeCommonControls(config);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        super.performApply(config);
        if (this.fSessionType == GDBControl.SessionType.ATTACH) {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "attach");
        } else {
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", this.fStopInMain.getSelection());
            config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", this.fStopInMainSymbol.getText());
            if (this.fSessionType == GDBControl.SessionType.REMOTE) {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
            } else {
                config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            }
        }
        this.applyAdvancedAttributes(config);
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (!this.validateDebuggerConfig(config)) {
            return false;
        }
        ICDebugConfiguration debugConfig = this.getDebugConfig();
        String mode = "run";
        if (this.fSessionType == GDBControl.SessionType.ATTACH) {
            mode = "attach";
        } else if (this.fSessionType == GDBControl.SessionType.REMOTE) {
            mode = "remote";
        }
        if (!mode.equals("remote") && !debugConfig.supportsMode(mode)) {
            this.setErrorMessage(MessageFormat.format(LaunchMessages.getString((String)"CDebuggerTab.Mode_not_supported"), mode));
            return false;
        }
        if (this.fStopInMain != null && this.fStopInMainSymbol != null) {
            String mainSymbol = this.fStopInMainSymbol.getText().trim();
            if (this.fStopInMain.getSelection() && mainSymbol.length() == 0) {
                this.setErrorMessage(LaunchMessages.getString((String)"CDebuggerTab.Stop_on_startup_at_can_not_be_empty"));
                return false;
            }
        }
        return super.isValid(config);
    }

    protected boolean validatePlatform(ILaunchConfiguration config, ICDebugConfiguration debugConfig) {
        String configPlatform = this.getPlatform(config);
        String debuggerPlatform = debugConfig.getPlatform();
        return debuggerPlatform.equals("*") || debuggerPlatform.equalsIgnoreCase(configPlatform);
    }

    protected boolean validateCPU(ILaunchConfiguration config, ICDebugConfiguration debugConfig) {
        IBinaryParser.IBinaryObject binaryFile = null;
        try {
            binaryFile = this.getBinary(config);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getLocalizedMessage());
        }
        String projectCPU = "native";
        if (binaryFile != null) {
            projectCPU = binaryFile.getCPU();
        }
        return debugConfig.supportsCPU(projectCPU);
    }

    protected IBinaryParser.IBinaryObject getBinary(ILaunchConfiguration config) throws CoreException {
        String programName = null;
        String projectName = null;
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", (String)null);
            programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", (String)null);
        }
        catch (CoreException e) {
            // empty catch block
        }
        if (programName != null) {
            Path exePath = new Path(programName);
            if (projectName != null && !projectName.equals("")) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!project.isAccessible()) {
                    return null;
                }
                if (!exePath.isAbsolute()) {
                    exePath = project.getLocation().append((IPath)exePath);
                }
                ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
                for (int i = 0; i < parserRef.length; ++i) {
                    try {
                        IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                        IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary((IPath)exePath);
                        if (exe != null) {
                            return exe;
                        }
                        continue;
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
            try {
                IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary((IPath)exePath);
                return exe;
            }
            catch (ClassCastException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean validateDebuggerConfig(ILaunchConfiguration config) {
        ICDebugConfiguration debugConfig = this.getDebugConfig();
        if (debugConfig == null) {
            this.setErrorMessage(LaunchMessages.getString((String)"CDebuggerTab.No_debugger_available"));
            return false;
        }
        return true;
    }

    protected void update() {
        if (!this.isInitializing()) {
            super.updateLaunchConfigurationDialog();
        }
    }

    protected void createOptionsComposite(Composite parent) {
        Composite optionsComp = new Composite(parent, 0);
        int numberOfColumns = this.fSessionType == GDBControl.SessionType.ATTACH ? 1 : 3;
        GridLayout layout = new GridLayout(numberOfColumns, false);
        optionsComp.setLayout((Layout)layout);
        optionsComp.setLayoutData((Object)new GridData(1, 2, true, false, 1, 1));
        if (this.fSessionType != GDBControl.SessionType.ATTACH) {
            this.fStopInMain = this.createCheckButton(optionsComp, LaunchMessages.getString((String)"CDebuggerTab.Stop_at_main_on_startup"));
            this.fStopInMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CDebuggerTab.this.fStopInMainSymbol.setEnabled(CDebuggerTab.this.fStopInMain.getSelection());
                    CDebuggerTab.this.update();
                }
            });
            this.fStopInMainSymbol = new Text(optionsComp, 2052);
            GridData gridData = new GridData(4, 2, false, false);
            gridData.widthHint = 100;
            this.fStopInMainSymbol.setLayoutData((Object)gridData);
            this.fStopInMainSymbol.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent evt) {
                    CDebuggerTab.this.update();
                }
            });
            this.fStopInMainSymbol.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = LaunchMessages.getString((String)"CDebuggerTab.Stop_at_main_on_startup");
                }
            });
        }
        this.fAdvancedButton = this.createPushButton(optionsComp, LaunchMessages.getString((String)"CDebuggerTab.Advanced"), null);
        ((GridData)this.fAdvancedButton.getLayoutData()).horizontalAlignment = 3;
        this.fAdvancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedDebuggerOptionsDialog dialog = new AdvancedDebuggerOptionsDialog(CDebuggerTab.this.getShell());
                dialog.open();
            }
        });
    }

    protected Map getAdvancedAttributes() {
        return this.fAdvancedAttributes;
    }

    private void initializeAdvancedAttributes(ILaunchConfiguration config) {
        Map attr = this.getAdvancedAttributes();
        try {
            Boolean varBookkeeping = config.getAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", false) ? Boolean.TRUE : Boolean.FALSE;
            attr.put("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", varBookkeeping);
        }
        catch (CoreException e) {
            // empty catch block
        }
        try {
            Boolean regBookkeeping = config.getAttribute("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", false) ? Boolean.TRUE : Boolean.FALSE;
            attr.put("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", regBookkeeping);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void applyAdvancedAttributes(ILaunchConfigurationWorkingCopy config) {
        Object regBookkeeping;
        Map attr = this.getAdvancedAttributes();
        Object varBookkeeping = attr.get("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING");
        if (varBookkeeping instanceof Boolean) {
            config.setAttribute("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", ((Boolean)varBookkeeping).booleanValue());
        }
        if ((regBookkeeping = attr.get("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING")) instanceof Boolean) {
            config.setAttribute("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", ((Boolean)regBookkeeping).booleanValue());
        }
    }

    protected Shell getShell() {
        return super.getShell();
    }

    public void dispose() {
        this.getAdvancedAttributes().clear();
        ICDebuggerPage debuggerPage = this.getDynamicTab();
        if (debuggerPage != null) {
            debuggerPage.dispose();
        }
        super.dispose();
    }

    protected void initializeCommonControls(ILaunchConfiguration config) {
        try {
            if (this.fSessionType != GDBControl.SessionType.ATTACH) {
                this.fStopInMain.setSelection(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true));
                this.fStopInMainSymbol.setText(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main"));
                this.fStopInMainSymbol.setEnabled(this.fStopInMain.getSelection());
            }
            this.initializeAdvancedAttributes(config);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void setInitializeDefault(boolean init) {
        super.setInitializeDefault(init);
    }

    protected void contentsChanged() {
        this.fContainer.setMinSize(this.fContents.computeSize(-1, -1));
    }

    public class AdvancedDebuggerOptionsDialog
    extends Dialog {
        private Button fVarBookKeeping;
        private Button fRegBookKeeping;

        protected AdvancedDebuggerOptionsDialog(Shell parentShell) {
            super(parentShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Group group = new Group(composite, 0);
            group.setText(LaunchMessages.getString((String)"CDebuggerTab.Automatically_track_values_of"));
            GridLayout layout = new GridLayout();
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            this.fVarBookKeeping = new Button((Composite)group, 32);
            this.fVarBookKeeping.setText(LaunchMessages.getString((String)"CDebuggerTab.Variables"));
            this.fRegBookKeeping = new Button((Composite)group, 32);
            this.fRegBookKeeping.setText(LaunchMessages.getString((String)"CDebuggerTab.Registers"));
            this.initialize();
            return composite;
        }

        protected void okPressed() {
            this.saveValues();
            super.okPressed();
        }

        private void initialize() {
            Map attr = CDebuggerTab.this.getAdvancedAttributes();
            Object varBookkeeping = attr.get("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING");
            this.fVarBookKeeping.setSelection(varBookkeeping instanceof Boolean ? !((Boolean)varBookkeeping).booleanValue() : true);
            Object regBookkeeping = attr.get("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING");
            this.fRegBookKeeping.setSelection(regBookkeeping instanceof Boolean ? !((Boolean)regBookkeeping).booleanValue() : true);
        }

        private void saveValues() {
            Map attr = CDebuggerTab.this.getAdvancedAttributes();
            Boolean varBookkeeping = !this.fVarBookKeeping.getSelection();
            attr.put("org.eclipse.cdt.launch.ENABLE_VARIABLE_BOOKKEEPING", varBookkeeping);
            Boolean regBookkeeping = !this.fRegBookKeeping.getSelection();
            attr.put("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", regBookkeeping);
            CDebuggerTab.this.update();
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(LaunchMessages.getString((String)"CDebuggerTab.Advanced_Options_Dialog_Title"));
        }
    }
}

