/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.launching;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchMessages;
import org.eclipse.dd.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.dd.gdb.internal.ui.launching.LaunchImages;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class ProcessPrompter
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        IProcessInfo info;
        Shell shell = GdbUIPlugin.getShell();
        if (shell == null) {
            Status error = new Status(4, GdbUIPlugin.getUniqueIdentifier(), 150, LaunchMessages.getString((String)"CoreFileLaunchDelegate.No_Shell_available_in_Launch"), null);
            throw new CoreException((IStatus)error);
        }
        LabelProvider provider = new LabelProvider(){

            public String getText(Object element) {
                IProcessInfo info = (IProcessInfo)element;
                Path path = new Path(info.getName());
                return path.lastSegment() + " - " + info.getPid();
            }

            public Image getImage(Object element) {
                return LaunchImages.get(LaunchImages.IMG_OBJS_EXEC);
            }
        };
        LabelProvider qprovider = new LabelProvider(){

            public String getText(Object element) {
                IProcessInfo info = (IProcessInfo)element;
                return info.getName();
            }

            public Image getImage(Object element) {
                return LaunchImages.get(LaunchImages.IMG_OBJS_EXEC);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(shell, (ILabelProvider)provider, (ILabelProvider)qprovider);
        dialog.setTitle(LaunchMessages.getString((String)"LocalAttachLaunchDelegate.Select_Process"));
        dialog.setMessage(LaunchMessages.getString((String)"LocalAttachLaunchDelegate.Select_Process_to_attach_debugger_to"));
        IProcessList plist = null;
        try {
            plist = CCorePlugin.getDefault().getProcessList();
        }
        catch (CoreException e) {
            GdbUIPlugin.errorDialog(LaunchMessages.getString((String)"LocalAttachLaunchDelegate.CDT_Launch_Error"), e.getStatus());
        }
        if (plist == null) {
            MessageDialog.openError((Shell)shell, (String)LaunchMessages.getString((String)"LocalAttachLaunchDelegate.CDT_Launch_Error"), (String)LaunchMessages.getString((String)"LocalAttachLaunchDelegate.Platform_cannot_list_processes"));
            return null;
        }
        dialog.setElements((Object[])plist.getProcessList());
        if (dialog.open() == 0 && (info = (IProcessInfo)dialog.getFirstResult()) != null) {
            return new Integer(info.getPid());
        }
        return null;
    }
}

