/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.actions;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IProcess;

public class GdbRestartCommand
implements IRestart {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final GdbLaunch fLaunch;

    public GdbRestartCommand(DsfSession session, GdbLaunch launch) {
        this.fExecutor = session.getExecutor();
        this.fLaunch = launch;
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public boolean canRestart() {
        Query<Boolean> canRestart = new Query<Boolean>(){

            protected void execute(DataRequestMonitor<Boolean> rm) {
                GDBControl gdbControl = (GDBControl)GdbRestartCommand.this.fTracker.getService(GDBControl.class);
                if (gdbControl != null) {
                    rm.setData((Object)gdbControl.canRestart());
                } else {
                    rm.setData((Object)false);
                }
                rm.done();
            }
        };
        this.fExecutor.execute((Runnable)canRestart);
        try {
            return (Boolean)canRestart.get();
        }
        catch (InterruptedException e1) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return false;
    }

    public void restart() throws DebugException {
        IProcess[] launchProcesses;
        final AtomicReference execPathRef = new AtomicReference();
        Query<Object> restartQuery = new Query<Object>(){

            protected void execute(DataRequestMonitor<Object> rm) {
                final GDBControl gdbControl = (GDBControl)GdbRestartCommand.this.fTracker.getService(GDBControl.class);
                if (gdbControl != null) {
                    execPathRef.set(gdbControl.getExecutablePath());
                    gdbControl.initInferiorInputOutput(new RequestMonitor((Executor)GdbRestartCommand.this.fExecutor, (RequestMonitor)rm, (DataRequestMonitor)rm){
                        final /* synthetic */ DataRequestMonitor val$rm;
                        {
                            this.val$rm = dataRequestMonitor;
                            super(x0, x1);
                        }

                        protected void handleSuccess() {
                            gdbControl.createInferiorProcess();
                            gdbControl.getCLICommandProcessor().resetInferior(gdbControl.getInferiorProcess());
                            gdbControl.restart(GdbRestartCommand.this.fLaunch, (RequestMonitor)this.val$rm);
                        }
                    });
                } else {
                    rm.done();
                }
            }
        };
        this.fExecutor.execute((Runnable)restartQuery);
        try {
            restartQuery.get();
        }
        catch (InterruptedException e1) {
        }
        catch (ExecutionException e1) {
            // empty catch block
        }
        String inferiorLabel = ((IPath)execPathRef.get()).lastSegment();
        for (IProcess p : launchProcesses = this.fLaunch.getProcesses()) {
            if (!p.getLabel().equals(inferiorLabel)) continue;
            this.fLaunch.removeProcess(p);
            break;
        }
        try {
            this.fLaunch.addInferiorProcess(inferiorLabel);
        }
        catch (CoreException e) {
            throw new DebugException(e.getStatus());
        }
    }
}

