/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.viewmodel.launch;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.gdb.internal.provisional.service.GDBRunControl;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControlDMContext;
import org.eclipse.dd.mi.service.command.MIInferiorProcess;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.IMemento;

public class ContainerVMNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementMementoProvider {
    private final String MEMENTO_NAME = "CONTAINER_MEMENTO_NAME";

    public ContainerVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IExecutionDMContext.class);
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        GDBControl controlService = (GDBControl)this.getServicesTracker().getService(GDBControl.class);
        if (controlService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        MIInferiorProcess inferiorProcess = controlService.getInferiorProcess();
        if (inferiorProcess != null && inferiorProcess.getState() != MIInferiorProcess.State.TERMINATED) {
            update.setChild((Object)this.createVMContext((IDMContext)inferiorProcess.getExecutionContext()), 0);
        }
        update.done();
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    ContainerVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            GDBRunControl runControl = (GDBRunControl)this.getServicesTracker().getService(GDBRunControl.class);
            if (runControl == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            GDBControlDMContext dmc = (GDBControlDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), GDBControlDMContext.class);
            String imageKey = null;
            imageKey = runControl.isSuspended((IRunControl.IExecutionDMContext)dmc) ? "IMG_OBJS_THREAD_SUSPENDED" : "IMG_OBJS_THREAD_RUNNING";
            update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
            runControl.getProcessData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<GDBRunControl.GDBProcessData>(this.getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        update.done();
                        return;
                    }
                    update.setLabel(((GDBRunControl.GDBProcessData)this.getData()).getName(), 0);
                    update.done();
                }
            });
        }
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent || e instanceof IRunControl.IContainerSuspendedDMEvent) {
            return 1024;
        }
        if (e instanceof GDBControl.GDBExitedEvent || e instanceof MIInferiorProcess.InferiorExitedDMEvent) {
            return 1024;
        }
        if (e instanceof GDBControl.GDBStartedEvent) {
            return 0x100000;
        }
        if (e instanceof MIInferiorProcess.InferiorStartedDMEvent) {
            return 0x300000;
        }
        if (e instanceof IRunControl.IStartedDMEvent || e instanceof IRunControl.IExitedDMEvent) {
            return 1024;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        IRunControl.IContainerDMContext containerCtx;
        if (e instanceof IRunControl.IContainerResumedDMEvent || e instanceof IRunControl.IContainerSuspendedDMEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IDMEvent)e).getDMContext()), 1024);
        } else if (e instanceof GDBControl.GDBExitedEvent || e instanceof MIInferiorProcess.InferiorExitedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        } else if (e instanceof GDBControl.GDBStartedEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IDMEvent)e).getDMContext()), 0x100000);
        } else if (e instanceof MIInferiorProcess.InferiorStartedDMEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IDMEvent)e).getDMContext()), 0x300000);
        } else if ((e instanceof IRunControl.IStartedDMEvent || e instanceof IRunControl.IExitedDMEvent) && (containerCtx = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMEvent)e).getDMContext(), IRunControl.IContainerDMContext.class)) != null) {
            parentDelta.addNode((Object)this.createVMContext((IDMContext)containerCtx), 1024);
        }
        requestMonitor.done();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        for (final IElementCompareRequest request : requests) {
            IDMContext dmc;
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            final String mementoName = memento.getString("CONTAINER_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof GDBControlDMContext) {
                final GDBControlDMContext procDmc = (GDBControlDMContext)dmc;
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            GDBRunControl runControl = (GDBRunControl)ContainerVMNode.this.getServicesTracker().getService(GDBRunControl.class);
                            if (runControl != null) {
                                runControl.getProcessData(procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<GDBRunControl.GDBProcessData>((Executor)runControl.getExecutor(), (IViewerUpdate)request){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            request.setEqual(mementoName.equals("Container." + ((GDBRunControl.GDBProcessData)this.getData()).getName()));
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    request.done();
                }
                continue;
            }
            request.done();
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        for (final IElementMementoRequest request : requests) {
            IDMContext dmc;
            Object element = request.getElement();
            final IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof GDBControlDMContext) {
                final GDBControlDMContext procDmc = (GDBControlDMContext)dmc;
                try {
                    this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            GDBRunControl runControl = (GDBRunControl)ContainerVMNode.this.getServicesTracker().getService(GDBRunControl.class);
                            if (runControl != null) {
                                runControl.getProcessData(procDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<GDBRunControl.GDBProcessData>((Executor)runControl.getExecutor(), (IViewerUpdate)request){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            memento.putString("CONTAINER_MEMENTO_NAME", "Container." + ((GDBRunControl.GDBProcessData)this.getData()).getName());
                                        }
                                        request.done();
                                    }
                                });
                            } else {
                                request.done();
                            }
                        }
                    });
                }
                catch (RejectedExecutionException e) {
                    request.done();
                }
                continue;
            }
            request.done();
        }
    }
}

