/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.launching;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.launching.ShutdownSequence;
import org.eclipse.dd.gdb.service.command.GDBControl;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.ITerminate;

@ThreadSafe
public class GdbLaunch
extends Launch
implements ITerminate {
    private DefaultDsfExecutor fExecutor;
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private boolean fInitialized = false;
    private boolean fShutDown = false;

    public GdbLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
        DefaultDsfExecutor dsfExecutor = new DefaultDsfExecutor("org.eclipse.dd.gdb");
        dsfExecutor.prestartCoreThread();
        this.fExecutor = dsfExecutor;
        this.fSession = DsfSession.startSession((DsfExecutor)this.fExecutor, (String)"org.eclipse.dd.gdb");
    }

    public DsfExecutor getDsfExecutor() {
        return this.fExecutor;
    }

    @ConfinedToDsfExecutor(value="getExecutor")
    public void initializeControl() throws CoreException {
        DsfRunnable initRunnable = new DsfRunnable(){

            public void run() {
                GdbLaunch.this.fTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), GdbLaunch.this.fSession.getId());
                GdbLaunch.this.fSession.addServiceEventListener((Object)GdbLaunch.this, null);
                GdbLaunch.this.fInitialized = true;
                GdbLaunch.this.fireChanged();
            }
        };
        try {
            this.fExecutor.submit((Runnable)initRunnable).get();
        }
        catch (InterruptedException e) {
            new Status(4, "org.eclipse.dd.gdb", 10005, "Error initializing launch", (Throwable)e);
        }
        catch (ExecutionException e) {
            new Status(4, "org.eclipse.dd.gdb", 10005, "Error initializing launch", (Throwable)e);
        }
    }

    public DsfSession getSession() {
        return this.fSession;
    }

    @DsfServiceEventHandler
    public void eventDispatched(GDBControl.ExitedEvent event) {
        this.shutdownSession(new RequestMonitor(ImmediateExecutor.getInstance(), null));
    }

    public boolean canTerminate() {
        return super.canTerminate() && this.fInitialized && !this.fShutDown;
    }

    public boolean isTerminated() {
        return super.isTerminated() || this.fShutDown;
    }

    public void terminate() throws DebugException {
        if (this.fShutDown) {
            return;
        }
        super.terminate();
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void shutdownSession(final RequestMonitor rm) {
        if (this.fShutDown) {
            rm.done();
            return;
        }
        this.fShutDown = true;
        ShutdownSequence shutdownSeq = new ShutdownSequence(this.getDsfExecutor(), this.fSession.getId(), new RequestMonitor((Executor)this.fSession.getExecutor(), rm){

            public void handleCompleted() {
                GdbLaunch.this.fSession.removeServiceEventListener((Object)GdbLaunch.this);
                if (!this.getStatus().isOK()) {
                    GdbPlugin.getDefault().getLog().log((IStatus)new MultiStatus("org.eclipse.dd.gdb", -1, new IStatus[]{this.getStatus()}, "Session shutdown failed", null));
                }
                GdbLaunch.this.fTracker.dispose();
                GdbLaunch.this.fTracker = null;
                DsfSession.endSession((DsfSession)GdbLaunch.this.fSession);
                GdbLaunch.this.fExecutor.shutdown();
                GdbLaunch.this.fExecutor = null;
                GdbLaunch.this.fireTerminate();
                rm.setStatus(this.getStatus());
                rm.done();
            }
        });
        this.fExecutor.execute((Runnable)((Object)shutdownSeq));
    }

    public Object getAdapter(Class adapter) {
        Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        return super.getAdapter(adapter);
    }
}

