/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.service;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.service.command.GDBControl;
import org.eclipse.dd.gdb.service.command.GDBControlDMContext;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.MIRunControl;
import org.eclipse.dd.mi.service.command.commands.CLIInfoThreads;
import org.eclipse.dd.mi.service.command.events.MIThreadExitEvent;
import org.eclipse.dd.mi.service.command.output.CLIInfoThreadsInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBRunControl
extends MIRunControl {
    private GDBControl fGdb;
    private IRunControl.IExecutionDMContext[] fOldExecutionCtxts;

    public GDBRunControl(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            public void handleOK() {
                GDBRunControl.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fGdb = (GDBControl)this.getServicesTracker().getService(GDBControl.class);
        this.register(new String[]{IRunControl.class.getName(), MIRunControl.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public void suspend(IRunControl.IExecutionDMContext context, RequestMonitor requestMonitor) {
        if (this.canSuspend(context)) {
            this.fGdb.interrupt();
        } else {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10001, "Context cannot be suspended.", null));
        }
        requestMonitor.done();
    }

    public void getExecutionContexts(IRunControl.IContainerDMContext c, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm1 = new DataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                GDBRunControl.this.raiseExitEvents((IRunControl.IExecutionDMContext[])this.getData());
                GDBRunControl.access$202(GDBRunControl.this, (IRunControl.IExecutionDMContext[])this.getData());
                rm.setData((Object)GDBRunControl.this.fOldExecutionCtxts);
                rm.done();
            }
        };
        super.getExecutionContexts(c, (DataRequestMonitor)rm1);
    }

    public void getProcessData(GDBControlDMContext gdbDmc, DataRequestMonitor<GDBProcessData> rm) {
        rm.setData((Object)new GDBProcessData(this.fGdb.getExecutablePath().lastSegment()));
        rm.done();
    }

    public void getThreadData(final IMIExecutionDMContext execDmc, final DataRequestMonitor<GDBThreadData> rm) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)execDmc, IRunControl.IContainerDMContext.class);
        assert (containerDmc != null);
        this.getCache().execute((ICommand)new CLIInfoThreads(containerDmc), (DataRequestMonitor)new DataRequestMonitor<CLIInfoThreadsInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                rm.setData((Object)GDBRunControl.this.createThreadInfo(execDmc, (CLIInfoThreadsInfo)this.getData()));
                rm.done();
            }
        });
    }

    private GDBThreadData createThreadInfo(IMIExecutionDMContext dmc, CLIInfoThreadsInfo info) {
        for (CLIInfoThreadsInfo.ThreadInfo thread : info.getThreadInfo()) {
            if (Integer.parseInt(thread.getId()) != dmc.getThreadId()) continue;
            return new GDBThreadData(thread.getOsId(), thread.getName());
        }
        return new GDBThreadData("", "");
    }

    private void raiseExitEvents(IRunControl.IExecutionDMContext[] ctxts) {
        if (ctxts == null || this.fOldExecutionCtxts == null) {
            return;
        }
        List<IRunControl.IExecutionDMContext> list = Arrays.asList(ctxts);
        List<IRunControl.IExecutionDMContext> oldThreadList = Arrays.asList(this.fOldExecutionCtxts);
        for (IRunControl.IExecutionDMContext ctxt : oldThreadList) {
            if (list.contains(ctxt)) continue;
            IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)ctxt, IRunControl.IContainerDMContext.class);
            MIThreadExitEvent e = new MIThreadExitEvent(containerDmc, ((IMIExecutionDMContext)ctxt).getThreadId());
            this.getSession().dispatchEvent((Object)e, this.getProperties());
        }
    }

    static /* synthetic */ IRunControl.IExecutionDMContext[] access$202(GDBRunControl x0, IRunControl.IExecutionDMContext[] x1) {
        x0.fOldExecutionCtxts = x1;
        return x1;
    }

    public static class GDBProcessData {
        private final String fName;

        GDBProcessData(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }
    }

    public static class GDBThreadData {
        private final String fId;
        private final String fName;

        GDBThreadData(String id, String name) {
            this.fId = id;
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        public String getId() {
            return this.fId;
        }

        public boolean isDebuggerAttached() {
            return true;
        }
    }
}

