/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.launching;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.StepQueueManager;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.launching.GdbLaunch;
import org.eclipse.dd.gdb.service.GDBRunControl;
import org.eclipse.dd.gdb.service.command.GDBControl;
import org.eclipse.dd.mi.service.CSourceLookup;
import org.eclipse.dd.mi.service.ExpressionService;
import org.eclipse.dd.mi.service.MIBreakpoints;
import org.eclipse.dd.mi.service.MIBreakpointsManager;
import org.eclipse.dd.mi.service.MIMemory;
import org.eclipse.dd.mi.service.MIModules;
import org.eclipse.dd.mi.service.MIRegisters;
import org.eclipse.dd.mi.service.MIStack;
import org.eclipse.dd.mi.service.command.commands.MIBreakInsert;
import org.eclipse.dd.mi.service.command.commands.MIExecRun;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.dd.mi.service.command.output.MIInfo;

public class LaunchSequence
extends Sequence {
    Sequence.Step[] fSteps = new Sequence.Step[]{new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            LaunchSequence.this.fCommandControl = new GDBControl(LaunchSequence.this.fSession, LaunchSequence.this.getGDBPath(), LaunchSequence.this.fExecPath, GDBControl.SessionType.RUN, 30);
            LaunchSequence.this.fCommandControl.initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new GDBRunControl(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new StepQueueManager(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new MIMemory(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new MIModules(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new MIStack(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new ExpressionService(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            LaunchSequence.this.fSourceLookup = new CSourceLookup(LaunchSequence.this.fSession);
            LaunchSequence.this.fSourceLookup.initialize(requestMonitor);
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            LaunchSequence.this.fSourceLookup.setSourceLookupDirector((ISourceLookup.ISourceLookupDMContext)LaunchSequence.this.fCommandControl.getGDBDMContext(), (CSourceLookupDirector)LaunchSequence.this.fLaunch.getSourceLocator());
            requestMonitor.done();
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            MIBreakpoints bpService = new MIBreakpoints(LaunchSequence.this.fSession);
            bpService.initialize(new RequestMonitor((Executor)LaunchSequence.this.getExecutor(), requestMonitor){

                protected void handleOK() {
                    requestMonitor.done();
                }
            });
        }
    }, new Sequence.Step(){

        public void execute(final RequestMonitor requestMonitor) {
            final MIBreakpointsManager bpmService = new MIBreakpointsManager(LaunchSequence.this.fSession, "org.eclipse.cdt.debug.core");
            bpmService.initialize(new RequestMonitor((Executor)LaunchSequence.this.getExecutor(), requestMonitor){

                protected void handleOK() {
                    bpmService.startTrackingBreakpoints((IBreakpoints.IBreakpointsTargetDMContext)LaunchSequence.this.fCommandControl.getGDBDMContext(), requestMonitor);
                }
            });
        }
    }, new Sequence.Step(){

        public void execute(RequestMonitor requestMonitor) {
            new MIRegisters(LaunchSequence.this.fSession).initialize(requestMonitor);
        }
    }, new Sequence.Step(){
        private boolean fStopInMain = false;
        private String fStopSymbol = null;

        private boolean readStopAtMain(RequestMonitor requestMonitor) {
            try {
                this.fStopInMain = LaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve the entry point symbol", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        private boolean readStopSymbol(RequestMonitor requestMonitor) {
            try {
                this.fStopSymbol = LaunchSequence.this.fLaunch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 5014, "Cannot retrieve the entry point symbol", (Throwable)e));
                requestMonitor.done();
                return false;
            }
            return true;
        }

        public void execute(final RequestMonitor requestMonitor) {
            if (!this.readStopAtMain(requestMonitor)) {
                return;
            }
            if (!this.fStopInMain) {
                requestMonitor.done();
                return;
            }
            if (!this.readStopSymbol(requestMonitor)) {
                return;
            }
            final EntryPointHitEventListener entryPointHitListener = new EntryPointHitEventListener(requestMonitor);
            LaunchSequence.this.fSession.addServiceEventListener((Object)entryPointHitListener, null);
            LaunchSequence.this.fSession.getExecutor().schedule(new Runnable(){

                public void run() {
                    if (!entryPointHitListener.fFinished) {
                        entryPointHitListener.fAborted = true;
                        LaunchSequence.this.fSession.removeServiceEventListener((Object)entryPointHitListener);
                        requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 5010, "Timed out running to entry point.", null));
                        requestMonitor.done();
                    }
                }
            }, 60L, TimeUnit.SECONDS);
            LaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIBreakInsert((IBreakpoints.IBreakpointsTargetDMContext)LaunchSequence.this.fCommandControl.getControlDMContext(), true, false, null, 0, this.fStopSymbol, 0), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)LaunchSequence.this.getExecutor(), requestMonitor){

                protected void handleOK() {
                    LaunchSequence.this.fCommandControl.queueCommand((ICommand)new MIExecRun((IRunControl.IExecutionDMContext)((IRunControl.IContainerDMContext)LaunchSequence.this.fCommandControl.getControlDMContext()), new String[0]), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)LaunchSequence.this.getExecutor(), requestMonitor){

                        protected void handleOK() {
                        }
                    });
                }
            });
        }
    }};
    DsfSession fSession;
    GdbLaunch fLaunch;
    IPath fExecPath;
    GDBControl fCommandControl;
    CSourceLookup fSourceLookup;

    public LaunchSequence(DsfSession session, GdbLaunch launch, IPath execPath) {
        super(session.getExecutor());
        this.fSession = session;
        this.fLaunch = launch;
        this.fExecPath = execPath;
    }

    public Sequence.Step[] getSteps() {
        return this.fSteps;
    }

    private IPath getGDBPath() {
        Path retVal = new Path("gdb.exe");
        try {
            retVal = new Path(this.fLaunch.getLaunchConfiguration().getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb"));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return retVal;
    }

    public class EntryPointHitEventListener {
        boolean fAborted = false;
        boolean fFinished = false;
        final RequestMonitor fRequestMonitor;

        EntryPointHitEventListener(RequestMonitor requestMonitor) {
            this.fRequestMonitor = requestMonitor;
        }

        @DsfServiceEventHandler
        public void eventDispatched(MIStoppedEvent e) {
            this.fFinished = true;
            if (!this.fAborted) {
                LaunchSequence.this.fSession.removeServiceEventListener((Object)this);
                this.fRequestMonitor.done();
            }
        }
    }
}

