/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.launching;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.gdb.internal.provisional.launching.FinalLaunchSequence;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchMessages;
import org.eclipse.dd.gdb.internal.provisional.launching.ServicesLaunchSequence;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class GdbLaunchDelegate
extends LaunchConfigurationDelegate
implements ILaunchConfigurationDelegate2 {
    public static final String GDB_DEBUG_MODEL_ID = "org.eclipse.dd.gdb";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("debug")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Launching debugger session", 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            this.launchDebugSession(config, launch, monitor);
        }
        finally {
            monitor.done();
        }
    }

    private void launchDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        GDBControl.SessionType sessionType = this.getSessionType(config);
        GdbLaunch launch = (GdbLaunch)l;
        if (sessionType == GDBControl.SessionType.REMOTE) {
            monitor.subTask("Debugging remote C/C++ application");
        } else {
            monitor.subTask("Debugging local C/C++ application");
        }
        ICProject project = LaunchUtils.verifyCProject(config);
        IPath exePath = LaunchUtils.verifyProgramPath(config, project);
        LaunchUtils.verifyBinary(config, exePath);
        monitor.worked(1);
        int pid = -1;
        if (sessionType == GDBControl.SessionType.ATTACH) {
            try {
                pid = config.getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
            }
            catch (CoreException e) {
                // empty catch block
            }
            if (pid == -1) {
                pid = this.promptForProcessID(config);
            }
            if (pid == -1) {
                throw new DebugException((IStatus)new Status(8, GDB_DEBUG_MODEL_ID, LaunchMessages.getString("LocalAttachLaunchDelegate.No_Process_ID_selected")));
            }
        }
        ServicesLaunchSequence servicesLaunchSequence = new ServicesLaunchSequence(launch.getSession(), launch, exePath);
        launch.getSession().getExecutor().execute((Runnable)((Object)servicesLaunchSequence));
        try {
            servicesLaunchSequence.get();
        }
        catch (InterruptedException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
        }
        catch (ExecutionException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in services launch sequence", e1.getCause()));
        }
        launch.initializeControl();
        launch.addCLIProcess("gdb");
        launch.addInferiorProcess(exePath.lastSegment());
        FinalLaunchSequence finalLaunchSequence = sessionType == GDBControl.SessionType.ATTACH ? new FinalLaunchSequence(launch.getSession().getExecutor(), launch, pid) : new FinalLaunchSequence(launch.getSession().getExecutor(), launch, sessionType);
        launch.getSession().getExecutor().execute((Runnable)((Object)finalLaunchSequence));
        try {
            finalLaunchSequence.get();
        }
        catch (InterruptedException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
        }
        catch (ExecutionException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in final launch sequence", e1.getCause()));
        }
    }

    private GDBControl.SessionType getSessionType(ILaunchConfiguration config) {
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("run")) {
                return GDBControl.SessionType.RUN;
            }
            if (debugMode.equals("attach")) {
                return GDBControl.SessionType.ATTACH;
            }
            if (debugMode.equals("core")) {
                return GDBControl.SessionType.CORE;
            }
            if (debugMode.equals("remote")) {
                return GDBControl.SessionType.REMOTE;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return GDBControl.SessionType.RUN;
    }

    protected int promptForProcessID(ILaunchConfiguration config) throws CoreException {
        Object result;
        Status fPromptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
        Status processPrompt = new Status(1, "org.eclipse.dd.gdb.ui", 100, "", null);
        IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)fPromptStatus);
        if (prompter != null && (result = prompter.handleStatus((IStatus)processPrompt, (Object)config)) instanceof Integer) {
            return (Integer)result;
        }
        return -1;
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("debug") && this.getSessionType(config) == GDBControl.SessionType.CORE) {
            return true;
        }
        return super.preLaunchCheck(config, mode, monitor);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        ISourceLocator locator = this.getSourceLocator(configuration);
        return new GdbLaunch(configuration, mode, locator);
    }

    private ISourceLocator getSourceLocator(ILaunchConfiguration configuration) throws CoreException {
        String type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, (String)null);
        if (type == null) {
            type = configuration.getType().getSourceLocatorId();
        }
        if (type != null) {
            IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type);
            String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, (String)null);
            if (memento == null) {
                locator.initializeDefaults(configuration);
            } else if (locator instanceof IPersistableSourceLocator2) {
                ((IPersistableSourceLocator2)locator).initializeFromMemento(memento, configuration);
            } else {
                locator.initializeFromMemento(memento);
            }
            return locator;
        }
        return null;
    }

    private HashSet<IProject> getReferencedProjectSet(IProject proj, HashSet<IProject> referencedProjSet) throws CoreException {
        IProject[] projects;
        referencedProjSet.add(proj);
        for (IProject refProject : projects = proj.getReferencedProjects()) {
            if (!refProject.exists() || referencedProjSet.contains(refProject)) continue;
            this.getReferencedProjectSet(refProject, referencedProjSet);
        }
        return referencedProjSet;
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IProject[] orderedProjects = null;
        ArrayList<IProject> orderedProjList = null;
        ICProject cProject = LaunchUtils.verifyCProject(configuration);
        if (cProject != null) {
            HashSet<IProject> projectSet = this.getReferencedProjectSet(cProject.getProject(), new HashSet<IProject>());
            String[] orderedNames = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
            if (orderedNames != null) {
                ArrayList<IProject> unorderedProjects = new ArrayList<IProject>(projectSet.size());
                unorderedProjects.addAll(projectSet);
                orderedProjList = new ArrayList<IProject>(projectSet.size());
                block0: for (String projectName : orderedNames) {
                    for (IProject proj : unorderedProjects) {
                        if (!proj.getName().equals(projectName)) continue;
                        orderedProjList.add(proj);
                        unorderedProjects.remove(proj);
                        continue block0;
                    }
                }
                orderedProjList.addAll(unorderedProjects);
                orderedProjects = orderedProjList.toArray(new IProject[orderedProjList.size()]);
            } else {
                IProject[] projects = projectSet.toArray(new IProject[projectSet.size()]);
                orderedProjects = ResourcesPlugin.getWorkspace().computeProjectOrder((IProject[])projects).projects;
            }
        }
        return orderedProjects;
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.getBuildOrder(configuration, mode);
    }

    protected boolean existsProblems(IProject proj) throws CoreException {
        IMarker[] markers = proj.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers.length > 0) {
            for (IMarker marker : markers) {
                Integer severity = (Integer)marker.getAttribute("severity");
                if (severity == null) continue;
                return severity >= 2;
            }
        }
        return false;
    }

    private static class LaunchUtils {
        private LaunchUtils() {
        }

        public static ICProject verifyCProject(ILaunchConfiguration configuration) throws CoreException {
            ICProject cproject;
            String name = LaunchUtils.getProjectName(configuration);
            if (name == null) {
                LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.C_Project_not_specified"), null, 102);
            }
            if ((cproject = LaunchUtils.getCProject(configuration)) == null) {
                IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!proj.exists()) {
                    LaunchUtils.abort(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Project_NAME_does_not_exist", name), null, 103);
                } else if (!proj.isOpen()) {
                    LaunchUtils.abort(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Project_NAME_is_closed", name), null, 103);
                }
                LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Not_a_C_CPP_project"), null, 103);
            }
            return cproject;
        }

        public static IPath verifyProgramPath(ILaunchConfiguration configuration, ICProject cproject) throws CoreException {
            Path programPath;
            String programName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", (String)null);
            if (programName == null) {
                LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_not_specified"), null, 103);
            }
            if ((programPath = new Path(programName)).isEmpty()) {
                LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_does_not_exist"), null, 103);
            }
            if (!programPath.isAbsolute()) {
                IFile wsProgramPath = cproject.getProject().getFile((IPath)programPath);
                programPath = wsProgramPath.getLocation();
            }
            if (!programPath.toFile().exists()) {
                LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_file_does_not_exist"), new FileNotFoundException(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.PROGRAM_PATH_not_found", programPath.toOSString())), 104);
            }
            return programPath;
        }

        public static IBinaryParser.IBinaryObject verifyBinary(ILaunchConfiguration configuration, IPath exePath) throws CoreException {
            ICExtensionReference[] parserRefs;
            for (ICExtensionReference parserRef : parserRefs = CCorePlugin.getDefault().getBinaryParserExtensions(LaunchUtils.getCProject(configuration).getProject())) {
                try {
                    IBinaryParser parser = (IBinaryParser)parserRef.createExtension();
                    IBinaryParser.IBinaryObject exe = (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
                    if (exe == null) continue;
                    return exe;
                }
                catch (ClassCastException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            IBinaryParser parser = CCorePlugin.getDefault().getDefaultBinaryParser();
            try {
                return (IBinaryParser.IBinaryObject)parser.getBinary(exePath);
            }
            catch (ClassCastException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            LaunchUtils.abort(LaunchMessages.getString("AbstractCLaunchDelegate.Program_is_not_a_recognized_executable"), new FileNotFoundException(LaunchMessages.getFormattedString("AbstractCLaunchDelegate.Program_is_not_a_recognized_executable", exePath.toOSString())), 107);
            return null;
        }

        private static void abort(String message, Throwable exception, int code) throws CoreException {
            MultiStatus status = new MultiStatus(GdbLaunchDelegate.GDB_DEBUG_MODEL_ID, code, message, exception);
            status.add((IStatus)new Status(4, GdbLaunchDelegate.GDB_DEBUG_MODEL_ID, code, exception == null ? "" : exception.getLocalizedMessage(), exception));
            throw new CoreException((IStatus)status);
        }

        private static ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
            String projectName = LaunchUtils.getProjectName(configuration);
            if (projectName != null && (projectName = projectName.trim()).length() > 0) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
                if (cProject != null && cProject.exists()) {
                    return cProject;
                }
            }
            return null;
        }

        private static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
            return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", (String)null);
        }
    }
}

