/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service.command;

import java.io.IOException;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.Sequence;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.provisional.service.IGDBBackend;
import org.eclipse.dd.gdb.internal.provisional.service.SessionType;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControlDMContext;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBInferiorProcess;
import org.eclipse.dd.gdb.internal.provisional.service.command.IGDBControl;
import org.eclipse.dd.mi.service.IMIBackend;
import org.eclipse.dd.mi.service.IMIContainerDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.MIProcesses;
import org.eclipse.dd.mi.service.command.AbstractCLIProcess;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.CLIEventProcessor;
import org.eclipse.dd.mi.service.command.MIBackendCLIProcess;
import org.eclipse.dd.mi.service.command.MIControlDMContext;
import org.eclipse.dd.mi.service.command.MIInferiorProcess;
import org.eclipse.dd.mi.service.command.MIRunControlEventProcessor;
import org.eclipse.dd.mi.service.command.commands.MIBreakInsert;
import org.eclipse.dd.mi.service.command.commands.MICommand;
import org.eclipse.dd.mi.service.command.commands.MIExecContinue;
import org.eclipse.dd.mi.service.command.commands.MIExecRun;
import org.eclipse.dd.mi.service.command.commands.MIGDBExit;
import org.eclipse.dd.mi.service.command.commands.MIInferiorTTYSet;
import org.eclipse.dd.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.osgi.framework.BundleContext;

public class GDBControl
extends AbstractMIControl
implements IGDBControl {
    private GDBControlDMContext fControlDmc;
    private IGDBBackend fMIBackend;
    private boolean fConnected = true;
    private MIRunControlEventProcessor fMIEventProcessor;
    private CLIEventProcessor fCLICommandProcessor;
    private AbstractCLIProcess fCLIProcess;
    private MIInferiorProcess fInferiorProcess = null;
    private PTY fPty;

    public GDBControl(DsfSession session, ILaunchConfiguration config) {
        super(session, false);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleSuccess() {
                GDBControl.this.doInitialize(requestMonitor);
            }
        });
    }

    public void doInitialize(RequestMonitor requestMonitor) {
        this.fMIBackend = (IGDBBackend)this.getServicesTracker().getService(IGDBBackend.class);
        this.fControlDmc = new GDBControlDMContext(this.getSession().getId(), this.getId());
        final Sequence.Step[] initializeSteps = new Sequence.Step[]{new CommandMonitoringStep(InitializationShutdownStep.Direction.INITIALIZING), new InferiorInputOutputInitStep(InitializationShutdownStep.Direction.INITIALIZING), new CommandProcessorsStep(InitializationShutdownStep.Direction.INITIALIZING), new RegisterStep(InitializationShutdownStep.Direction.INITIALIZING)};
        Sequence startupSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return initializeSteps;
            }
        };
        this.getExecutor().execute((Runnable)startupSequence);
    }

    public void shutdown(RequestMonitor requestMonitor) {
        final Sequence.Step[] shutdownSteps = new Sequence.Step[]{new RegisterStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandProcessorsStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new InferiorInputOutputInitStep(InitializationShutdownStep.Direction.SHUTTING_DOWN), new CommandMonitoringStep(InitializationShutdownStep.Direction.SHUTTING_DOWN)};
        Sequence shutdownSequence = new Sequence(this.getExecutor(), requestMonitor){

            public Sequence.Step[] getSteps() {
                return shutdownSteps;
            }
        };
        this.getExecutor().execute((Runnable)shutdownSequence);
    }

    public String getId() {
        return this.fMIBackend.getId();
    }

    public MIControlDMContext getControlDMContext() {
        return this.fControlDmc;
    }

    public ICommandControlService.ICommandControlDMContext getContext() {
        return this.fControlDmc;
    }

    public void terminate(final RequestMonitor rm) {
        final ScheduledFuture quitTimeoutFuture = this.getExecutor().schedule((Runnable)new DsfRunnable(){

            public void run() {
                GDBControl.this.fMIBackend.destroy();
                rm.done();
            }

            protected boolean isExecutionRequired() {
                return false;
            }
        }, 2L, TimeUnit.SECONDS);
        this.queueCommand((ICommand)new MIGDBExit((IDMContext)this.fControlDmc), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            public void handleCompleted() {
                if (quitTimeoutFuture.cancel(false)) {
                    if (!this.isSuccess()) {
                        GDBControl.this.fMIBackend.destroy();
                    }
                    rm.done();
                }
            }
        });
    }

    public void initInferiorInputOutput(final RequestMonitor requestMonitor) {
        if (this.fMIBackend.getSessionType() == SessionType.REMOTE || this.fMIBackend.getIsAttachSession()) {
            this.fPty = null;
            requestMonitor.done();
        } else {
            try {
                this.fPty = new PTY();
                this.queueCommand((ICommand)new MIInferiorTTYSet((ICommandControlService.ICommandControlDMContext)this.fControlDmc, this.fPty.getSlaveName()), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor){

                    protected void handleFailure() {
                        GDBControl.this.fPty = null;
                        requestMonitor.done();
                    }
                });
            }
            catch (IOException e) {
                this.fPty = null;
                requestMonitor.done();
            }
        }
    }

    public boolean canRestart() {
        if (this.fMIBackend.getIsAttachSession()) {
            return false;
        }
        return this.fMIBackend.getSessionType() != SessionType.REMOTE;
    }

    public void start(GdbLaunch launch, RequestMonitor requestMonitor) {
        this.startOrRestart(launch, false, requestMonitor);
    }

    public void restart(GdbLaunch launch, RequestMonitor requestMonitor) {
        this.startOrRestart(launch, true, requestMonitor);
    }

    protected void startOrRestart(GdbLaunch launch, boolean restart, RequestMonitor requestMonitor) {
        if (this.fMIBackend.getIsAttachSession()) {
            requestMonitor.done();
            return;
        }
        DsfServicesTracker servicesTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.getSession().getId());
        IMIProcesses procService = (IMIProcesses)servicesTracker.getService(IMIProcesses.class);
        servicesTracker.dispose();
        IProcesses.IProcessDMContext procDmc = procService.createProcessContext((ICommandControlService.ICommandControlDMContext)this.fControlDmc, "");
        IMIContainerDMContext containerDmc = procService.createContainerContext(procDmc, "");
        Object execCommand = this.fMIBackend.getSessionType() == SessionType.REMOTE ? new MIExecContinue((IRunControl.IExecutionDMContext)containerDmc) : new MIExecRun((IRunControl.IExecutionDMContext)containerDmc, new String[0]);
        boolean stopInMain = false;
        try {
            stopInMain = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
        }
        catch (CoreException e) {
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Cannot retrieve stop at entry point boolean", (Throwable)e));
            requestMonitor.done();
            return;
        }
        DataRequestMonitor<MIInfo> execMonitor = new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), requestMonitor, (IRunControl.IContainerDMContext)containerDmc){
            final /* synthetic */ IRunControl.IContainerDMContext val$containerDmc;
            {
                this.val$containerDmc = iContainerDMContext;
                super(x0, x1);
            }

            protected void handleSuccess() {
                GDBControl.this.getSession().dispatchEvent((Object)new MIProcesses.ContainerStartedDMEvent(this.val$containerDmc), GDBControl.this.getProperties());
                super.handleSuccess();
            }
        };
        if (!stopInMain) {
            this.queueCommand((ICommand)execCommand, (DataRequestMonitor)execMonitor);
        } else {
            String stopSymbol = null;
            try {
                stopSymbol = launch.getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", "main");
            }
            catch (CoreException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 5014, "Cannot retrieve the entry point symbol", (Throwable)e));
                requestMonitor.done();
                return;
            }
            this.queueCommand((ICommand)new MIBreakInsert((IBreakpoints.IBreakpointsTargetDMContext)this.fControlDmc, true, false, null, 0, stopSymbol, 0), (DataRequestMonitor)new DataRequestMonitor<MIBreakInsertInfo>((Executor)this.getExecutor(), requestMonitor, (MICommand)execCommand, (DataRequestMonitor)execMonitor){
                final /* synthetic */ MICommand val$execCommand;
                final /* synthetic */ DataRequestMonitor val$execMonitor;
                {
                    this.val$execCommand = mICommand;
                    this.val$execMonitor = dataRequestMonitor;
                    super(x0, x1);
                }

                protected void handleSuccess() {
                    GDBControl.this.queueCommand((ICommand)this.val$execCommand, this.val$execMonitor);
                }
            });
        }
    }

    public void createInferiorProcess() {
        this.fInferiorProcess = this.fPty == null ? new GDBInferiorProcess((ICommandControlService)this, this.fMIBackend, this.fMIBackend.getMIOutputStream()) : new GDBInferiorProcess((ICommandControlService)this, this.fMIBackend, this.fPty);
    }

    public boolean isConnected() {
        return this.fInferiorProcess.getState() != MIInferiorProcess.State.TERMINATED && this.fConnected;
    }

    public void setConnected(boolean connected) {
        this.fConnected = connected;
    }

    public AbstractCLIProcess getCLIProcess() {
        return this.fCLIProcess;
    }

    public MIInferiorProcess getInferiorProcess() {
        return this.fInferiorProcess;
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        this.stopCommandProcessing();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMIBackend.BackendStateChangedEvent e) {
        if (e.getState() == IMIBackend.State.TERMINATED && e.getBackendId().equals(this.fMIBackend.getId())) {
            this.getSession().dispatchEvent((Object)new GDBControlShutdownDMEvent((ICommandControlService.ICommandControlDMContext)this.fControlDmc), this.getProperties());
        }
    }

    protected class CommandMonitoringStep
    extends InitializationShutdownStep {
        CommandMonitoringStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        protected void initialize(RequestMonitor requestMonitor) {
            GDBControl.this.startCommandProcessing(GDBControl.this.fMIBackend.getMIInputStream(), GDBControl.this.fMIBackend.getMIOutputStream());
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.stopCommandProcessing();
            requestMonitor.done();
        }
    }

    protected class CommandProcessorsStep
    extends InitializationShutdownStep {
        CommandProcessorsStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor requestMonitor) {
            try {
                GDBControl.this.fCLIProcess = (AbstractCLIProcess)new MIBackendCLIProcess((ICommandControlService)GDBControl.this, (IMIBackend)GDBControl.this.fMIBackend);
            }
            catch (IOException e) {
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10004, "Failed to create CLI Process", (Throwable)e));
                requestMonitor.done();
                return;
            }
            GDBControl.this.createInferiorProcess();
            GDBControl.this.fCLICommandProcessor = new CLIEventProcessor((ICommandControlService)GDBControl.this, (ICommandControlService.ICommandControlDMContext)GDBControl.this.fControlDmc);
            GDBControl.this.fMIEventProcessor = new MIRunControlEventProcessor((AbstractMIControl)GDBControl.this, (ICommandControlService.ICommandControlDMContext)GDBControl.this.fControlDmc);
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.fCLICommandProcessor.dispose();
            GDBControl.this.fMIEventProcessor.dispose();
            GDBControl.this.fCLIProcess.dispose();
            GDBControl.this.fInferiorProcess.dispose();
            requestMonitor.done();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GDBControlInitializedDMEvent
    extends AbstractDMEvent<ICommandControlService.ICommandControlDMContext>
    implements ICommandControlService.ICommandControlInitializedDMEvent {
        public GDBControlInitializedDMEvent(ICommandControlService.ICommandControlDMContext context) {
            super((IDMContext)context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GDBControlShutdownDMEvent
    extends AbstractDMEvent<ICommandControlService.ICommandControlDMContext>
    implements ICommandControlService.ICommandControlShutdownDMEvent {
        public GDBControlShutdownDMEvent(ICommandControlService.ICommandControlDMContext context) {
            super((IDMContext)context);
        }
    }

    protected class InferiorInputOutputInitStep
    extends InitializationShutdownStep {
        InferiorInputOutputInitStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        protected void initialize(RequestMonitor requestMonitor) {
            GDBControl.this.initInferiorInputOutput(requestMonitor);
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }
    }

    public static class InitializationShutdownStep
    extends Sequence.Step {
        private Direction fDirection;

        public InitializationShutdownStep(Direction direction) {
            this.fDirection = direction;
        }

        public final void execute(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.initialize(requestMonitor);
            } else {
                this.shutdown(requestMonitor);
            }
        }

        public final void rollBack(RequestMonitor requestMonitor) {
            if (this.fDirection == Direction.INITIALIZING) {
                this.shutdown(requestMonitor);
            } else {
                super.rollBack(requestMonitor);
            }
        }

        protected void initialize(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            requestMonitor.done();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Direction {
            INITIALIZING,
            SHUTTING_DOWN;

        }
    }

    protected class RegisterStep
    extends InitializationShutdownStep {
        RegisterStep(InitializationShutdownStep.Direction direction) {
            super(direction);
        }

        public void initialize(RequestMonitor requestMonitor) {
            GDBControl.this.getSession().addServiceEventListener((Object)GDBControl.this, null);
            GDBControl.this.register(new String[]{ICommandControl.class.getName(), ICommandControlService.class.getName(), AbstractMIControl.class.getName(), IGDBControl.class.getName()}, new Hashtable());
            GDBControl.this.getSession().dispatchEvent((Object)new GDBControlInitializedDMEvent((ICommandControlService.ICommandControlDMContext)GDBControl.this.fControlDmc), GDBControl.this.getProperties());
            requestMonitor.done();
        }

        protected void shutdown(RequestMonitor requestMonitor) {
            GDBControl.this.unregister();
            GDBControl.this.getSession().removeServiceEventListener((Object)GDBControl.this);
            requestMonitor.done();
        }
    }
}

