/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;
import org.eclipse.dd.ipxact.checker.core.object.SignalName;

public class Check65Visitor
extends CheckVisitor {
    public Check65Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) throws XPathExpressionException {
        Map<String, SignalName> signalNames = hierarchicalConnection.busInterface.getSignalNames();
        Map<String, SignalName> refSignalNames = hierarchicalConnection.refBusInterface.getSignalNames();
        if (signalNames != null && refSignalNames != null) {
            String message = Messages.Check65Visitor_0;
            for (String busSignalName : signalNames.keySet()) {
                if (refSignalNames.containsKey(busSignalName)) continue;
                this.reporter.report(CheckList.CHECK_65, null, MessageFormat.format(message, hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv(), busSignalName, hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
                ++this.problems;
            }
            for (String busSignalName : refSignalNames.keySet()) {
                if (signalNames.containsKey(busSignalName)) continue;
                this.reporter.report(CheckList.CHECK_65, null, MessageFormat.format(message, hierarchicalConnection.refBusInterface, hierarchicalConnection.refBusInterfaceDoc.getVlnv(), busSignalName, hierarchicalConnection.busInterface, hierarchicalConnection.busInterfaceDoc.getVlnv()));
                ++this.problems;
            }
        }
        return true;
    }
}

