/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CheckSignals {
    public static int checkSignalsDefinedForComponent(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:model/spirit:signals/spirit:signal");
        Node channelNode = checker.getNode(theDoc.getDocumentElement(), "//spirit:channels/spirit:channel");
        if (nodes.getLength() < 1 && channelNode == null) {
            reporter.report(CheckList.CHECK_INFORMATION, theDoc, Messages.CheckSignals_2);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkNoDuplicateSignalsInBusDefinition(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:signals/spirit:signal/spirit:logicalName");
        HashMap<String, Node> signals = new HashMap<String, Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node signalNameNode = nodes.item(i);
            String signalName = checker.getTextContent(signalNameNode);
            Node oldNode = signals.put(signalName, signalNameNode);
            if (oldNode == null) continue;
            reporter.report(CheckList.CHECK_ERROR, theDoc, MessageFormat.format(Messages.CheckSignals_4, signalName), signalNameNode);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkSignalsDefinedForBusDefinition(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        NodeList nodes = checker.getNodes(theDoc.getDocumentElement(), "//spirit:signals/spirit:signal");
        if (nodes.getLength() < 1) {
            reporter.report(CheckList.CHECK_INFORMATION, theDoc, Messages.CheckSignals_6);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkModelSignalConnectivity(DocumentChecker checker) throws XPathExpressionException {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        ICheckerReporter reporter = checker.getReporter();
        XPath xpath = checker.getXpathEvaluator();
        NodeList modelSignals = checker.getNodes(theDoc.getDocumentElement(), "//spirit:model/spirit:signals/spirit:signal");
        for (int i = 0; i < modelSignals.getLength(); ++i) {
            Node thisSignal = modelSignals.item(i);
            Node exportNode = checker.getNode(thisSignal, "spirit:export");
            boolean isExported = false;
            if (exportNode != null && !"false".equals(checker.getTextContent(exportNode))) {
                isExported = true;
            }
            String signalName = xpath.evaluate("spirit:name", thisSignal).trim();
            Node signalMapEntry = checker.getNode(theDoc.getDocumentElement(), "//spirit:componentSignalName[normalize-space(text())='" + signalName + "']");
            if (isExported && signalMapEntry != null) {
                reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckSignals_13, signalName), thisSignal);
                ++nErrors;
                continue;
            }
            if (isExported || signalMapEntry != null) continue;
            reporter.report(CheckList.CHECK_WARNING, theDoc, MessageFormat.format(Messages.CheckSignals_14, signalName), thisSignal);
            ++nErrors;
        }
        return nErrors;
    }
}

