/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.io.File;
import java.text.MessageFormat;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.CheckAddressing;
import org.eclipse.dd.ipxact.checker.core.CheckChannels;
import org.eclipse.dd.ipxact.checker.core.CheckHierarchy;
import org.eclipse.dd.ipxact.checker.core.CheckInterconnections;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.CheckMemoryMaps;
import org.eclipse.dd.ipxact.checker.core.CheckMonitorInterfaces;
import org.eclipse.dd.ipxact.checker.core.CheckRegisters;
import org.eclipse.dd.ipxact.checker.core.CheckSignals;
import org.eclipse.dd.ipxact.checker.core.CheckViews;
import org.eclipse.dd.ipxact.checker.core.CheckVlnv;
import org.eclipse.dd.ipxact.checker.core.FilePathResolver;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentChecker {
    private final SpiritLibrary theLibrary;
    private FilePathResolver resolver;
    private final SpiritDocument theDoc;
    private final ICheckerReporter reporter;
    private XPath xpathEvaluator;

    public DocumentChecker(SpiritLibrary theLibrary, SpiritDocument theDoc, ICheckerReporter reporter) throws Exception {
        this(theLibrary, theDoc, reporter, null);
    }

    public DocumentChecker(SpiritLibrary theLibrary, SpiritDocument theDoc, ICheckerReporter reporter, File filesetRoot) throws Exception {
        if (theLibrary == null) {
            throw new IllegalArgumentException("DocumentChecker(): Library is null");
        }
        if (theDoc == null) {
            throw new IllegalArgumentException("DocumentChecker(): theDoc is null");
        }
        if (reporter == null) {
            throw new IllegalArgumentException("DocumentChecker(): reporter is null");
        }
        this.theLibrary = theLibrary;
        this.theDoc = theDoc;
        this.reporter = reporter;
        this.resolver = new FilePathResolver(reporter);
        FileDetails fileDetails = theLibrary.getFileDetailsForVlnv(theDoc.getVlnv());
        if (filesetRoot != null) {
            this.resolver.setContext(filesetRoot);
        } else if (fileDetails != null) {
            this.resolver.setContext(fileDetails.getFile());
        }
        this.resolver.setSpiritDocument(theDoc);
    }

    public int check() throws Exception {
        int nErrors = 0;
        try {
            nErrors += CheckVlnv.checkVlnv(this);
            nErrors += CheckVlnv.checkLinkTypes(this);
            nErrors += CheckVlnv.checkFileRefs(this);
            if ("busDefinition".equals(this.theDoc.getRootTagName())) {
                nErrors += CheckSignals.checkSignalsDefinedForBusDefinition(this);
                nErrors += CheckSignals.checkNoDuplicateSignalsInBusDefinition(this);
            } else if ("component".equals(this.theDoc.getRootTagName())) {
                nErrors += CheckChannels.checkBusInterfaceSignals(this);
                nErrors += CheckChannels.checkChannelConnections(this);
                nErrors += CheckRegisters.checkRanges(this);
                nErrors += CheckMemoryMaps.checkMemoryMaps(this);
                nErrors += CheckSignals.checkSignalsDefinedForComponent(this);
                nErrors += CheckSignals.checkModelSignalConnectivity(this);
                nErrors += CheckAddressing.checkAddressing(this);
                nErrors += CheckHierarchy.checkHierarchy(this);
                nErrors += CheckViews.checkViews(this);
            } else if ("design".equals(this.theDoc.getRootTagName())) {
                nErrors += CheckInterconnections.checkInterfaceAttributes(this);
                nErrors += CheckInterconnections.checkInterfaceCompatibility(this);
                nErrors += CheckInterconnections.checkInterfaceUniqueness(this);
                nErrors += CheckInterconnections.checkInterfacePolarity(this);
                nErrors += CheckInterconnections.checkDirectConnections(this);
                nErrors += CheckMonitorInterfaces.checkMonitorConnections(this);
            }
        }
        catch (Exception e) {
            this.reporter.report(CheckList.CHECK_ERROR, this.theDoc, Messages.DocumentChecker_3 + e.toString());
            throw e;
        }
        return nErrors;
    }

    public SpiritLibrary getLibrary() {
        return this.theLibrary;
    }

    public SpiritDocument getSpiritDocument() {
        return this.theDoc;
    }

    public ICheckerReporter getReporter() {
        return this.reporter;
    }

    public FilePathResolver getFilePathResolver() {
        return this.resolver;
    }

    public void setFilePathResolver(FilePathResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        this.resolver = resolver;
    }

    public NodeList getNodes(Node baseNode, String xpath) throws XPathExpressionException {
        XPath evaluator = this.getXpathEvaluator();
        return (NodeList)evaluator.evaluate(xpath, baseNode, XPathConstants.NODESET);
    }

    public Node getNode(Node baseNode, String xpath) throws XPathExpressionException {
        XPath evaluator = this.getXpathEvaluator();
        return (Node)evaluator.evaluate(xpath, baseNode, XPathConstants.NODE);
    }

    public Vlnv getVlnvRef(Node node) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        XPath evaluator = this.getXpathEvaluator();
        Node vlnvNode = (Node)evaluator.evaluate("descendant-or-self::*[@spirit:vendor]", node, XPathConstants.NODE);
        if (vlnvNode != null) {
            return new Vlnv((Element)vlnvNode);
        }
        return null;
    }

    public String getName(Node node) throws XPathExpressionException {
        if (node == null) {
            return "";
        }
        XPath evaluator = this.getXpathEvaluator();
        return evaluator.evaluate("descendant-or-self::spirit:name/text()", node);
    }

    public SpiritDocument getLinkedDocument(Node linkNode) throws Exception {
        Vlnv linkRef = new Vlnv((Element)linkNode);
        SpiritDocument linkedDoc = this.theLibrary.get(linkRef);
        if (linkedDoc == null) {
            throw new Exception(MessageFormat.format(Messages.DocumentChecker_7, linkNode.getNodeName(), linkRef));
        }
        return linkedDoc;
    }

    public XPath getXpathEvaluator() {
        if (this.xpathEvaluator == null) {
            this.xpathEvaluator = this.theDoc.createXPath();
        }
        return this.xpathEvaluator;
    }

    public String getTextContent(Node node) {
        String text = null;
        try {
            text = this.getXpathEvaluator().evaluate("./text()", node);
            if (text != null) {
                text = text.trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }
}

