/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.object;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.eclipse.dd.ipxact.checker.core.object.SpiritNode;
import org.eclipse.dd.ipxact.checker.core.utils.Decode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Register
extends SpiritNode {
    private final List<Integer> dims = new ArrayList<Integer>(1);
    private final long addressOffset;
    private final int size;
    private final String access;
    private final String resetValue;
    private final String description;

    public Register(XPath evaluator, Node node) throws Exception {
        super(evaluator, node);
        String value;
        NodeList nodeList = (NodeList)evaluator.evaluate("spirit:dim/text()", node, XPathConstants.NODESET);
        int items = nodeList.getLength();
        if (items == 0) {
            this.addDim(1);
        } else {
            for (int index = 0; index < items; ++index) {
                value = nodeList.item(index).getNodeValue().trim();
                this.addDim(Integer.parseInt(value));
            }
        }
        value = this.evaluate("spirit:addressOffset");
        this.addressOffset = value.length() > 0 ? Decode.decode(value) : 0L;
        value = this.evaluate("spirit:size");
        this.size = value.length() > 0 ? Integer.parseInt(value) : 0;
        this.access = this.evaluate("spirit:access");
        this.resetValue = this.evaluate("spirit:reset/spirit:value");
        this.description = this.evaluate("spirit:description");
    }

    private void addDim(int dim) {
        this.dims.add(new Integer(dim));
    }

    public String getAccess() {
        return this.access;
    }

    public long getAddressOffset() {
        return this.addressOffset;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Integer> getDims() {
        return this.dims;
    }

    public String getResetValue() {
        return this.resetValue;
    }

    public int getSize() {
        return this.size;
    }
}

