/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.object;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;

public abstract class SpiritNode {
    protected final Node node;
    protected final XPath evaluator;
    protected String name;
    protected String context;

    protected SpiritNode(XPath evaluator, Node node) throws XPathExpressionException {
        this.node = node;
        this.evaluator = evaluator;
        this.name = this.evaluate("spirit:name");
        this.context = "";
    }

    public String evaluate(String expression) throws XPathExpressionException {
        return this.evaluator.evaluate(expression, this.node).trim();
    }

    public Node getNode() {
        return this.node;
    }

    public String getName() {
        return this.name;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.context != null && this.context.length() > 0) {
            sb.append(this.context);
            sb.append('/');
        }
        sb.append(this.name);
        return sb.toString();
    }
}

