/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.object;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.object.SignalName;
import org.eclipse.dd.ipxact.checker.core.object.SpiritNode;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusInterface
extends SpiritNode {
    private String type = "unknown";
    private Vlnv vlnv;
    private boolean isMirrored;
    private boolean isMaster;
    private boolean isSlave;
    private boolean isSystem;
    private boolean isMonitor;
    private List<String> masterRefs = new ArrayList<String>();
    private String addressSpaceRef = "";
    private String memoryMapRef = "";
    private String systemGroup = "";
    private String monitorInterfaceType = "";
    private String connectionType = "";
    private String index;
    private String bitSteering;
    private List<SignalName> signalMap;
    private Map<String, SignalName> signalNames;

    public BusInterface(XPath evaluator, Node node) throws XPathExpressionException {
        super(evaluator, node);
        this.init();
    }

    private void init() throws XPathExpressionException {
        Node busTypeNode = (Node)this.evaluator.evaluate("spirit:busType", this.node, XPathConstants.NODE);
        this.vlnv = new Vlnv((Element)busTypeNode);
        this.connectionType = this.evaluate("spirit:connection");
        this.index = this.evaluate("spirit:index");
        this.bitSteering = this.evaluate("spirit:bitSteering");
        if (this.isType("master")) {
            this.isMaster = true;
            this.addressSpaceRef = this.evaluate("spirit:master/spirit:addressSpaceRef/@spirit:addressSpaceRef");
            return;
        }
        if (this.isType("slave")) {
            this.isSlave = true;
            this.memoryMapRef = this.evaluate("spirit:slave/spirit:memoryMapRef/@spirit:memoryMapRef");
            NodeList masterRefNodes = (NodeList)this.evaluator.evaluate("spirit:slave/spirit:bridge/@spirit:masterRef", this.node, XPathConstants.NODESET);
            for (int mri = 0; mri < masterRefNodes.getLength(); ++mri) {
                this.masterRefs.add(masterRefNodes.item(mri).getNodeValue().trim());
            }
            return;
        }
        if (this.isType("system")) {
            this.isSystem = true;
            this.systemGroup = this.evaluate("spirit:system/spirit:group");
            return;
        }
        if (this.isType("mirroredMaster")) {
            this.isMaster = true;
            this.isMirrored = true;
            return;
        }
        if (this.isType("mirroredSlave")) {
            this.isSlave = true;
            this.isMirrored = true;
            return;
        }
        if (this.isType("mirroredSystem")) {
            this.isSystem = true;
            this.isMirrored = true;
            this.systemGroup = this.evaluate("spirit:mirroredSystem/spirit:group");
            return;
        }
        if (this.isType("monitor")) {
            this.isMonitor = true;
            this.systemGroup = this.evaluate("spirit:monitor/spirit:group");
            this.monitorInterfaceType = this.evaluate("spirit:monitor/@spirit:interfaceType");
            return;
        }
    }

    private boolean isType(String typeToTest) throws XPathExpressionException {
        boolean isType;
        boolean bl = isType = this.evaluator.evaluate("spirit:" + typeToTest, this.node, XPathConstants.NODE) != null;
        if (isType) {
            this.type = typeToTest;
        }
        return isType;
    }

    public String getType() {
        return this.type;
    }

    public boolean isMaster() {
        return this.isMaster && !this.isMirrored;
    }

    public boolean isSlave() {
        return this.isSlave && !this.isMirrored;
    }

    public boolean isSystem() {
        return this.isSystem && !this.isMirrored;
    }

    public boolean isMirroredMaster() {
        return this.isMaster && this.isMirrored;
    }

    public boolean isMirroredSlave() {
        return this.isSlave && this.isMirrored;
    }

    public boolean isMirroredSystem() {
        return this.isSystem && this.isMirrored;
    }

    public boolean isMirrored() {
        return this.isMirrored;
    }

    public boolean isMonitor() {
        return this.isMonitor;
    }

    public Vlnv getVlnv() {
        return this.vlnv;
    }

    public List<String> getMasterRefs() {
        return this.masterRefs;
    }

    public String getMemoryMapRef() {
        return this.memoryMapRef;
    }

    public String getAddressSpaceRef() {
        return this.addressSpaceRef;
    }

    public String getSystemGroup() {
        return this.systemGroup;
    }

    public String getMonitorInterfaceType() {
        return this.monitorInterfaceType;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getIndex() {
        return this.index;
    }

    public String getBitSteering() {
        return this.bitSteering;
    }

    public List<SignalName> getSignalMap() throws XPathExpressionException {
        Node signalMapNode;
        if (this.signalMap == null && (signalMapNode = (Node)this.evaluator.evaluate("spirit:signalMap", this.node, XPathConstants.NODE)) != null) {
            this.signalMap = new ArrayList<SignalName>();
            NodeList signalNameList = (NodeList)this.evaluator.evaluate("spirit:signalName", signalMapNode, XPathConstants.NODESET);
            for (int sni = 0; sni < signalNameList.getLength(); ++sni) {
                SignalName signalName = new SignalName(this.evaluator, signalNameList.item(sni));
                this.signalMap.add(signalName);
            }
        }
        return this.signalMap;
    }

    public Map<String, SignalName> getSignalNames() throws XPathExpressionException {
        if (this.signalNames == null) {
            this.getSignalMap();
            if (this.signalMap == null) {
                return null;
            }
            this.signalNames = new LinkedHashMap<String, SignalName>();
            for (SignalName signalName : this.signalMap) {
                this.signalNames.put(signalName.getBusSignalName(), signalName);
            }
        }
        return this.signalNames;
    }
}

