/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.object.ComponentSignal;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Utilities {
    public static Node getComponentInstance(DocumentChecker checker, Document designDocument, String instanceName) throws XPathExpressionException {
        return checker.getNode(designDocument.getDocumentElement(), "//spirit:componentInstances/spirit:componentInstance[normalize-space(spirit:instanceName)=\"" + instanceName + "\"]");
    }

    public static Node getBusInterface(DocumentChecker checker, Document componentDocument, String name) throws XPathExpressionException {
        return checker.getNode(componentDocument.getDocumentElement(), "//spirit:busInterfaces/spirit:busInterface[normalize-space(spirit:name)=\"" + name + "\"]");
    }

    public static Element getBusInterfaceForActiveInterface(DocumentChecker checker, Node activeInterfaceNode) throws XPathExpressionException {
        SpiritLibrary library = checker.getLibrary();
        Node componentRefNode = checker.getNode(activeInterfaceNode, "@spirit:componentRef");
        Node busRefNode = checker.getNode(activeInterfaceNode, "@spirit:busRef");
        if (componentRefNode == null) {
            return null;
        }
        Node componentInstanceNode = Utilities.getComponentInstance(checker, checker.getSpiritDocument().getBaseDocument(), componentRefNode.getNodeValue().trim());
        if (componentInstanceNode == null) {
            return null;
        }
        Vlnv componentVlnv = checker.getVlnvRef(componentInstanceNode);
        if (componentVlnv == null) {
            return null;
        }
        SpiritDocument componentDoc = library.get(componentVlnv);
        if (componentDoc == null) {
            return null;
        }
        Node busInterface = Utilities.getBusInterface(checker, componentDoc.getBaseDocument(), busRefNode.getNodeValue().trim());
        if (busInterface == null) {
            return null;
        }
        return (Element)busInterface;
    }

    public static SpiritDocument getComponentDocumentForHierConnection(DocumentChecker checker, Node hierConnection) throws XPathExpressionException {
        SpiritLibrary library = checker.getLibrary();
        Node componentRefNode = checker.getNode(hierConnection, "spirit:componentRef/text()");
        if (componentRefNode == null) {
            return null;
        }
        Node componentInstanceNode = Utilities.getComponentInstance(checker, componentRefNode.getOwnerDocument(), componentRefNode.getNodeValue().trim());
        if (componentInstanceNode == null) {
            return null;
        }
        Vlnv componentVlnv = checker.getVlnvRef(componentInstanceNode);
        if (componentVlnv == null) {
            return null;
        }
        return library.get(componentVlnv);
    }

    public static Vlnv getBusTypeVlnvForActiveInterface(DocumentChecker checker, Node activeInterfaceNode) throws XPathExpressionException {
        Element busInterface = Utilities.getBusInterfaceForActiveInterface(checker, activeInterfaceNode);
        if (busInterface == null) {
            return null;
        }
        return checker.getVlnvRef(busInterface);
    }

    public static Node getAddressSpace(DocumentChecker checker, Document componentDocument, String name) throws XPathExpressionException {
        return checker.getNode(componentDocument.getDocumentElement(), "//spirit:addressSpaces/spirit:addressSpace[normalize-space(spirit:name)=\"" + name + "\"]");
    }

    public static Node getMemoryMap(DocumentChecker checker, Document componentDocument, String name) throws XPathExpressionException {
        return checker.getNode(componentDocument.getDocumentElement(), "//spirit:memoryMaps/spirit:memoryMap[normalize-space(spirit:name)=\"" + name + "\"]");
    }

    public static boolean areBusesCompatible(DocumentChecker checker, Vlnv busTypeFirst, Vlnv busTypeSecond) throws XPathExpressionException {
        if (busTypeFirst.equals((Object)busTypeSecond)) {
            return true;
        }
        if (Utilities.busExtends(checker, busTypeFirst, busTypeSecond)) {
            return true;
        }
        return Utilities.busExtends(checker, busTypeSecond, busTypeFirst);
    }

    private static boolean busExtends(DocumentChecker checker, Vlnv busTypeFirst, Vlnv busTypeSecond) throws XPathExpressionException {
        SpiritLibrary library = checker.getLibrary();
        SpiritDocument busTypeDoc = library.get(busTypeFirst);
        if (busTypeDoc == null) {
            return false;
        }
        Node extendsNode = checker.getNode(busTypeDoc.getDocumentElement(), "//spirit:extends");
        if (extendsNode == null) {
            return false;
        }
        Vlnv extendsVlnv = new Vlnv((Element)extendsNode);
        return extendsVlnv.equals((Object)busTypeSecond);
    }

    public static Map<String, ComponentSignal> getComponentSignals(SpiritDocument componentDocument) throws XPathExpressionException {
        XPath evaluator = componentDocument.createXPath();
        LinkedHashMap<String, ComponentSignal> componentSignals = new LinkedHashMap<String, ComponentSignal>();
        NodeList signalNodes = (NodeList)evaluator.evaluate("//spirit:signal", componentDocument.getBaseDocument().getDocumentElement(), XPathConstants.NODESET);
        int length = signalNodes.getLength();
        for (int index = 0; index < length; ++index) {
            Node signalNode = signalNodes.item(index);
            ComponentSignal componentSignal = new ComponentSignal(evaluator, signalNode);
            componentSignals.put(componentSignal.getName(), componentSignal);
        }
        return componentSignals;
    }

    public static int getSignalWidth(String leftValue, String rightValue) {
        if (leftValue == null || leftValue.length() == 0) {
            return 1;
        }
        if (rightValue == null || rightValue.length() == 0) {
            return 1;
        }
        int left = Integer.parseInt(leftValue);
        int right = Integer.parseInt(rightValue);
        return Math.max(left, right) - Math.min(left, right) + 1;
    }

    public static boolean compareNodes(Node left, Node right) {
        boolean isEqualNode = Utilities.isEqualNode(left, right);
        NodeList leftChildren = left.getChildNodes();
        int length = leftChildren.getLength();
        if (isEqualNode && length > 0) {
            NodeList rightChildren = right.getChildNodes();
            for (int index = 0; isEqualNode && index < length; isEqualNode &= Utilities.compareNodes(leftChildren.item(index), rightChildren.item(index)), ++index) {
            }
        }
        return isEqualNode;
    }

    private static boolean isEqualNode(Node left, Node right) {
        if (left == null || right == null) {
            return false;
        }
        if (left == right) {
            return true;
        }
        if (left.getNodeType() != right.getNodeType()) {
            return false;
        }
        if (!left.getNodeName().equals(right.getNodeName())) {
            return false;
        }
        if (left.getNamespaceURI() == null ? right.getNamespaceURI() != null : !left.getNamespaceURI().equals(right.getNamespaceURI())) {
            return false;
        }
        if (left.getPrefix() == null ? right.getPrefix() != null : !left.getPrefix().equals(right.getPrefix())) {
            return false;
        }
        if (left.getNodeValue() == null) {
            if (right.getNodeValue() != null) {
                return false;
            }
        } else {
            if (right.getNodeValue() == null) {
                return false;
            }
            if (!left.getNodeValue().trim().equals(right.getNodeValue().trim())) {
                return false;
            }
        }
        left.normalize();
        right.normalize();
        NamedNodeMap leftAttrs = left.getAttributes();
        NamedNodeMap rightAttrs = right.getAttributes();
        if (leftAttrs == null) {
            if (rightAttrs != null) {
                return false;
            }
        } else {
            if (rightAttrs == null) {
                return false;
            }
            if (leftAttrs.getLength() != rightAttrs.getLength()) {
                return false;
            }
            for (int index = 0; index < leftAttrs.getLength(); ++index) {
                if (Utilities.isEqualNode(leftAttrs.item(index), rightAttrs.item(index))) continue;
                return false;
            }
        }
        return left.getNodeType() != 1 || left.getChildNodes().getLength() == right.getChildNodes().getLength();
    }
}

