/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractorDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignConfigurationDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritRefNode;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.AbstractorInstance;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.Interconnection;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.InterconnectionConfiguration;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class CheckDesignConfig {
    public static int checkInterconnectionConfiguration(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDesignConfigurationDocument theDoc = (SpiritDesignConfigurationDocument)checker.getSpiritDocument();
        if (!theDoc.schemaVersion().equals((Object)SchemaInfo.IpxactVersion.BEFORE_V14)) {
            ICheckerReporter reporter = checker.getReporter();
            SpiritLibrary library = checker.getLibrary();
            SpiritRefNode designRef = theDoc.getDesignRef();
            try {
                SpiritDesignDocument designDoc = (SpiritDesignDocument)checker.getLinkedDocument((SpiritNode)designRef);
                NodeList interconnections = designDoc.getDescendants("interconnection");
                interconnections.getLength();
                List interconnectionConfigurations = theDoc.getInterconnectionConfigurations();
                for (InterconnectionConfiguration interconnectionConfiguration : interconnectionConfigurations) {
                    Vlnv abstractionVlnv2;
                    String interconnectionName = interconnectionConfiguration.getInterconnectionName();
                    Interconnection interconnection = designDoc.getInterconnection(interconnectionName);
                    Vlnv abstractionVlnv1 = interconnection.getPrimaryBusInterface(library).getAbstractionVlnv();
                    if (abstractionVlnv1.equals((Object)(abstractionVlnv2 = interconnection.getSecondaryBusInterface(library).getAbstractionVlnv()))) {
                        reporter.report(CheckList.CHECK_V14_312, (SpiritDocument)theDoc, Messages.CheckList_V14_312, (SpiritNode)interconnection);
                    }
                    Vlnv previousVlnv = abstractionVlnv1;
                    String interconnectionMode = interconnection.getMode(library);
                    HashSet<Vlnv> abstractorSet = new HashSet<Vlnv>();
                    List abstractorConfigs = interconnectionConfiguration.getAbstractorConfigurations();
                    boolean firstAbstractor = true;
                    for (AbstractorInstance abstractorInstance : abstractorConfigs) {
                        SpiritNode abstractorRefNode = abstractorInstance.getAbstractorRef();
                        try {
                            NodeList abstractionTypes;
                            Vlnv linkVlnv;
                            SpiritAbstractorDocument abstractorDoc = (SpiritAbstractorDocument)checker.getLinkedDocument(abstractorRefNode);
                            String abstractorMode = abstractorDoc.getMode();
                            if (!abstractorMode.equals(interconnectionMode)) {
                                String message = MessageFormat.format("Abstractor instance {0} (VLNV {1}) is a {2} mode abstractor, a {3} mode abstractor was expected", abstractorInstance.getName(), abstractorDoc.getVlnv(), abstractorMode, interconnectionMode);
                                if (interconnectionMode.equals("master")) {
                                    reporter.report(CheckList.CHECK_V14_308, (SpiritDocument)theDoc, message, abstractorRefNode);
                                } else if (interconnectionMode.equals("slave")) {
                                    reporter.report(CheckList.CHECK_V14_309, (SpiritDocument)theDoc, message, abstractorRefNode);
                                } else if (interconnectionMode.equals("system")) {
                                    reporter.report(CheckList.CHECK_V14_310, (SpiritDocument)theDoc, message, abstractorRefNode);
                                } else {
                                    reporter.report(CheckList.CHECK_V14_311, (SpiritDocument)theDoc, message, abstractorRefNode);
                                }
                                ++nErrors;
                            }
                            if (!Utilities.areBusesCompatible(checker, previousVlnv, linkVlnv = new Vlnv(SpiritNode.createSpiritNode((Element)((Element)(abstractionTypes = abstractorDoc.getDescendants("abstractionType")).item(0)))))) {
                                if (firstAbstractor) {
                                    reporter.report(CheckList.CHECK_V14_313, (SpiritDocument)theDoc, MessageFormat.format("The first abstractor reference of abstractor instance {0} (VLNV {1}) references {2} which is not compatible with {3}", abstractorInstance.getName(), abstractorDoc.getVlnv(), linkVlnv, previousVlnv), abstractorRefNode);
                                } else {
                                    reporter.report(CheckList.CHECK_V14_315, (SpiritDocument)theDoc, MessageFormat.format("The first abstractor reference of abstractor instance {0} (VLNV {1}) references {2} which is not compatible with {3}", abstractorInstance.getName(), abstractorDoc.getVlnv(), linkVlnv, previousVlnv), abstractorRefNode);
                                }
                            }
                            previousVlnv = new Vlnv(SpiritNode.createSpiritNode((Element)((Element)abstractionTypes.item(1))));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        Vlnv abstractorVlnv = new Vlnv(abstractorRefNode);
                        if (abstractorSet.contains(abstractorVlnv)) {
                            reporter.report(CheckList.CHECK_V14_316, (SpiritDocument)theDoc, Messages.CheckList_V14_316, abstractorRefNode);
                        } else {
                            abstractorSet.add(abstractorVlnv);
                        }
                        firstAbstractor = false;
                    }
                    if (Utilities.areBusesCompatible(checker, previousVlnv, abstractionVlnv2)) continue;
                    reporter.report(CheckList.CHECK_V14_314, (SpiritDocument)theDoc, Messages.CheckList_V14_314, (SpiritNode)interconnection);
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        return nErrors;
    }

    public static int checkInterconnectionRefs(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDesignConfigurationDocument theDoc = (SpiritDesignConfigurationDocument)checker.getSpiritDocument();
        if (!theDoc.schemaVersion().equals((Object)SchemaInfo.IpxactVersion.BEFORE_V14)) {
            ICheckerReporter reporter = checker.getReporter();
            SpiritRefNode designRefNode = theDoc.getDesignRef();
            try {
                SpiritDesignDocument design = (SpiritDesignDocument)checker.getLinkedDocument((SpiritNode)designRefNode);
                List interconnectionConfigs = theDoc.getInterconnectionConfigurations();
                for (InterconnectionConfiguration interconnectionConfig : interconnectionConfigs) {
                    if (design.getInterconnection(interconnectionConfig.getInterconnectionName()) != null) continue;
                    reporter.report(CheckList.CHECK_V14_307, (SpiritDocument)theDoc, MessageFormat.format(Messages.CheckList_V14_307, interconnectionConfig), (SpiritNode)designRefNode);
                    ++nErrors;
                }
            }
            catch (Exception e) {
                checker.getReporter().report(CheckList.CHECK_2, (SpiritDocument)theDoc, e.getMessage(), (SpiritNode)designRefNode);
                ++nErrors;
            }
        }
        return nErrors;
    }
}

