/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.ui.preferences;

import org.eclipse.dd.ipxact.checker.ui.Messages;
import org.eclipse.dd.ipxact.editor.core.utils.OSVariable;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.dd.ipxact.editor.ui.utils.LayoutHelper;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class NewVariableDialog
extends TitleAreaDialog {
    String initialVariableText = "";
    String initialValueText = "";
    String variableText;
    String valueText;
    Text variableTextControl;
    Text valueTextControl;

    public NewVariableDialog(Shell parentShell) {
        super(parentShell);
        NewVariableDialog.setDefaultImage((Image)SpiritUiPlugin.getImage((String)"spirit.gif"));
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.FilePathVariableFieldEditor_NewFilePathVariable);
        this.setTitle(Messages.FilePathVariableFieldEditor_NewFilePathVariable);
        this.setMessage(Messages.FilePathVariableFieldEditor_EnterANewVariable);
        Composite composite = (Composite)super.createDialogArea(parent);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewVariableDialog.this.validateInput(e);
            }
        };
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 8;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        innerComposite.setLayout((Layout)layout);
        LayoutHelper.makeLabel((Composite)innerComposite, (String)Messages.FilePathVariableFieldEditor_VariableColon);
        this.variableTextControl = new Text(innerComposite, 2048);
        this.variableTextControl.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.variableTextControl.addModifyListener(modifyListener);
        LayoutHelper.makeLabel((Composite)innerComposite, (String)Messages.FilePathVariableFieldEditor_ValueColon);
        this.valueTextControl = new Text(innerComposite, 2048);
        this.valueTextControl.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.valueTextControl.addModifyListener(modifyListener);
        ShellAdapter shellListener = new ShellAdapter(){
            boolean initialized = false;

            public void shellActivated(ShellEvent e) {
                if (!this.initialized) {
                    this.initialized = true;
                    NewVariableDialog.this.variableTextControl.setText(NewVariableDialog.this.initialVariableText);
                    NewVariableDialog.this.valueTextControl.setText(NewVariableDialog.this.initialValueText);
                }
            }
        };
        this.getShell().addShellListener((ShellListener)shellListener);
        NewVariableDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.setOkButtonEnabled(false);
        return control;
    }

    void validateInput(ModifyEvent e) {
        this.setErrorMessage(null);
        boolean isVariableValid = false;
        boolean isValueValid = false;
        this.variableText = this.variableTextControl.getText().trim();
        if (this.variableText.length() > 0 && !(isVariableValid = OSVariable.isValidVariableName((String)this.variableText))) {
            this.setErrorMessage(Messages.FilePathVariableFieldEditor_ValueFormatError);
        }
        this.valueText = this.valueTextControl.getText().trim();
        if (this.valueText.length() > 0) {
            isValueValid = true;
        }
        this.setOkButtonEnabled(isVariableValid && isValueValid);
    }

    void setOkButtonEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public String getValueText() {
        return this.valueText;
    }

    public void setValueText(String valueText) {
        this.initialValueText = valueText;
    }

    public String getVariableText() {
        return this.variableText;
    }

    public void setVariableText(String variableText) {
        this.initialVariableText = variableText;
    }
}

