/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.ui.actions;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dd.ipxact.checker.ui.views.Checker;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.ILocationProvider;

public class CheckDocumentActionDelegate
implements IEditorActionDelegate {
    private IEditorPart targetEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void run(IAction action) {
        if (this.targetEditor == null) {
            return;
        }
        IEditorInput editorInput = this.targetEditor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        ILocationProvider locationProvider = (ILocationProvider)editorInput.getAdapter(ILocationProvider.class);
        if (locationProvider == null) {
            return;
        }
        IPath location = locationProvider.getPath((Object)editorInput);
        if (location == null) {
            return;
        }
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
        if (iFile != null) {
            location = iFile.getLocation();
        }
        File file = location.toFile();
        FileDetails fileDetails = SpiritLibrary.getDefault().getFileDetailsForFile(file);
        if (fileDetails != null) {
            Checker.check(this.targetEditor.getSite().getPage(), fileDetails);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

