/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.ui.views;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.ipxact.checker.core.Check;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.ui.preferences.PreferencesSupport;
import org.eclipse.dd.ipxact.checker.ui.views.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocumentFactory;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.dd.ipxact.editor.ui.utils.EditorHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class Checker {
    static Set<IMarker> markers;

    public static void check(IWorkbenchPage page, FileDetails fileDetails) {
        IEditorPart editor = EditorHelper.openSpiritDocumentInEditor((IWorkbenchPage)page, (SpiritDocument)fileDetails.getSpiritDocument());
        Document xmlDocument = EditorHelper.getXmlDocument((IEditorPart)editor);
        if (xmlDocument != null) {
            new DocumentCheckJob(editor, xmlDocument, fileDetails).schedule();
        }
    }

    public static void clearCheckMarkers() {
        if (markers != null) {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor monitor) throws CoreException {
                    Set<IMarker> set = markers;
                    synchronized (set) {
                        Checker.clearMarkers();
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(r, null, 1, null);
            }
            catch (Exception e) {
                SpiritUiPlugin.logError((Throwable)e);
            }
        }
    }

    static void clearMarkers() {
        for (IMarker marker : markers) {
            try {
                marker.delete();
            }
            catch (Exception e) {
                SpiritUiPlugin.logError((Throwable)e);
            }
        }
        markers.clear();
    }

    static class DocumentCheckJob
    extends Job
    implements ICheckerReporter {
        private static final String CHECKER_MARKER_ID = "org.eclipse.dd.ipxact.checker.ui.checkerMarker";
        private final IEditorPart editor;
        private final Document xmlDocument;
        final IResource resource;

        public DocumentCheckJob(IEditorPart editor, Document xmlDocument, FileDetails fileDetails) {
            super(Messages.Checker_DocumentChecker);
            this.editor = editor;
            this.xmlDocument = xmlDocument;
            this.resource = FileDetails.getWorkspaceFile((File)fileDetails.getFile());
            if (markers == null) {
                markers = new HashSet<IMarker>();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.Checker_Cbeck, -1);
            try {
                monitor.subTask(Messages.Checker_Initializing);
                SpiritDocument spiritDocument = SpiritDocumentFactory.getFactory().create(this.xmlDocument);
                DocumentChecker documentChecker = new DocumentChecker(SpiritLibrary.getDefault(), spiritDocument, (ICheckerReporter)this);
                PreferencesSupport.initializeFromPreferences(documentChecker.getFilePathResolver());
                Set<IMarker> set = markers;
                synchronized (set) {
                    Checker.clearMarkers();
                    monitor.subTask(Messages.Checker_Validating);
                    if (!EditorHelper.isXmlValid((IEditorPart)this.editor)) {
                        this.report(CheckList.CHECK_ERROR, spiritDocument, Messages.Checker_ErrorXMLNotValid);
                    } else {
                        monitor.subTask(Messages.Checker_Checking);
                        documentChecker.check();
                    }
                }
            }
            catch (Exception e) {
                SpiritUiPlugin.logError((Throwable)e);
                monitor.setCanceled(true);
            }
            if (monitor.isCanceled()) {
                monitor.done();
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public void report(Check check, SpiritDocument document, String message) {
            this.createMarker(check, document, message, null);
        }

        public void report(Check check, SpiritDocument document, String message, Node node) {
            this.createMarker(check, document, message, node);
        }

        private void createMarker(Check check, SpiritDocument document, String message, Node node) {
            try {
                final HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("message", check.getId() + ':' + message + ' ');
                attributes.put("severity", new Integer(this.getSeverity(check.getSeverity())));
                attributes.put("location", check.getDescription());
                if (node != null) {
                    attributes.put("charStart", new Integer(EditorHelper.getStartOffset((Node)node)));
                    attributes.put("charEnd", new Integer(EditorHelper.getEndOffset((Node)node)));
                }
                IWorkspaceRunnable r = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = DocumentCheckJob.this.resource.createMarker(DocumentCheckJob.CHECKER_MARKER_ID);
                        marker.setAttributes(attributes);
                        markers.add(marker);
                    }
                };
                this.resource.getWorkspace().run(r, null, 1, null);
            }
            catch (Exception e) {
                SpiritUiPlugin.logError((Throwable)e);
            }
        }

        private int getSeverity(int checkSeverity) {
            switch (checkSeverity) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
            }
            return 0;
        }

        public void closeReport() {
        }
    }
}

