/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.document;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.dd.ipxact.editor.core.Messages;
import org.eclipse.dd.ipxact.editor.core.SpiritCorePlugin;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignConfigurationDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritGeneratorChainDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritGeneratorChangeListDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritLGIDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritPMDDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpiritDocumentFactory {
    private static SpiritDocumentFactory factory = null;
    private static HashMap<String, Class<?>> map = new HashMap();

    public static SpiritDocumentFactory getFactory() {
        if (factory == null) {
            factory = new SpiritDocumentFactory();
        }
        return factory;
    }

    private SpiritDocumentFactory() {
        this.registerDocumentClass(SpiritBusDefinitionDocument.class);
        this.registerDocumentClass(SpiritComponentDocument.class);
        this.registerDocumentClass(SpiritDesignConfigurationDocument.class);
        this.registerDocumentClass(SpiritDesignDocument.class);
        this.registerDocumentClass(SpiritGeneratorChainDocument.class);
        this.registerDocumentClass(SpiritGeneratorChangeListDocument.class);
        this.registerDocumentClass(SpiritLGIDocument.class);
        this.registerDocumentClass(SpiritPMDDocument.class);
    }

    public Iterator documentTypes() {
        return map.keySet().iterator();
    }

    private void registerDocumentClass(Class documentClass) {
        try {
            SpiritDocument theDoc = this.create(documentClass);
            String rootTagName = theDoc.getRootTagName();
            map.put(rootTagName, documentClass);
        }
        catch (Exception e) {
            SpiritCorePlugin.logError(MessageFormat.format(Messages.SpiritDocumentFactory_CouldNotRegisterClass, documentClass), e);
        }
    }

    public SpiritDocument create(Document xmlDoc) throws Exception {
        SpiritDocument theDoc = null;
        Element e = xmlDoc.getDocumentElement();
        String name = e.getLocalName();
        Class<?> classToCreate = map.get(name);
        if (classToCreate == null) {
            throw new Exception(MessageFormat.format(Messages.SpiritDocumentFactory_NotARegisteredDocumentType, name));
        }
        theDoc = this.create(classToCreate);
        if (theDoc != null) {
            theDoc.setBaseDocument(xmlDoc);
        }
        return theDoc;
    }

    public SpiritDocument create(String fileName) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(fileName);
        return this.create(document);
    }

    public SpiritDocument create(Class classToCreate) throws Exception {
        SpiritDocument theDoc = null;
        if (classToCreate == null) {
            throw new Exception(Messages.SpiritDocumentFactory_DocumentClassCannotBeNull);
        }
        theDoc = (SpiritDocument)classToCreate.newInstance();
        return theDoc;
    }
}

