/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.library;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDetails {
    private File file;
    private long lastModifiedTimestamp;
    private SpiritDocument spiritDocument;
    private Vlnv vlnv;
    private Map<File, FileDetails> duplicates;

    public FileDetails(File file, SpiritDocument spiritDocument, Vlnv vlnv) {
        assert (file != null);
        assert (spiritDocument != null);
        assert (vlnv != null);
        this.file = file;
        this.spiritDocument = spiritDocument;
        this.vlnv = vlnv;
        this.lastModifiedTimestamp = file.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    public SpiritDocument getSpiritDocument() {
        return this.spiritDocument;
    }

    public Vlnv getVlnv() {
        return this.vlnv;
    }

    public long getInitialModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public void addDuplicate(FileDetails duplicate) {
        assert (this.vlnv.equals(duplicate.getVlnv()));
        if (this.duplicates == null) {
            this.duplicates = new HashMap<File, FileDetails>();
        }
        this.duplicates.put(duplicate.getFile(), duplicate);
    }

    public void removeDuplicate(File fileToRemove) {
        FileDetails duplicate;
        if (this.duplicates != null && (duplicate = this.duplicates.get(fileToRemove)) != null) {
            this.duplicates.remove(fileToRemove);
            if (this.duplicates.isEmpty()) {
                this.duplicates = null;
            }
        }
    }

    public FileDetails getDuplicate(File fileToTest) {
        if (this.duplicates != null) {
            return this.duplicates.get(fileToTest);
        }
        return null;
    }

    public Map<File, FileDetails> getDuplicates() {
        return this.duplicates;
    }

    void setDuplicates(Map<File, FileDetails> duplicates) {
        this.duplicates = duplicates;
    }

    public boolean hasDuplicates() {
        return this.duplicates != null && !this.duplicates.isEmpty();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.vlnv.toString()).append('-').append(this.file);
        if (this.duplicates != null) {
            stringBuilder.append('!');
            stringBuilder.append(this.duplicates);
        }
        return stringBuilder.toString();
    }

    public static IFile getWorkspaceFile(File file) {
        return FileDetails.getWorkspaceFile(Path.fromOSString((String)file.getAbsolutePath()));
    }

    public static IFile getWorkspaceFile(IPath location) {
        IWorkspace workspace;
        try {
            workspace = ResourcesPlugin.getWorkspace();
        }
        catch (Exception e) {
            workspace = null;
        }
        if (workspace == null) {
            return null;
        }
        IFile[] files = workspace.getRoot().findFilesForLocation(location);
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }
}

