/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.library;

import java.io.File;
import java.io.Serializable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocumentFactory;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;

public class FileDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    private File file;
    private long lastModifiedTimestamp;
    private Vlnv vlnv;

    public FileDetails(File file, Vlnv vlnv) {
        assert (file != null);
        assert (vlnv != null);
        this.file = file;
        this.vlnv = vlnv;
        this.lastModifiedTimestamp = file.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    public SpiritDocument getSpiritDocument() {
        try {
            return SpiritDocumentFactory.getFactory().create(this.file.getAbsolutePath());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Vlnv getVlnv() {
        return this.vlnv;
    }

    public long getInitialModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.vlnv.toString()).append('-').append(this.file);
        return stringBuilder.toString();
    }

    public static IFile getWorkspaceFile(IPath location) {
        IWorkspace workspace;
        try {
            workspace = ResourcesPlugin.getWorkspace();
        }
        catch (Exception e) {
            workspace = null;
        }
        if (workspace == null) {
            return null;
        }
        IFile[] files = workspace.getRoot().findFilesForLocation(location);
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    public IPath getLocation() {
        return Path.fromOSString((String)this.file.getAbsolutePath());
    }

    public IFile getWorkspaceFile() {
        return FileDetails.getWorkspaceFile(Path.fromOSString((String)this.file.getAbsolutePath()));
    }
}

