/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.spiritnodes;

import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentSignal;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SignalMapElement
extends SpiritNode {
    private String busSignalName;
    private Long left;
    private Long right;
    private Long lLeft;
    private Long lRight;
    private long width;

    public SignalMapElement(Element node) {
        super(node);
        if (SchemaInfo.IpxactVersion.BEFORE_V14 == this.schemaVersion()) {
            this.busSignalName = this.getUniqueDescendantText("busSignalName");
            SpiritNode leftElement = this.getUniqueDescendantElement("left", SpiritNode.class);
            this.left = leftElement == null ? null : SignalMapElement.getIpXactInteger(leftElement);
            this.lLeft = this.left;
            SpiritNode rightElement = this.getUniqueDescendantElement("right", SpiritNode.class);
            this.right = rightElement == null ? null : SignalMapElement.getIpXactInteger(rightElement);
            this.lRight = this.right;
        } else {
            SpiritNode logicalPort;
            SpiritNode physicalPort = this.getUniqueChildElement("physicalPort", SpiritNode.class);
            if (physicalPort != null) {
                SpiritNode leftElement = physicalPort.getUniqueDescendantElement("left", SpiritNode.class);
                this.left = leftElement == null ? null : SignalMapElement.getIpXactInteger(leftElement);
                SpiritNode rightElement = physicalPort.getUniqueDescendantElement("right", SpiritNode.class);
                Long l = this.right = rightElement == null ? null : SignalMapElement.getIpXactInteger(rightElement);
            }
            if ((logicalPort = this.getUniqueChildElement("logicalPort", SpiritNode.class)) != null) {
                this.busSignalName = logicalPort.getUniqueDescendantText("name");
                SpiritNode lleftElement = logicalPort.getUniqueDescendantElement("left", SpiritNode.class);
                this.lLeft = lleftElement == null ? null : SignalMapElement.getIpXactInteger(lleftElement);
                SpiritNode lrightElement = logicalPort.getUniqueDescendantElement("right", SpiritNode.class);
                this.lRight = lrightElement == null ? null : SignalMapElement.getIpXactInteger(lrightElement);
            }
        }
        this.width = Math.abs(this.getCalculatedLeft() - this.getCalculatedRight()) + 1L;
    }

    public String getName() {
        if (SchemaInfo.IpxactVersion.BEFORE_V14 == this.schemaVersion()) {
            return this.getUniqueDescendantText("componentSignalName");
        }
        SpiritNode physicalPort = this.getUniqueChildElement("physicalPort", SpiritNode.class);
        return physicalPort.getUniqueDescendantText("name");
    }

    public String getBusSignalName() {
        return this.busSignalName;
    }

    public Long getLeft() {
        return this.left;
    }

    public Long getRight() {
        return this.right;
    }

    public Long getLogicalLeft() {
        return this.lLeft;
    }

    public Long getLogicalRight() {
        return this.lRight;
    }

    public long getWidth() {
        return this.width;
    }

    public ComponentSignal getComponentSignal() {
        SpiritComponentDocument doc = new SpiritComponentDocument(this.node.getOwnerDocument());
        NodeList signals = doc.getDescendants("signal");
        for (int i = 0; i < signals.getLength(); ++i) {
            ComponentSignal signal = new ComponentSignal((Element)signals.item(i));
            if (!signal.getName().equals(this.getName())) continue;
            return signal;
        }
        return null;
    }

    public long getCalculatedLeft() {
        Long result = this.getLeft();
        if (result == null) {
            ComponentSignal cs = this.getComponentSignal();
            result = cs == null ? Long.valueOf(0L) : Long.valueOf(cs.getLeft());
        }
        return result;
    }

    public long getCalculatedRight() {
        Long result = this.getRight();
        if (result == null) {
            ComponentSignal cs = this.getComponentSignal();
            result = cs == null ? Long.valueOf(0L) : Long.valueOf(cs.getRight());
        }
        return result;
    }

    public long getCalculatedLogicalLeft() {
        Long result = this.getLogicalLeft();
        if (result == null) {
            result = this.width - 1L;
        }
        return result;
    }

    public long getCalculatedLogicalRight() {
        Long result = this.getLogicalRight();
        if (result == null) {
            result = 0L;
        }
        return result;
    }
}

