/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.object;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusTypeDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.core.object.AbstractBusType;
import org.eclipse.dd.ipxact.editor.core.object.MonitorType;
import org.eclipse.dd.ipxact.editor.core.object.SpiritCreatableObject;
import org.eclipse.dd.ipxact.editor.core.object.SpiritSignalName;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritSignal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusInterfaceCreator
extends SpiritCreatableObject {
    private String instanceName;
    private Vlnv busType;
    private Vlnv abstractionType;
    private List<SpiritSignalName> signalMap = new ArrayList<SpiritSignalName>();
    private AbstractBusType busTypeObject;
    private boolean isConnectionRequired;
    private boolean isCreateSignalMapEnabled;
    private String componentSignalPrefix;
    private List<SpiritSignal> busDefSignals;

    @Override
    protected Element createNewNode(Document document) {
        Element newRootNode = null;
        String namespace = document.getDocumentElement().getNamespaceURI();
        SchemaInfo.IpxactVersion ipxactVersion = SchemaInfo.getIpxactVersion(namespace);
        newRootNode = document.createElement("spirit:busInterface");
        Element e = document.createElement("spirit:name");
        Text text = document.createTextNode(this.instanceName);
        e.appendChild(text);
        newRootNode.appendChild(e);
        if (this.busType != null) {
            e = document.createElement("spirit:busType");
            this.busType.addAttributesToXmlElement(e);
            newRootNode.appendChild(e);
        }
        if (ipxactVersion != SchemaInfo.IpxactVersion.BEFORE_V14 && this.abstractionType != null) {
            e = document.createElement("spirit:abstractionType");
            this.abstractionType.addAttributesToXmlElement(e);
            newRootNode.appendChild(e);
        }
        if (this.busTypeObject != null) {
            e = this.busTypeObject.getXMLRootNode(document);
            newRootNode.appendChild(e);
        }
        switch (ipxactVersion) {
            case BEFORE_V14: {
                e = document.createElement("spirit:connection");
                text = document.createTextNode(this.isConnectionRequired ? "required" : "explicit");
                break;
            }
            case V14: {
                e = document.createElement("spirit:connectionRequired");
                text = document.createTextNode(this.isConnectionRequired ? "true" : "false");
            }
        }
        e.appendChild(text);
        newRootNode.appendChild(e);
        if (this.signalMap.size() > 0 && this.busTypeObject != null) {
            String signalOrPort = SchemaInfo.getSpiritString("signal", document.getDocumentElement().getNamespaceURI());
            Element signalMapNode = document.createElement("spirit:" + signalOrPort + "Map");
            int busType = this.busTypeObject.getBusType();
            if (3 == busType) {
                MonitorType monitorType = (MonitorType)this.busTypeObject;
                busType = monitorType.getInterfaceType().getBusType();
            }
            for (SpiritSignalName signalName : this.signalMap) {
                String direction;
                SpiritSignal busDefSignal = signalName.getBusDefSignal();
                SpiritSignal.SignalInfo signalInfo = busDefSignal.getSignalInfo(busType);
                if (signalInfo == null || signalInfo.direction != null && "illegal".equals(direction = signalInfo.direction)) continue;
                signalMapNode.appendChild(signalName.createNewNode(document));
            }
            newRootNode.appendChild(signalMapNode);
        }
        return newRootNode;
    }

    public void setInstanceName(String name) {
        this.instanceName = name;
    }

    public List<SpiritSignal> getBusDefSignals() {
        return this.busDefSignals;
    }

    public void setBusType(Vlnv sourceDocId) {
        this.busType = sourceDocId;
    }

    public Vlnv getBusType() {
        return this.busType;
    }

    public void addSignalsFromBusDefinition() {
        if (this.isCreateSignalMapEnabled) {
            SpiritDocument doc = null;
            if (this.abstractionType != null) {
                doc = SpiritResourceLibrary.getDefault().get(this.abstractionType);
            }
            if (doc == null) {
                doc = SpiritResourceLibrary.getDefault().get(this.busType);
            }
            if (doc instanceof SpiritBusTypeDocument) {
                if (this.componentSignalPrefix == null) {
                    this.componentSignalPrefix = "";
                }
                SpiritBusTypeDocument busDoc = (SpiritBusTypeDocument)doc;
                this.busDefSignals = busDoc.getSignals();
                int busType = this.busTypeObject.getBusType();
                if (3 == busType) {
                    MonitorType monitorType = (MonitorType)this.busTypeObject;
                    busType = monitorType.getInterfaceType().getBusType();
                }
                for (SpiritSignal thisSignal : this.busDefSignals) {
                    if (thisSignal.getSignalInfo(busType) == null) continue;
                    this.signalMap.add(new SpiritSignalName(thisSignal, this.componentSignalPrefix));
                }
            }
        }
    }

    public void setBusTypeObject(AbstractBusType spiritObject) {
        this.busTypeObject = spiritObject;
    }

    public AbstractBusType getBusTypeObject() {
        return this.busTypeObject;
    }

    public void setConnectionRequired(boolean connectionRequired) {
        this.isConnectionRequired = connectionRequired;
    }

    public void setCreateSignalMapEnabled(boolean isCreateSignalMapEnabled) {
        this.isCreateSignalMapEnabled = isCreateSignalMapEnabled;
    }

    public void setComponentSignalPrefix(String componentModelSignalPrefix) {
        this.componentSignalPrefix = componentModelSignalPrefix;
    }

    public String getComponentSignalPrefix() {
        return this.componentSignalPrefix;
    }

    public Vlnv getAbstractionType() {
        return this.abstractionType;
    }

    public void setAbstractionType(Vlnv abstractionType) {
        this.abstractionType = abstractionType;
    }
}

