/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.library;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocumentFactory;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.ComponentGroupNode;
import org.eclipse.dd.ipxact.editor.core.library.ComponentNode;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.LibraryNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SpiritLibrary
implements Serializable {
    private static final long serialVersionUID = -7778242132337272452L;
    private static final String[] SPIRIT_FILE_EXTENSIONS = new String[]{"spirit", "xml"};
    private static final List<String> SPIRIT_FILE_EXTENSION_LIST = Arrays.asList(SPIRIT_FILE_EXTENSIONS);
    protected Map<File, FileDetails> fileMap = new HashMap<File, FileDetails>();
    private ComponentGroupNode rootNode = new ComponentGroupNode();

    protected abstract void fireDuplicateRemoved(FileDetails var1, FileDetails var2);

    protected abstract void fireDuplicateAdded(FileDetails var1, FileDetails var2);

    protected abstract void fireModelChanged();

    protected static String getExtension(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos < 0) {
            return "";
        }
        return fileName.substring(pos + 1);
    }

    protected static List<String> getSpiritFileExtensionList() {
        return SPIRIT_FILE_EXTENSION_LIST;
    }

    protected synchronized Vlnv addFileInternal(File file) throws Exception {
        SpiritDocument doc;
        Vlnv vlnv;
        FileDetails fileDetails = this.fileMap.get(file);
        if (fileDetails != null) {
            if (fileDetails.getInitialModifiedTimestamp() == file.lastModified()) {
                return fileDetails.getVlnv();
            }
            this.removeFile(file);
            fileDetails = null;
        }
        if ((vlnv = (doc = SpiritDocumentFactory.getFactory().create(file.getAbsolutePath())).getVlnv()) != null) {
            fileDetails = new FileDetails(file, vlnv);
            ComponentNode[] componentNodes = this.getComponentNodes(vlnv);
            if (componentNodes != null) {
                for (ComponentNode componentNode : componentNodes) {
                    if (!componentNode.getFileDetails().getLocation().equals(fileDetails.getLocation())) continue;
                    return vlnv;
                }
                this.fireDuplicateAdded(fileDetails, componentNodes[0].getFileDetails());
            }
            this.fileMap.put(file, fileDetails);
            this.addComponentToTree(fileDetails);
        }
        this.fireModelChanged();
        return vlnv;
    }

    protected void removeFile(File file) {
        FileDetails fileDetails = this.fileMap.get(file);
        if (fileDetails != null) {
            Vlnv vlnv = fileDetails.getVlnv();
            if (vlnv != null) {
                ComponentNode[] nodes = this.getComponentNodes(vlnv);
                if (nodes.length > 1) {
                    FileDetails primaryEntry = nodes[0].getFileDetails();
                    if (fileDetails == primaryEntry) {
                        for (int i = 1; i < nodes.length; ++i) {
                            FileDetails fd = nodes[i].getFileDetails();
                            this.fireDuplicateRemoved(fd, fileDetails);
                        }
                        if (nodes.length > 2) {
                            FileDetails fd1 = nodes[1].getFileDetails();
                            for (int i = 2; i < nodes.length; ++i) {
                                FileDetails fd = nodes[i].getFileDetails();
                                this.fireDuplicateAdded(fd, fd1);
                            }
                        }
                    } else {
                        this.fireDuplicateRemoved(fileDetails, primaryEntry);
                    }
                }
                this.removeComponentFromTree(fileDetails);
            }
            this.fileMap.remove(file);
            fileDetails.invalidate();
            this.fireModelChanged();
        }
    }

    public synchronized Vlnv getVlnvForFile(File file) {
        Vlnv vlnv = null;
        FileDetails details = this.fileMap.get(file);
        if (details != null) {
            vlnv = details.getVlnv();
        }
        return vlnv;
    }

    public synchronized FileDetails getFileDetailsForFile(File file) {
        return this.fileMap.get(file);
    }

    public synchronized FileDetails getFileDetailsForVlnv(Vlnv vlnv) {
        ComponentNode[] nodes = this.getComponentNodes(vlnv);
        if (nodes == null) {
            return null;
        }
        return nodes[0].getFileDetails();
    }

    public synchronized List<FileDetails> getFileDetails() {
        return new ArrayList<FileDetails>(this.fileMap.values());
    }

    public boolean hasDuplicates(Vlnv vlnv) {
        ComponentNode[] nodes = this.getComponentNodes(vlnv);
        return nodes != null && nodes.length > 1;
    }

    public synchronized List<FileDetails> getDuplicates(Vlnv vlnv) {
        ComponentNode[] nodes = this.getComponentNodes(vlnv);
        ArrayList<FileDetails> result = new ArrayList<FileDetails>();
        if (nodes != null) {
            for (int i = 1; i < nodes.length; ++i) {
                result.add(nodes[i].getFileDetails());
            }
        }
        return result;
    }

    public synchronized SpiritDocument get(Vlnv vlnv) {
        FileDetails fd = this.getFileDetailsForVlnv(vlnv);
        if (fd == null) {
            return null;
        }
        return fd.getSpiritDocument();
    }

    private ComponentNode[] getComponentNodes(Vlnv vlnv) {
        ComponentGroupNode versionNode;
        ComponentGroupNode nameNode;
        ComponentGroupNode libraryNode;
        ComponentGroupNode vendorNode;
        if (vlnv != null && (vendorNode = this.rootNode.findChild(vlnv.getVlnvPartForType(1))) != null && (libraryNode = vendorNode.findChild(vlnv.getVlnvPartForType(2))) != null && (nameNode = libraryNode.findChild(vlnv.getVlnvPartForType(3))) != null && (versionNode = nameNode.findChild(vlnv.getVlnvPartForType(4))) != null) {
            LibraryNode[] children = versionNode.getChildren();
            ComponentNode[] result = new ComponentNode[children.length];
            for (int i = 0; i < children.length; ++i) {
                result[i] = (ComponentNode)children[i];
            }
            return result;
        }
        return null;
    }

    public synchronized List<Vlnv> getVlnvList() {
        ArrayList<Vlnv> resultList = new ArrayList<Vlnv>();
        for (LibraryNode vendor : this.rootNode.getChildren()) {
            for (LibraryNode library : vendor.getChildren()) {
                for (LibraryNode name : library.getChildren()) {
                    for (LibraryNode version : name.getChildren()) {
                        resultList.add(new Vlnv(vendor.getContent(), library.getContent(), name.getContent(), version.getContent()));
                    }
                }
            }
        }
        return resultList;
    }

    public boolean isEmpty() {
        return this.rootNode.getChildren().length == 0;
    }

    public synchronized ArrayList<String> getVendors() {
        LibraryNode[] vendorNodes;
        ArrayList<String> result = new ArrayList<String>();
        for (LibraryNode vendorNode : vendorNodes = this.rootNode.getChildren()) {
            result.add(vendorNode.getContent());
        }
        return result;
    }

    public synchronized ArrayList<String> getLibraries(String vendor) {
        ArrayList<String> result = new ArrayList<String>();
        ComponentGroupNode vendorNode = this.rootNode.findChild(vendor);
        if (vendorNode != null) {
            LibraryNode[] libraryNodes;
            for (LibraryNode libraryNode : libraryNodes = vendorNode.getChildren()) {
                result.add(libraryNode.getContent());
            }
        }
        return result;
    }

    public synchronized ArrayList<String> getNames(String vendor, String libname) {
        ComponentGroupNode libNode;
        ArrayList<String> result = new ArrayList<String>();
        ComponentGroupNode vendorNode = this.rootNode.findChild(vendor);
        if (vendorNode != null && (libNode = vendorNode.findChild(libname)) != null) {
            LibraryNode[] nameNodes;
            for (LibraryNode nameNode : nameNodes = libNode.getChildren()) {
                result.add(nameNode.getContent());
            }
        }
        return result;
    }

    public synchronized ArrayList<String> getVersions(String vendor, String libname, String name) {
        ComponentGroupNode nameNode;
        ComponentGroupNode libNode;
        ArrayList<String> result = new ArrayList<String>();
        ComponentGroupNode vendorNode = this.rootNode.findChild(vendor);
        if (vendorNode != null && (libNode = vendorNode.findChild(libname)) != null && (nameNode = libNode.findChild(name)) != null) {
            LibraryNode[] versionNodes;
            for (LibraryNode versionNode : versionNodes = nameNode.getChildren()) {
                result.add(versionNode.getContent());
            }
        }
        return result;
    }

    public synchronized ComponentGroupNode getRoot() {
        return this.rootNode;
    }

    private void addComponentToTree(FileDetails fileDetails) {
        Vlnv vlnv = fileDetails.getVlnv();
        ComponentGroupNode vendorNode = this.rootNode.findOrCreateChild(1, vlnv);
        ComponentGroupNode libraryNode = vendorNode.findOrCreateChild(2, vlnv);
        ComponentGroupNode nameNode = libraryNode.findOrCreateChild(3, vlnv);
        ComponentGroupNode versionNode = nameNode.findOrCreateChild(4, vlnv);
        ComponentNode node = new ComponentNode(fileDetails);
        versionNode.addChild(node);
    }

    private void removeComponentFromTree(FileDetails fileDetails) {
        Vlnv vlnv;
        ComponentGroupNode vendorNode;
        if (fileDetails != null && (vendorNode = this.rootNode.findChild((vlnv = fileDetails.getVlnv()).getVlnvPartForType(1))) != null) {
            ComponentGroupNode libraryNode = vendorNode.findChild(vlnv.getVlnvPartForType(2));
            if (libraryNode != null) {
                ComponentGroupNode nameNode = libraryNode.findChild(vlnv.getVlnvPartForType(3));
                if (nameNode != null) {
                    ComponentGroupNode versionNode = nameNode.findChild(vlnv.getVlnvPartForType(4));
                    if (versionNode != null) {
                        LibraryNode[] children;
                        for (LibraryNode node : children = versionNode.getChildren()) {
                            if (!fileDetails.equals(((ComponentNode)node).getFileDetails())) continue;
                            versionNode.removeChild(node);
                        }
                        if (!versionNode.hasChildren()) {
                            nameNode.removeChild(versionNode);
                        }
                    }
                    if (!nameNode.hasChildren()) {
                        libraryNode.removeChild(nameNode);
                    }
                }
                if (!libraryNode.hasChildren()) {
                    vendorNode.removeChild(libraryNode);
                }
            }
            if (!vendorNode.hasChildren()) {
                this.rootNode.removeChild(vendorNode);
            }
        }
    }

    public synchronized LibraryNode getNode(Vlnv vlnv) {
        if (vlnv == null) {
            return null;
        }
        ComponentNode[] nodes = this.getComponentNodes(vlnv);
        if (nodes == null) {
            return null;
        }
        return nodes[0];
    }

    protected void emptyComponentTree() {
        LibraryNode[] vendorNodes;
        for (LibraryNode vendorNode : vendorNodes = this.rootNode.getChildren()) {
            this.rootNode.removeChild(vendorNode);
        }
    }
}

