/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.utils.DialogSettingsHelper;
import org.eclipse.dd.ipxact.editor.ui.wizards.NewSPIRITGenerator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SpiritUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.dd.ipxact.editor.ui";
    private static final String ICONS_DIR = "icons/";
    private static SpiritUiPlugin plugin = null;

    public SpiritUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.loadImages();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SpiritLibrary.getDefault().update(0L);
            }
        });
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                NewSPIRITGenerator.preloadSchemas(3000L);
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        DialogSettingsHelper.saveDialogSettings();
        SpiritLibrary.getDefault().dispose();
        super.stop(context);
        plugin = null;
    }

    public static SpiritUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String imageKey) {
        ImageDescriptor imageDescriptor = SpiritUiPlugin.getDefault().getImageRegistry().getDescriptor(imageKey);
        if (imageDescriptor == null) {
            imageDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageKey);
        }
        if (imageDescriptor == null) {
            SpiritUiPlugin.logErrorMessage(Messages.SpiritUiPlugin_ImageNotAvailable + imageKey);
        }
        return imageDescriptor;
    }

    public static Image getImage(String imageKey) {
        if (imageKey == null) {
            return null;
        }
        Image image = SpiritUiPlugin.getDefault().getImageRegistry().get(imageKey);
        if (image == null) {
            image = PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
        if (image == null) {
            SpiritUiPlugin.logErrorMessage(Messages.SpiritUiPlugin_ImageNotAvailable + imageKey);
        }
        return image;
    }

    private void loadImages() {
        ImageRegistry registry = this.getImageRegistry();
        registry.put("spirit.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/spirit.gif"));
        registry.put("vendor.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/vendor.gif"));
        registry.put("library.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/library.gif"));
        registry.put("name.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/name.gif"));
        registry.put("spirit_bus_def.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/spirit_bus_def.gif"));
        registry.put("spirit_component.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/spirit_component.gif"));
        registry.put("spirit_design.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/spirit_design.gif"));
        registry.put("preferences.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/preferences.gif"));
        registry.put("goto_source.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/goto_source.gif"));
        registry.put("error_overlay.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/error_overlay.gif"));
        registry.put("warning_overlay.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/warning_overlay.gif"));
        registry.put("read_only.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/read_only.gif"));
        registry.put("sync_with_editor.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/sync_with_editor.gif"));
        registry.put("error.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/error.gif"));
        registry.put("warning.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/warning.gif"));
        registry.put("search.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/search.gif"));
        registry.put("element.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/element.gif"));
        registry.put("check_document.gif", AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/check_document.gif"));
    }

    public static void log(IStatus status) {
        SpiritUiPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        if (message == null) {
            message = "";
        }
        SpiritUiPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            SpiritUiPlugin.logErrorMessage(message);
            return;
        }
        if (message == null) {
            message = "";
        }
        MultiStatus multi = new MultiStatus(PLUGIN_ID, 10001, message, null);
        multi.add(status);
        SpiritUiPlugin.log((IStatus)multi);
    }

    public static void logError(Throwable t) {
        SpiritUiPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, Messages.SpiritUiPlugin_InternalError, t));
    }

    public static void logError(String message, Throwable t) {
        SpiritUiPlugin.logErrorStatus(message, (IStatus)new Status(4, PLUGIN_ID, 10001, Messages.SpiritUiPlugin_InternalError, t));
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static void showError(String title, int code, String message, Throwable t) {
        StringBuilder stringBuilder = new StringBuilder();
        if (message == null) {
            message = Messages.SpiritUiPlugin_Error;
        }
        stringBuilder.append(message);
        if (t != null) {
            stringBuilder.append("\n\n[");
            stringBuilder.append(Messages.SpiritUiPlugin_Details);
            if (t.getCause() != null) {
                stringBuilder.append(t.getCause().toString());
            } else {
                stringBuilder.append(t.toString());
            }
            stringBuilder.append(']');
        }
        stringBuilder.append("\n\n[");
        stringBuilder.append(Messages.SpiritUiPlugin_Code);
        stringBuilder.append(code);
        stringBuilder.append(']');
        MessageDialog.openError((Shell)SpiritUiPlugin.getShell(), (String)title, (String)stringBuilder.toString());
        SpiritUiPlugin.log((IStatus)new Status(4, PLUGIN_ID, code, message, t));
    }
}

