/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.validator.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dd.ipxact.checker.core.Check;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocumentFactory;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class IpxactValidator
implements IValidatorJob,
ICheckerReporter {
    private static final int CHECKER_EXCEPTION = -1;
    IReporter current_reporter;
    IFile iFile;

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.current_reporter = reporter;
        String[] uris = helper.getURIs();
        IModelManager modelManager = StructuredModelManager.getModelManager();
        for (int i = 0; i < uris.length; ++i) {
            if (reporter.isCancelled()) {
                throw new OperationCanceledException();
            }
            Object[] paras = new String[]{uris[i]};
            this.iFile = (IFile)helper.loadModel("getFile", paras);
            if (this.iFile == null) continue;
            try {
                IStructuredModel model = modelManager.getModelForRead(this.iFile);
                if (model == null || !(model instanceof IDOMModel)) continue;
                IDOMDocument document = ((IDOMModel)model).getDocument();
                SpiritDocument spiritDocument = SpiritDocumentFactory.getFactory().create((Document)document);
                if (spiritDocument == null) continue;
                reporter.displaySubtask((IValidator)this, (IMessage)new LocalizedMessage(4, "Waiting for library update"));
                SpiritResourceLibrary.getDefault().waitForUpdate();
                DocumentChecker documentChecker = new DocumentChecker((SpiritLibrary)SpiritResourceLibrary.getDefault(), spiritDocument, (ICheckerReporter)this);
                reporter.displaySubtask((IValidator)this, (IMessage)new LocalizedMessage(4, this.iFile.getFullPath().toString()));
                documentChecker.check();
                continue;
            }
            catch (Exception e) {
                reporter.addMessage((IValidator)this, (IMessage)new LocalizedMessage(1, "Can't run IP-XACT validator: " + e.getMessage(), (IResource)this.iFile));
            }
        }
    }

    public void closeReport() {
    }

    private LocalizedMessage createMessage(Check check, SpiritDocument document, String message) {
        int messageSeverity = 1;
        switch (check.getSeverity()) {
            case 1: {
                messageSeverity = 4;
                break;
            }
            case 2: {
                messageSeverity = 2;
                break;
            }
            case 3: {
                messageSeverity = 1;
            }
        }
        if (check.getId().startsWith("Internal")) {
            return new LocalizedMessage(messageSeverity, message, (IResource)this.iFile);
        }
        return new LocalizedMessage(messageSeverity, message + ": SCR no. " + check.getId() + " " + check.getDescription(), (IResource)this.iFile);
    }

    public void report(Check check, SpiritDocument document, String message) {
        LocalizedMessage msg = this.createMessage(check, document, message);
        this.current_reporter.addMessage((IValidator)this, (IMessage)msg);
    }

    public void report(Check check, SpiritDocument document, String message, Node node) {
        LocalizedMessage msg = this.createMessage(check, document, message);
        int startOffset = -1;
        int endOffset = -1;
        if (node instanceof IndexedRegion) {
            startOffset = ((IndexedRegion)node).getStartOffset();
            endOffset = ((IndexedRegion)node).getEndOffset();
        }
        msg.setOffset(startOffset);
        msg.setLength(endOffset - startOffset);
        this.current_reporter.addMessage((IValidator)this, (IMessage)msg);
    }

    public void report(Check check, SpiritDocument document, String message, SpiritNode node) {
        this.report(check, document, message, node.getNode());
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        try {
            this.validate(helper, reporter);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)e;
            }
            return new Status(4, "org.eclipse.dd.ipxact.validator.ui", -1, "IP-XACT validator failed with exception", (Throwable)e);
        }
    }
}

