/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.CommandCache;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.MIVariableManager;
import org.eclipse.dd.mi.service.command.commands.ExprMetaGetAttributes;
import org.eclipse.dd.mi.service.command.commands.ExprMetaGetChildCount;
import org.eclipse.dd.mi.service.command.commands.ExprMetaGetChildren;
import org.eclipse.dd.mi.service.command.commands.ExprMetaGetValue;
import org.eclipse.dd.mi.service.command.commands.ExprMetaGetVar;
import org.eclipse.dd.mi.service.command.commands.MIDataEvaluateExpression;
import org.eclipse.dd.mi.service.command.output.ExprMetaGetAttributesInfo;
import org.eclipse.dd.mi.service.command.output.ExprMetaGetChildCountInfo;
import org.eclipse.dd.mi.service.command.output.ExprMetaGetChildrenInfo;
import org.eclipse.dd.mi.service.command.output.ExprMetaGetValueInfo;
import org.eclipse.dd.mi.service.command.output.ExprMetaGetVarInfo;
import org.eclipse.dd.mi.service.command.output.MIDataEvaluateExpressionInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionService
extends AbstractDsfService
implements IExpressions {
    private CommandCache fExpressionCache;
    private MIVariableManager varManager;

    public ExpressionService(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleOK() {
                ExpressionService.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IExpressions.class.getName(), ExpressionService.class.getName()}, new Hashtable());
        this.varManager = new MIVariableManager(this.getSession(), this.getServicesTracker());
        this.fExpressionCache = new CommandCache((ICommandControl)this.varManager);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.varManager.shutdown();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return MIPlugin.getBundleContext();
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext ctx, String expression) {
        return this.createExpression(ctx, expression, expression);
    }

    public IExpressions.IExpressionDMContext createExpression(IDMContext ctx, String expression, String relExpr) {
        IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IStack.IFrameDMContext.class);
        if (frameDmc != null) {
            return new MIExpressionDMC(this.getSession().getId(), expression, relExpr, frameDmc);
        }
        IMIExecutionDMContext execCtx = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMIExecutionDMContext.class);
        if (execCtx != null) {
            return new MIExpressionDMC(this.getSession().getId(), expression, relExpr, execCtx);
        }
        IMemory.IMemoryDMContext memoryCtx = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMemory.IMemoryDMContext.class);
        if (memoryCtx != null) {
            return new MIExpressionDMC(this.getSession().getId(), expression, relExpr, memoryCtx);
        }
        return new InvalidContextExpressionDMC(this.getSession().getId(), expression, ctx);
    }

    public IFormattedValues.FormattedValueDMContext getFormattedValueContext(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
        return new IFormattedValues.FormattedValueDMContext((IDMService)this, (IDMContext)dmc, formatId);
    }

    public void getAvailableFormats(IFormattedValues.IFormattedDataDMContext dmc, DataRequestMonitor<String[]> rm) {
        rm.setData((Object)new String[]{"BINARY.Format", "NATURAL.Format", "HEX.Format", "OCTAL.Format", "DECIMAL.Format"});
        rm.done();
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.getExpressionData((MIExpressionDMC)dmc, rm);
        } else if (dmc instanceof IFormattedValues.FormattedValueDMContext) {
            this.getFormattedExpressionValue((IFormattedValues.FormattedValueDMContext)dmc, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public void getExpressionData(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMData> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetVar(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetVarInfo>((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    rm.setData((Object)new ExpressionDMData(((ExprMetaGetVarInfo)this.getData()).getExpr(), ((ExprMetaGetVarInfo)this.getData()).getType(), ((ExprMetaGetVarInfo)this.getData()).getNumChildren(), ((ExprMetaGetVarInfo)this.getData()).getEditable()));
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void getExpressionAddressData(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMAddress> rm) {
        IExpressions.IExpressionDMContext addressDmc = this.createExpression((IDMContext)dmc, "&(" + dmc.getExpression() + ")");
        final IExpressions.IExpressionDMContext sizeDmc = this.createExpression((IDMContext)dmc, "sizeof(" + dmc.getExpression() + ")");
        if (addressDmc instanceof InvalidContextExpressionDMC || sizeDmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            this.fExpressionCache.execute(new MIDataEvaluateExpression(addressDmc), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    final String addrStr = ((MIDataEvaluateExpressionInfo)this.getData()).getValue();
                    ExpressionService.this.fExpressionCache.execute(new MIDataEvaluateExpression(sizeDmc), (DataRequestMonitor)new DataRequestMonitor<MIDataEvaluateExpressionInfo>((Executor)ExpressionService.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleOK() {
                            try {
                                int size = Integer.parseInt(((MIDataEvaluateExpressionInfo)this.getData()).getValue());
                                rm.setData((Object)new ExpressionDMAddress(addrStr, size));
                            }
                            catch (NumberFormatException e) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unexpected size format from backend: " + ((MIDataEvaluateExpressionInfo)this.getData()).getValue(), null));
                            }
                            rm.done();
                        }
                    });
                }
            });
        }
    }

    public void getFormattedExpressionValue(IFormattedValues.FormattedValueDMContext dmc, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        if (DMContexts.getAncestorOfType((IDMContext)dmc, MIExpressionDMC.class) == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetValue(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetValueInfo>((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(((ExprMetaGetValueInfo)this.getData()).getValue()));
                    rm.done();
                }
            });
        }
    }

    public void getBaseExpressions(IExpressions.IExpressionDMContext exprContext, DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Not supported", null));
        rm.done();
    }

    public void getSubExpressions(final IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetChildren(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetChildrenInfo>((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    ExpressionInfo[] childrenExpr = ((ExprMetaGetChildrenInfo)this.getData()).getChildrenExpressions();
                    IExpressions.IExpressionDMContext[] childArray = new IExpressions.IExpressionDMContext[childrenExpr.length];
                    for (int i = 0; i < childArray.length; ++i) {
                        childArray[i] = ExpressionService.this.createExpression(dmc.getParents()[0], childrenExpr[i].getFullExpr(), childrenExpr[i].getRelExpr());
                    }
                    rm.setData((Object)childArray);
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void getSubExpressions(IExpressions.IExpressionDMContext exprCtx, final int startIndex, final int length, final DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm) {
        this.getSubExpressions(exprCtx, new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                rm.setData((Object)((IExpressions.IExpressionDMContext[])Arrays.asList((Object[])this.getData()).subList(startIndex, startIndex + length).toArray()));
                rm.done();
            }
        });
    }

    public void getSubExpressionCount(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<Integer> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetChildCount(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetChildCountInfo>((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    rm.setData((Object)((ExprMetaGetChildCountInfo)this.getData()).getChildNum());
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void canWriteExpression(IExpressions.IExpressionDMContext dmc, final DataRequestMonitor<Boolean> rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.fExpressionCache.execute((ICommand)new ExprMetaGetAttributes(dmc), (DataRequestMonitor)new DataRequestMonitor<ExprMetaGetAttributesInfo>((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    rm.setData((Object)((ExprMetaGetAttributesInfo)this.getData()).getEditable());
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    public void writeExpression(final IExpressions.IExpressionDMContext dmc, String expressionValue, String formatId, final RequestMonitor rm) {
        if (dmc instanceof MIExpressionDMC) {
            this.varManager.writeValue(dmc, expressionValue, formatId, new RequestMonitor((Executor)this.getExecutor(), rm){

                protected void handleOK() {
                    ExpressionService.this.fExpressionCache.reset();
                    ExpressionService.this.getSession().dispatchEvent((Object)new ExpressionChangedEvent(dmc), ExpressionService.this.getProperties());
                    rm.done();
                }
            });
        } else if (dmc instanceof InvalidContextExpressionDMC) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid context for evaluating expressions.", null));
            rm.done();
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Invalid expression context.", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fExpressionCache.setTargetAvailable(false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fExpressionCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fExpressionCache.setTargetAvailable(true);
        this.fExpressionCache.reset();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMemory.IMemoryChangedEvent e) {
        this.fExpressionCache.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExpressionChangedEvent
    extends AbstractDMEvent<IExpressions.IExpressionDMContext>
    implements IExpressions.IExpressionChangedDMEvent {
        public ExpressionChangedEvent(IExpressions.IExpressionDMContext context) {
            super((IDMContext)context);
        }
    }

    protected static class ExpressionDMAddress
    implements IExpressions.IExpressionDMAddress {
        IAddress fAddr;
        int fSize;

        public ExpressionDMAddress(IAddress addr, int size) {
            this.fAddr = addr;
            this.fSize = size;
        }

        public ExpressionDMAddress(String addrStr, int size) {
            this.fSize = size;
            this.fAddr = addrStr.length() <= 10 ? new Addr32(addrStr) : new Addr64(addrStr);
        }

        public IAddress getAddress() {
            return this.fAddr;
        }

        public int getSize() {
            return this.fSize;
        }

        public boolean equals(Object other) {
            if (other instanceof ExpressionDMAddress) {
                ExpressionDMAddress otherAddr = (ExpressionDMAddress)other;
                return this.fSize == otherAddr.getSize() && (this.fAddr == null ? otherAddr.getAddress() == null : this.fAddr.equals(otherAddr.getAddress()));
            }
            return false;
        }

        public int hashCode() {
            return (this.fAddr == null ? 0 : this.fAddr.hashCode()) + this.fSize;
        }

        public String toString() {
            return (this.fAddr == null ? "null" : "(0x" + this.fAddr.toString()) + ", " + this.fSize + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExpressionDMData
    implements IExpressions.IExpressionDMData {
        private final String relativeExpression;
        private final String exprType;
        private final int numChildren;
        private final boolean editable;

        public ExpressionDMData(String expr, String type, int num, boolean edit) {
            this.relativeExpression = expr;
            this.exprType = type;
            this.numChildren = num;
            this.editable = edit;
        }

        public IExpressions.IExpressionDMData.BasicType getBasicType() {
            return null;
        }

        public String getEncoding() {
            return null;
        }

        public Map<String, Integer> getEnumerations() {
            return new HashMap<String, Integer>();
        }

        public String getName() {
            return this.relativeExpression;
        }

        public IRegisters.IRegisterDMContext getRegister() {
            return null;
        }

        public String getStringValue() {
            return null;
        }

        public String getTypeId() {
            return null;
        }

        public String getTypeName() {
            return this.exprType;
        }

        public int getNumChildren() {
            return this.numChildren;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public boolean equals(Object other) {
            if (other instanceof ExpressionDMData) {
                ExpressionDMData otherData = (ExpressionDMData)other;
                return this.getNumChildren() == otherData.getNumChildren() && (this.getTypeName() == null ? otherData.getTypeName() == null : this.getTypeName().equals(otherData.getTypeName())) && (this.getName() == null ? otherData.getName() == null : this.getName().equals(otherData.getName()));
            }
            return false;
        }

        public int hashCode() {
            return this.relativeExpression == null ? 0 : (this.relativeExpression.hashCode() + this.exprType == null ? 0 : this.exprType.hashCode() + this.numChildren);
        }

        public String toString() {
            return "relExpr=" + this.relativeExpression + ", type=" + this.exprType + ", numchildren=" + this.numChildren;
        }
    }

    public static class ExpressionInfo {
        private final String fullExpression;
        private final String relativeExpression;

        public ExpressionInfo(String full, String relative) {
            this.fullExpression = full;
            this.relativeExpression = relative;
        }

        public String getFullExpr() {
            return this.fullExpression;
        }

        public String getRelExpr() {
            return this.relativeExpression;
        }

        public boolean equals(Object other) {
            return other instanceof ExpressionInfo && (this.fullExpression == null ? ((ExpressionInfo)other).fullExpression == null : this.fullExpression.equals(((ExpressionInfo)other).fullExpression)) && (this.relativeExpression == null ? ((ExpressionInfo)other).relativeExpression == null : this.relativeExpression.equals(((ExpressionInfo)other).relativeExpression));
        }

        public int hashCode() {
            return (this.fullExpression == null ? 0 : this.fullExpression.hashCode()) ^ (this.relativeExpression == null ? 0 : this.relativeExpression.hashCode());
        }

        public String toString() {
            return "[" + this.fullExpression + ", " + this.relativeExpression + "]";
        }
    }

    protected static class InvalidContextExpressionDMC
    extends AbstractDMContext
    implements IExpressions.IExpressionDMContext {
        private final String expression;

        public InvalidContextExpressionDMC(String sessionId, String expr, IDMContext parent) {
            super(sessionId, new IDMContext[]{parent});
            this.expression = expr;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && this.expression == null ? ((InvalidContextExpressionDMC)((Object)other)).getExpression() == null : this.expression.equals(((InvalidContextExpressionDMC)((Object)other)).getExpression());
        }

        public int hashCode() {
            return this.expression == null ? super.baseHashCode() : super.baseHashCode() ^ this.expression.hashCode();
        }

        public String toString() {
            return this.baseToString() + ".invalid_expr[" + this.expression + "]";
        }

        public String getExpression() {
            return this.expression;
        }
    }

    protected static class MIExpressionDMC
    extends AbstractDMContext
    implements IExpressions.IExpressionDMContext {
        private ExpressionInfo exprInfo;

        public MIExpressionDMC(String sessionId, String expression, String relExpr, IStack.IFrameDMContext frameCtx) {
            this(sessionId, expression, relExpr, (IDMContext)frameCtx);
        }

        public MIExpressionDMC(String sessionId, String expression, String relExpr, IMIExecutionDMContext execCtx) {
            this(sessionId, expression, relExpr, (IDMContext)execCtx);
        }

        public MIExpressionDMC(String sessionId, String expression, String relExpr, IMemory.IMemoryDMContext memoryCtx) {
            this(sessionId, expression, relExpr, (IDMContext)memoryCtx);
        }

        private MIExpressionDMC(String sessionId, String expr, String relExpr, IDMContext parent) {
            super(sessionId, new IDMContext[]{parent});
            this.exprInfo = new ExpressionInfo(expr, relExpr);
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && this.exprInfo.equals(((MIExpressionDMC)((Object)other)).exprInfo);
        }

        public int hashCode() {
            return super.baseHashCode() + this.exprInfo.hashCode();
        }

        public String toString() {
            return this.baseToString() + ".expr" + this.exprInfo.toString();
        }

        public String getExpression() {
            return this.exprInfo.getFullExpr();
        }

        public String getRelativeExpression() {
            return this.exprInfo.getRelExpr();
        }
    }
}

