/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.breakpointactions.IBreakpointAction;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IBreakpoint;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class MIBreakpointsActionManager {
    public static final String BREAKPOINT_ACTION_ATTRIBUTE = "BREAKPOINT_ACTIONS";
    private static final String BREAKPOINT_ACTION_DATA = "BreakpointActionManager.actionData";
    private ArrayList breakpointActions = null;

    public void executeActions(final IBreakpoint breakpoint, final IAdaptable context) {
        IMarker marker;
        String actionNames;
        String[] actions;
        if (breakpoint != null && (actions = (actionNames = (marker = breakpoint.getMarker()).getAttribute(BREAKPOINT_ACTION_ATTRIBUTE, "")).split(",")).length > 0) {
            Job job = new Job("Execute breakpoint actions"){

                public IStatus run(IProgressMonitor monitor) {
                    return MIBreakpointsActionManager.this.doExecuteActions(breakpoint, context, actions, monitor);
                }
            };
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private IStatus doExecuteActions(IBreakpoint breakpoint, IAdaptable context, String[] actions, IProgressMonitor monitor) {
        try {
            for (int i = 0; i < actions.length && !monitor.isCanceled(); ++i) {
                String actionName = actions[i];
                IBreakpointAction action = this.findBreakpointAction(actionName);
                if (action != null) {
                    monitor.setTaskName(action.getSummary());
                    IStatus status = action.execute(breakpoint, context, monitor);
                    if (status.getCode() != 0) {
                        if (status.getCode() != 8) {
                            CDebugCorePlugin.log((IStatus)status);
                        }
                        return status;
                    }
                }
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            return new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, "Internal Error", (Throwable)e);
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    public IBreakpointAction findBreakpointAction(String name) {
        for (IBreakpointAction action : this.getBreakpointActions()) {
            if (!action.getName().equals(name)) continue;
            return action;
        }
        return null;
    }

    public ArrayList getBreakpointActions() {
        if (this.breakpointActions == null) {
            this.breakpointActions = new ArrayList();
            this.loadActionData();
        }
        return this.breakpointActions;
    }

    private void loadActionData() {
        String actionData = CDebugCorePlugin.getDefault().getPluginPreferences().getString(BREAKPOINT_ACTION_DATA);
        if (actionData == null || actionData.length() == 0) {
            return;
        }
        Element root = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(actionData))).getDocumentElement();
            NodeList nodeList = root.getChildNodes();
            int entryCount = nodeList.getLength();
            for (int i = 0; i < entryCount; ++i) {
                Element subElement;
                String nodeName;
                Node node = nodeList.item(i);
                short type = node.getNodeType();
                if (type != 1 || !(nodeName = (subElement = (Element)node).getNodeName()).equalsIgnoreCase("actionEntry")) continue;
                String name = subElement.getAttribute("name");
                if (name == null) {
                    throw new Exception();
                }
                String value = subElement.getAttribute("value");
                if (value == null) {
                    throw new Exception();
                }
                String className = subElement.getAttribute("class");
                if (className == null) {
                    throw new Exception();
                }
                IBreakpointAction action = this.createActionFromClassName(name, className);
                action.initializeFromMemento(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private IBreakpointAction createActionFromClassName(String name, String className) {
        IBreakpointAction action = null;
        IExtension[] actionExtensions = CDebugCorePlugin.getDefault().getBreakpointActionManager().getBreakpointActionExtensions();
        try {
            for (int i = 0; i < actionExtensions.length && action == null; ++i) {
                IConfigurationElement[] elements = actionExtensions[i].getConfigurationElements();
                for (int j = 0; j < elements.length && action == null; ++j) {
                    IConfigurationElement element = elements[j];
                    if (!element.getName().equals("actionType") || !element.getAttribute("class").equals(className)) continue;
                    action = (IBreakpointAction)element.createExecutableExtension("class");
                    action.setName(name);
                    CDebugCorePlugin.getDefault().getBreakpointActionManager().addAction(action);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return action;
    }
}

