/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.events;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.mi.service.MIRunControl;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIFrame;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

@Immutable
public class MIWatchpointTriggerEvent
extends MIStoppedEvent {
    private final int number;
    private final String exp;
    private final String oldValue;
    private final String newValue;

    protected MIWatchpointTriggerEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, int number, String exp, String oldValue, String newValue) {
        super(ctx, token, results, frame);
        this.number = number;
        this.exp = exp;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public int getNumber() {
        return this.number;
    }

    public String getExpression() {
        return this.exp;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public static MIWatchpointTriggerEvent parse(MIRunControl runControl, IRunControl.IContainerDMContext containerDmc, int token, MIResult[] results) {
        int number = 0;
        String exp = "";
        String oldValue = "";
        String newValue = "";
        for (int i = 0; i < results.length; ++i) {
            String str;
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            if (var.equals("wpt") || var.equals("hw-awpt") || var.equals("hw-rwpt")) {
                if (!(value instanceof MITuple)) continue;
                for (MIResult wptResult : ((MITuple)value).getMIResults()) {
                    String wptVar = wptResult.getVariable();
                    MIValue wptValue = wptResult.getMIValue();
                    if (wptVar.equals("number")) {
                        if (!(wptValue instanceof MIConst)) continue;
                        str = ((MIConst)wptValue).getString();
                        try {
                            number = Integer.parseInt(str);
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (!wptVar.equals("exp") || !(wptValue instanceof MIConst)) continue;
                    exp = ((MIConst)wptValue).getString();
                }
                continue;
            }
            if (!var.equals("value") || !(value instanceof MITuple)) continue;
            for (MIResult valueResult : ((MITuple)value).getMIResults()) {
                String valueVar = valueResult.getVariable();
                MIValue valueValue = valueResult.getMIValue();
                str = "";
                if (valueValue instanceof MIConst) {
                    str = ((MIConst)valueValue).getString();
                }
                if (valueVar.equals("old")) {
                    oldValue = str;
                    continue;
                }
                if (valueVar.equals("new")) {
                    newValue = str;
                    continue;
                }
                if (!valueVar.equals("value")) continue;
                oldValue = newValue = str;
            }
        }
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(runControl, containerDmc, token, results);
        return new MIWatchpointTriggerEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), number, exp, oldValue, newValue);
    }
}

