/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.ISignals;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.MIControlDMContext;
import org.eclipse.dd.mi.service.command.MIInferiorProcess;
import org.eclipse.dd.mi.service.command.commands.CLICommand;
import org.eclipse.dd.mi.service.command.commands.MIInterpreterExecConsole;
import org.eclipse.dd.mi.service.command.events.MIBreakpointChangedEvent;
import org.eclipse.dd.mi.service.command.events.MIDetachedEvent;
import org.eclipse.dd.mi.service.command.events.MIErrorEvent;
import org.eclipse.dd.mi.service.command.events.MIRunningEvent;
import org.eclipse.dd.mi.service.command.events.MISignalChangedEvent;
import org.eclipse.dd.mi.service.command.events.MIThreadCreatedEvent;
import org.eclipse.dd.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.dd.mi.service.command.output.MIOOBRecord;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConfinedToDsfExecutor(value="fConnection#getExecutor")
public class CLIEventProcessor
implements ICommandListener,
IEventListener {
    private final AbstractMIControl fCommandControl;
    private final MIInferiorProcess fInferior;
    private final IRunControl.IContainerDMContext fContainerDmc;
    private final List<Object> fEventList = new LinkedList<Object>();
    private static int fLastThreadId;

    public CLIEventProcessor(AbstractMIControl connection, IRunControl.IContainerDMContext containerDmc, MIInferiorProcess inferior) {
        this.fCommandControl = connection;
        this.fInferior = inferior;
        this.fContainerDmc = containerDmc;
        connection.addCommandListener(this);
        connection.addEventListener(this);
        fLastThreadId = 0;
    }

    public void dispose() {
        this.fCommandControl.removeCommandListener(this);
        this.fCommandControl.removeEventListener(this);
    }

    public void commandSent(ICommand<? extends ICommandResult> command) {
        if (command instanceof CLICommand) {
            this.processStateChanges((CLICommand)command);
        } else if (command instanceof MIInterpreterExecConsole) {
            this.processStateChanges((MIInterpreterExecConsole)command);
        }
    }

    public void commandDone(ICommand<? extends ICommandResult> command, ICommandResult result) {
        if (command instanceof CLICommand) {
            this.processSettingChanges((CLICommand)command);
        } else if (command instanceof MIInterpreterExecConsole) {
            this.processSettingChanges((MIInterpreterExecConsole)command);
        }
        this.fEventList.clear();
    }

    public void commandQueued(ICommand<? extends ICommandResult> command) {
    }

    public void commandRemoved(ICommand<? extends ICommandResult> command) {
    }

    public void eventReceived(Object output) {
        for (MIOOBRecord oobr : ((MIOutput)output).getMIOOBRecords()) {
            this.fEventList.add(oobr);
            if (!(oobr instanceof MIConsoleStreamOutput)) continue;
            MIConsoleStreamOutput exec = (MIConsoleStreamOutput)oobr;
            Pattern pattern = Pattern.compile("(^\\[New Thread.*LWP\\s*)(\\d*)", 8);
            Matcher matcher = pattern.matcher(exec.getCString());
            if (!matcher.find()) continue;
            MIThreadCreatedEvent e = new MIThreadCreatedEvent(this.fContainerDmc, ++fLastThreadId);
            this.fCommandControl.getSession().dispatchEvent((Object)e, this.fCommandControl.getProperties());
        }
        MIResultRecord rr = ((MIOutput)output).getMIResultRecord();
        if (rr != null) {
            String state = rr.getResultClass();
            if (this.fInferior != null && "error".equals(state) && this.fInferior.getState() == MIInferiorProcess.State.RUNNING) {
                this.fInferior.setState(MIInferiorProcess.State.RUNNING);
                this.fCommandControl.getSession().dispatchEvent((Object)MIErrorEvent.parse(this.fContainerDmc, rr.getToken(), rr.getMIResults(), null), this.fCommandControl.getProperties());
            }
        }
    }

    private void processStateChanges(CLICommand<? extends ICommandResult> cmd) {
        String operation = cmd.getOperation().trim();
        this.processStateChanges(0, operation);
    }

    private void processStateChanges(MIInterpreterExecConsole<? extends ICommandResult> exec) {
        String[] operations = exec.getParameters();
        if (operations != null && operations.length > 0) {
            this.processStateChanges(0, operations[0]);
        }
    }

    private void processStateChanges(int token, String operation) {
        int indx = operation.indexOf(32);
        int type = CLIEventProcessor.getSteppingOperationKind(operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim());
        if (type != -1) {
            MIRunningEvent event = new MIRunningEvent((IRunControl.IExecutionDMContext)this.fContainerDmc, token, type);
            this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
        }
    }

    private void processSettingChanges(CLICommand<?> cmd) {
        String operation = cmd.getOperation().trim();
        this.processSettingChanges(cmd.getContext(), 0, operation);
    }

    private void processSettingChanges(MIInterpreterExecConsole<?> exec) {
        String[] operations = exec.getParameters();
        if (operations != null && operations.length > 0) {
            this.processSettingChanges(exec.getContext(), 0, operations[0]);
        }
    }

    private void processSettingChanges(IDMContext dmc, int token, String operation) {
        int indx = operation.indexOf(32);
        if (this.isSettingBreakpoint(operation = indx != -1 ? operation.substring(0, indx).trim() : operation.trim()) || this.isSettingWatchpoint(operation) || this.isChangeBreakpoint(operation) || this.isDeletingBreakpoint(operation)) {
            MIBreakpointChangedEvent event = new MIBreakpointChangedEvent((IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class), 0);
            this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
        } else if (this.isSettingSignal(operation)) {
            MISignalChangedEvent event = new MISignalChangedEvent((ISignals.ISignalsDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ISignals.ISignalsDMContext.class), "");
            this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
        } else if (this.isDetach(operation)) {
            MIDetachedEvent event = new MIDetachedEvent((MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, MIControlDMContext.class), token);
            this.fCommandControl.getSession().dispatchEvent((Object)event, this.fCommandControl.getProperties());
        }
    }

    private static int getSteppingOperationKind(String operation) {
        int type = -1;
        if (operation.equals("n") || operation.equals("next")) {
            type = 1;
        } else if (operation.equals("ni") || operation.equals("nexti")) {
            type = 2;
        } else if (operation.equals("s") || operation.equals("step")) {
            type = 3;
        } else if (operation.equals("si") || operation.equals("stepi")) {
            type = 4;
        } else if (operation.equals("u") || operation.startsWith("unt") && "until".indexOf(operation) != -1) {
            type = 6;
        } else if (operation.startsWith("fin") && "finish".indexOf(operation) != -1) {
            type = 5;
        } else if (operation.equals("c") || operation.equals("fg") || operation.startsWith("cont") && "continue".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("sig") && "signal".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.startsWith("j") && "jump".indexOf(operation) != -1) {
            type = 0;
        } else if (operation.equals("r") || operation.equals("run")) {
            type = 0;
        }
        return type;
    }

    public static boolean isSteppingOperation(String operation) {
        int type = CLIEventProcessor.getSteppingOperationKind(operation);
        return type != -1;
    }

    private boolean isSettingBreakpoint(String operation) {
        boolean isbreak = false;
        if (operation.startsWith("b") && "break".indexOf(operation) != -1 || operation.startsWith("tb") && "tbreak".indexOf(operation) != -1 || operation.startsWith("hb") && "hbreak".indexOf(operation) != -1 || operation.startsWith("thb") && "thbreak".indexOf(operation) != -1 || operation.startsWith("rb") && "rbreak".indexOf(operation) != -1) {
            isbreak = true;
        }
        return isbreak;
    }

    private boolean isSettingWatchpoint(String operation) {
        boolean isWatch = false;
        if (operation.startsWith("wa") && "watch".indexOf(operation) != -1 || operation.startsWith("rw") && "rwatch".indexOf(operation) != -1 || operation.startsWith("aw") && "awatch".indexOf(operation) != -1) {
            isWatch = true;
        }
        return isWatch;
    }

    private boolean isDeletingBreakpoint(String operation) {
        boolean isDelete = false;
        if (operation.startsWith("cl") && "clear".indexOf(operation) != -1 || operation.equals("d") || operation.startsWith("del") && "delete".indexOf(operation) != -1) {
            isDelete = true;
        }
        return isDelete;
    }

    private boolean isChangeBreakpoint(String operation) {
        boolean isChange = false;
        if (operation.equals("dis") || operation.equals("disa") || operation.startsWith("disa") && "disable".indexOf(operation) != -1 || operation.equals("en") || operation.startsWith("en") && "enable".indexOf(operation) != -1 || operation.startsWith("ig") && "ignore".indexOf(operation) != -1 || operation.startsWith("cond") && "condition".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    private boolean isSettingSignal(String operation) {
        boolean isChange = false;
        if (operation.startsWith("ha") && "handle".indexOf(operation) != -1) {
            isChange = true;
        }
        return isChange;
    }

    private boolean isDetach(String operation) {
        return operation.startsWith("det") && "detach".indexOf(operation) != -1;
    }
}

