/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.CommandCache;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.MIStack;
import org.eclipse.dd.mi.service.command.commands.MIExecContinue;
import org.eclipse.dd.mi.service.command.commands.MIExecFinish;
import org.eclipse.dd.mi.service.command.commands.MIExecInterrupt;
import org.eclipse.dd.mi.service.command.commands.MIExecNext;
import org.eclipse.dd.mi.service.command.commands.MIExecStep;
import org.eclipse.dd.mi.service.command.commands.MIExecUntil;
import org.eclipse.dd.mi.service.command.commands.MIThreadListIds;
import org.eclipse.dd.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.dd.mi.service.command.events.MIErrorEvent;
import org.eclipse.dd.mi.service.command.events.MIEvent;
import org.eclipse.dd.mi.service.command.events.MIGDBExitEvent;
import org.eclipse.dd.mi.service.command.events.MIRunningEvent;
import org.eclipse.dd.mi.service.command.events.MISharedLibEvent;
import org.eclipse.dd.mi.service.command.events.MISignalEvent;
import org.eclipse.dd.mi.service.command.events.MISteppingRangeEvent;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.events.MIThreadCreatedEvent;
import org.eclipse.dd.mi.service.command.events.MIThreadExitEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIThreadListIdsInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIRunControl
extends AbstractDsfService
implements IRunControl {
    private ICommandControl fConnection;
    private CommandCache fMICommandCache;
    private boolean fSuspended = true;
    private boolean fResumePending = false;
    private boolean fStepping = false;
    private boolean fTerminated = false;
    private IRunControl.StateChangeReason fStateChangeReason;
    private IRunControl.IExecutionDMContext fStateChangeTriggeringContext;
    private static final int NO_THREAD_ID = 0;

    public MIRunControl(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MIRunControl.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fMICommandCache = new CommandCache(this.getSession(), this.fConnection);
        this.getSession().addServiceEventListener((Object)this, null);
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.getSession().removeServiceEventListener((Object)this);
        this.fMICommandCache.reset();
        super.shutdown(rm);
    }

    public boolean isValid() {
        return true;
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof IRunControl.IExecutionDMContext) {
            this.getExecutionData((IRunControl.IExecutionDMContext)dmc, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public CommandCache getCache() {
        return this.fMICommandCache;
    }

    public IMIExecutionDMContext createMIExecutionContext(IRunControl.IContainerDMContext container, int threadId) {
        return new MIExecutionDMC(this.getSession().getId(), container, threadId);
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIRunningEvent e) {
        ResumedEvent event = null;
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IRunControl.IContainerDMContext.class);
        if (containerDmc != null) {
            IRunControl.IExecutionDMContext triggeringCtx = !((IRunControl.IExecutionDMContext)e.getDMContext()).equals(containerDmc) ? (IRunControl.IExecutionDMContext)e.getDMContext() : null;
            event = new ContainerResumedEvent(containerDmc, e, triggeringCtx);
        } else {
            event = new ResumedEvent((IRunControl.IExecutionDMContext)e.getDMContext(), e);
        }
        this.getSession().dispatchEvent((Object)event, this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
        SuspendedEvent event = null;
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IRunControl.IContainerDMContext.class);
        if (containerDmc != null) {
            IRunControl.IExecutionDMContext triggeringCtx = !((IRunControl.IExecutionDMContext)e.getDMContext()).equals(containerDmc) ? (IRunControl.IExecutionDMContext)e.getDMContext() : null;
            event = new ContainerSuspendedEvent(containerDmc, e, triggeringCtx);
        } else {
            event = new SuspendedEvent((IRunControl.IExecutionDMContext)e.getDMContext(), e);
        }
        this.getSession().dispatchEvent((Object)event, this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadCreatedEvent e) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)e.getDMContext();
        MIExecutionDMC executionCtx = e.getId() != -1 ? new MIExecutionDMC(this.getSession().getId(), containerDmc, e.getId()) : null;
        this.getSession().dispatchEvent((Object)new StartedDMEvent(executionCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadExitEvent e) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)e.getDMContext();
        MIExecutionDMC executionCtx = e.getId() != -1 ? new MIExecutionDMC(this.getSession().getId(), containerDmc, e.getId()) : null;
        this.getSession().dispatchEvent((Object)new ExitedDMEvent(executionCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(ContainerResumedEvent e) {
        this.fSuspended = false;
        this.fResumePending = false;
        this.fStateChangeReason = e.getReason();
        this.fMICommandCache.setContextAvailable(e.getDMContext(), false);
        if (e.getReason().equals((Object)IRunControl.StateChangeReason.STEP)) {
            this.fStepping = true;
        } else {
            this.fMICommandCache.reset();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ContainerSuspendedEvent e) {
        this.fMICommandCache.setContextAvailable(e.getDMContext(), true);
        this.fMICommandCache.reset();
        this.fStateChangeReason = e.getReason();
        this.fStateChangeTriggeringContext = e.getTriggeringContexts().length != 0 ? e.getTriggeringContexts()[0] : null;
        this.fSuspended = true;
        this.fStepping = false;
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIGDBExitEvent e) {
        this.fTerminated = true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(StartedDMEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(ExitedDMEvent e) {
        this.fMICommandCache.reset(e.getDMContext());
    }

    protected BundleContext getBundleContext() {
        return MIPlugin.getBundleContext();
    }

    public void canResume(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doCanResume(context));
        rm.done();
    }

    private boolean doCanResume(IRunControl.IExecutionDMContext context) {
        return !this.fTerminated && this.isSuspended(context) && !this.fResumePending;
    }

    public void canSuspend(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        rm.setData((Object)this.doCanSuspend(context));
        rm.done();
    }

    private boolean doCanSuspend(IRunControl.IExecutionDMContext context) {
        return !this.fTerminated && !this.isSuspended(context);
    }

    public boolean isSuspended(IRunControl.IExecutionDMContext context) {
        return !this.fTerminated && this.fSuspended;
    }

    public boolean isStepping(IRunControl.IExecutionDMContext context) {
        return !this.fTerminated && this.fStepping;
    }

    public void resume(IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        assert (context != null);
        if (this.doCanResume(context)) {
            this.fResumePending = true;
            this.fMICommandCache.setContextAvailable((IDMContext)context, false);
            MIExecContinue cmd = null;
            if (context instanceof IRunControl.IContainerDMContext) {
                cmd = new MIExecContinue(context);
            } else {
                IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
                if (dmc == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Given context: " + context + " is not an execution context.", null));
                    rm.done();
                    return;
                }
                cmd = new MIExecContinue(dmc);
            }
            this.fConnection.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Given context: " + context + ", is already running.", null));
            rm.done();
        }
    }

    public void suspend(IRunControl.IExecutionDMContext context, final RequestMonitor rm) {
        assert (context != null);
        if (this.doCanSuspend(context)) {
            MIExecInterrupt cmd = null;
            if (context instanceof IRunControl.IContainerDMContext) {
                cmd = new MIExecInterrupt(context);
            } else {
                IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
                if (dmc == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Given context: " + context + " is not an execution context.", null));
                    rm.done();
                    return;
                }
                cmd = new MIExecInterrupt(dmc);
            }
            this.fConnection.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Given context: " + context + ", is already suspended.", null));
            rm.done();
        }
    }

    public void canStep(IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, DataRequestMonitor<Boolean> rm) {
        this.canResume(context, rm);
    }

    public void step(IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Given context: " + context + " is not an execution context.", null));
            rm.done();
            return;
        }
        if (!this.doCanResume(context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        this.fResumePending = true;
        this.fStepping = true;
        this.fMICommandCache.setContextAvailable((IDMContext)context, false);
        switch (stepType) {
            case STEP_INTO: {
                this.fConnection.queueCommand((ICommand)new MIExecStep(dmc, 1), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){});
                break;
            }
            case STEP_OVER: {
                this.fConnection.queueCommand((ICommand)new MIExecNext(dmc), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){});
                break;
            }
            case STEP_RETURN: {
                MIStack stackService = (MIStack)((Object)this.getServicesTracker().getService(MIStack.class));
                if (stackService != null) {
                    IStack.IFrameDMContext topFrameDmc = stackService.createFrameDMContext(dmc, 0);
                    this.fConnection.queueCommand((ICommand)new MIExecFinish(topFrameDmc), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){});
                    break;
                }
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Cannot create context for command, stack service not available.", null));
                rm.done();
                break;
            }
            default: {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Given step type not supported", null));
                rm.done();
            }
        }
    }

    public void getExecutionContexts(final IRunControl.IContainerDMContext containerDmc, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        this.fMICommandCache.execute((ICommand)new MIThreadListIds(containerDmc), (DataRequestMonitor)new DataRequestMonitor<MIThreadListIdsInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                rm.setData((Object)MIRunControl.this.makeExecutionDMCs(containerDmc, (MIThreadListIdsInfo)this.getData()));
                rm.done();
            }
        });
    }

    private IRunControl.IExecutionDMContext[] makeExecutionDMCs(IRunControl.IContainerDMContext containerCtx, MIThreadListIdsInfo info) {
        if (info.getThreadIds().length == 0) {
            return new IMIExecutionDMContext[]{new MIExecutionDMC(this.getSession().getId(), containerCtx, 0)};
        }
        IRunControl.IExecutionDMContext[] executionDmcs = new IMIExecutionDMContext[info.getThreadIds().length];
        for (int i = 0; i < info.getThreadIds().length; ++i) {
            executionDmcs[i] = new MIExecutionDMC(this.getSession().getId(), containerCtx, info.getThreadIds()[i]);
        }
        return executionDmcs;
    }

    public void getExecutionData(IRunControl.IExecutionDMContext dmc, DataRequestMonitor<IRunControl.IExecutionDMData> rm) {
        if (dmc instanceof IRunControl.IContainerDMContext) {
            rm.setData((Object)new ExecutionData(this.fStateChangeReason));
        } else if (dmc instanceof IMIExecutionDMContext) {
            IRunControl.StateChangeReason reason = dmc.equals(this.fStateChangeTriggeringContext) ? this.fStateChangeReason : IRunControl.StateChangeReason.CONTAINER;
            rm.setData((Object)new ExecutionData(reason));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Given context: " + dmc + " is not an execution context.", null));
        }
        rm.done();
    }

    public void runToLine(IRunControl.IExecutionDMContext context, String fileName, String lineNo, boolean skipBreakpoints, final DataRequestMonitor<MIInfo> rm) {
        assert (context != null);
        IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Given context: " + context + " is not an execution context.", null));
            rm.done();
            return;
        }
        if (this.doCanResume(context)) {
            this.fResumePending = true;
            this.fMICommandCache.setContextAvailable((IDMContext)context, false);
            this.fConnection.queueCommand((ICommand)new MIExecUntil(dmc, fileName + ":" + lineNo), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Cannot resume given DMC.", null));
            rm.done();
        }
    }

    @Immutable
    protected static class ContainerResumedEvent
    extends ResumedEvent
    implements IRunControl.IContainerResumedDMEvent {
        final IRunControl.IExecutionDMContext[] triggeringDmcs;

        ContainerResumedEvent(IRunControl.IContainerDMContext containerDmc, MIRunningEvent miInfo, IRunControl.IExecutionDMContext triggeringDmc) {
            super((IRunControl.IExecutionDMContext)containerDmc, miInfo);
            IRunControl.IExecutionDMContext[] iExecutionDMContextArray;
            if (triggeringDmc != null) {
                IRunControl.IExecutionDMContext[] iExecutionDMContextArray2 = new IRunControl.IExecutionDMContext[1];
                iExecutionDMContextArray = iExecutionDMContextArray2;
                iExecutionDMContextArray2[0] = triggeringDmc;
            } else {
                iExecutionDMContextArray = new IRunControl.IExecutionDMContext[]{};
            }
            this.triggeringDmcs = iExecutionDMContextArray;
        }

        public IRunControl.IExecutionDMContext[] getTriggeringContexts() {
            return this.triggeringDmcs;
        }
    }

    @Immutable
    protected static class ContainerSuspendedEvent
    extends SuspendedEvent
    implements IRunControl.IContainerSuspendedDMEvent {
        final IRunControl.IExecutionDMContext[] triggeringDmcs;

        ContainerSuspendedEvent(IRunControl.IContainerDMContext containerDmc, MIStoppedEvent miInfo, IRunControl.IExecutionDMContext triggeringDmc) {
            super((IRunControl.IExecutionDMContext)containerDmc, miInfo);
            IRunControl.IExecutionDMContext[] iExecutionDMContextArray;
            if (triggeringDmc != null) {
                IRunControl.IExecutionDMContext[] iExecutionDMContextArray2 = new IRunControl.IExecutionDMContext[1];
                iExecutionDMContextArray = iExecutionDMContextArray2;
                iExecutionDMContextArray2[0] = triggeringDmc;
            } else {
                iExecutionDMContextArray = new IRunControl.IExecutionDMContext[]{};
            }
            this.triggeringDmcs = iExecutionDMContextArray;
        }

        public IRunControl.IExecutionDMContext[] getTriggeringContexts() {
            return this.triggeringDmcs;
        }
    }

    @Immutable
    private static class ExecutionData
    implements IRunControl.IExecutionDMData {
        private final IRunControl.StateChangeReason fReason;

        ExecutionData(IRunControl.StateChangeReason reason) {
            this.fReason = reason;
        }

        public IRunControl.StateChangeReason getStateChangeReason() {
            return this.fReason;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected static class ExitedDMEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIThreadExitEvent>
    implements IRunControl.IExitedDMEvent {
        ExitedDMEvent(IMIExecutionDMContext executionDmc, MIThreadExitEvent miInfo) {
            super(executionDmc, miInfo);
        }
    }

    protected class MIExecutionDMC
    extends AbstractDMContext
    implements IMIExecutionDMContext {
        private final int fThreadId;

        protected MIExecutionDMC(String sessionId, IRunControl.IContainerDMContext containerDmc, int threadId) {
            IDMContext[] iDMContextArray;
            if (containerDmc != null) {
                IDMContext[] iDMContextArray2 = new IDMContext[1];
                iDMContextArray = iDMContextArray2;
                iDMContextArray2[0] = containerDmc;
            } else {
                iDMContextArray = new IDMContext[]{};
            }
            super(sessionId, iDMContextArray);
            this.fThreadId = threadId;
        }

        public int getThreadId() {
            return this.fThreadId;
        }

        public String toString() {
            return this.baseToString() + ".thread[" + this.fThreadId + "]";
        }

        public boolean equals(Object obj) {
            return super.baseEquals(obj) && ((MIExecutionDMC)obj).fThreadId == this.fThreadId;
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fThreadId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected static class ResumedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIRunningEvent>
    implements IRunControl.IResumedDMEvent {
        ResumedEvent(IRunControl.IExecutionDMContext ctx, MIRunningEvent miInfo) {
            super(ctx, miInfo);
        }

        public IRunControl.StateChangeReason getReason() {
            switch (((MIRunningEvent)((Object)this.getMIEvent())).getType()) {
                case 0: {
                    return IRunControl.StateChangeReason.USER_REQUEST;
                }
                case 1: 
                case 2: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 3: 
                case 4: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 5: {
                    return IRunControl.StateChangeReason.STEP;
                }
            }
            return IRunControl.StateChangeReason.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected static class RunControlEvent<V extends IDMContext, T extends MIEvent<? extends IDMContext>>
    extends AbstractDMEvent<V>
    implements IDMEvent<V> {
        private final T fMIInfo;

        public RunControlEvent(V dmc, T miInfo) {
            super(dmc);
            this.fMIInfo = miInfo;
        }

        public T getMIEvent() {
            return this.fMIInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected static class StartedDMEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIThreadCreatedEvent>
    implements IRunControl.IStartedDMEvent {
        StartedDMEvent(IMIExecutionDMContext executionDmc, MIThreadCreatedEvent miInfo) {
            super(executionDmc, miInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    protected static class SuspendedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIStoppedEvent>
    implements IRunControl.ISuspendedDMEvent {
        SuspendedEvent(IRunControl.IExecutionDMContext ctx, MIStoppedEvent miInfo) {
            super(ctx, miInfo);
        }

        public IRunControl.StateChangeReason getReason() {
            if (this.getMIEvent() instanceof MIBreakpointHitEvent) {
                return IRunControl.StateChangeReason.BREAKPOINT;
            }
            if (this.getMIEvent() instanceof MISteppingRangeEvent) {
                return IRunControl.StateChangeReason.STEP;
            }
            if (this.getMIEvent() instanceof MISharedLibEvent) {
                return IRunControl.StateChangeReason.SHAREDLIB;
            }
            if (this.getMIEvent() instanceof MISignalEvent) {
                return IRunControl.StateChangeReason.SIGNAL;
            }
            if (this.getMIEvent() instanceof MIWatchpointTriggerEvent) {
                return IRunControl.StateChangeReason.WATCHPOINT;
            }
            if (this.getMIEvent() instanceof MIErrorEvent) {
                return IRunControl.StateChangeReason.ERROR;
            }
            return IRunControl.StateChangeReason.USER_REQUEST;
        }
    }
}

