/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.ICommandToken;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.service.ExpressionService;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.MIControlDMContext;
import org.eclipse.dd.mi.service.command.commands.ExprMetaGetAttributes;
import org.eclipse.dd.mi.service.command.commands.ExprMetaGetChildCount;
import org.eclipse.dd.mi.service.command.commands.ExprMetaGetChildren;
import org.eclipse.dd.mi.service.command.commands.ExprMetaGetValue;
import org.eclipse.dd.mi.service.command.commands.ExprMetaGetVar;
import org.eclipse.dd.mi.service.command.commands.MIDataEvaluateExpression;
import org.eclipse.dd.mi.service.command.commands.MIVarAssign;
import org.eclipse.dd.mi.service.command.commands.MIVarCreate;
import org.eclipse.dd.mi.service.command.commands.MIVarDelete;
import org.eclipse.dd.mi.service.command.commands.MIVarEvaluateExpression;
import org.eclipse.dd.mi.service.command.commands.MIVarInfoPathExpression;
import org.eclipse.dd.mi.service.command.commands.MIVarListChildren;
import org.eclipse.dd.mi.service.command.commands.MIVarSetFormat;
import org.eclipse.dd.mi.service.command.commands.MIVarShowAttributes;
import org.eclipse.dd.mi.service.command.commands.MIVarUpdate;
import org.eclipse.dd.mi.service.command.output.ExprMetaGetAttributesInfo;
import org.eclipse.dd.mi.service.command.output.ExprMetaGetChildCountInfo;
import org.eclipse.dd.mi.service.command.output.ExprMetaGetChildrenInfo;
import org.eclipse.dd.mi.service.command.output.ExprMetaGetValueInfo;
import org.eclipse.dd.mi.service.command.output.ExprMetaGetVarInfo;
import org.eclipse.dd.mi.service.command.output.MIVar;
import org.eclipse.dd.mi.service.command.output.MIVarAssignInfo;
import org.eclipse.dd.mi.service.command.output.MIVarChange;
import org.eclipse.dd.mi.service.command.output.MIVarCreateInfo;
import org.eclipse.dd.mi.service.command.output.MIVarEvaluateExpressionInfo;
import org.eclipse.dd.mi.service.command.output.MIVarInfoPathExpressionInfo;
import org.eclipse.dd.mi.service.command.output.MIVarListChildrenInfo;
import org.eclipse.dd.mi.service.command.output.MIVarSetFormatInfo;
import org.eclipse.dd.mi.service.command.output.MIVarShowAttributesInfo;
import org.eclipse.dd.mi.service.command.output.MIVarUpdateInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIVariableManager
implements ICommandControl {
    private final DsfSession fSession;
    private final ICommandControl fCommandControl;
    private final IStack fStackService;
    private IExpressions fExpressionService;
    private final MIControlDMContext fControlDmc;
    private final List<ICommandListener> fCommandProcessors = new ArrayList<ICommandListener>();
    private final LRUVariableCache lruVariableList;
    private final LinkedList<MIRootVariableObject> updatedRootList = new LinkedList();

    public MIVariableManager(DsfSession session, DsfServicesTracker tracker) {
        this.fSession = session;
        this.lruVariableList = new LRUVariableCache();
        this.fCommandControl = (ICommandControl)tracker.getService(ICommandControl.class);
        this.fStackService = (IStack)tracker.getService(IStack.class);
        this.fExpressionService = (IExpressions)tracker.getService(IExpressions.class);
        this.fControlDmc = ((AbstractMIControl)this.fCommandControl).getControlDMContext();
        this.fSession.addServiceEventListener((Object)this, null);
    }

    public void dispose() {
        this.fSession.removeServiceEventListener((Object)this);
    }

    private void getVariable(final IExpressions.IExpressionDMContext exprCtx, DataRequestMonitor<MIVariableObject> rm) {
        final VariableObjectId id = new VariableObjectId();
        id.generateId(exprCtx, new RequestMonitor((Executor)this.fSession.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
            final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super(x0, x1);
            }

            protected void handleSuccess() {
                MIVariableManager.this.getVariable(id, exprCtx, (DataRequestMonitor<MIVariableObject>)this.val$rm);
            }
        });
    }

    private void getVariable(final VariableObjectId id, final IExpressions.IExpressionDMContext exprCtx, final DataRequestMonitor<MIVariableObject> rm) {
        final MIVariableObject varObj = this.lruVariableList.get(id);
        if (varObj == null) {
            this.createVariable(id, exprCtx, rm);
        } else {
            varObj.update(new DataRequestMonitor<Boolean>((Executor)this.fSession.getExecutor(), rm){

                protected void handleSuccess() {
                    boolean shouldCreateNew = (Boolean)this.getData();
                    if (varObj.isOutOfScope()) {
                        if (shouldCreateNew) {
                            MIVariableManager.this.createVariable(id, exprCtx, (DataRequestMonitor<MIVariableObject>)rm);
                        } else {
                            MIVariableManager.this.getVariable(id, exprCtx, (DataRequestMonitor<MIVariableObject>)rm);
                        }
                    } else {
                        rm.setData((Object)varObj);
                        rm.done();
                    }
                }
            });
        }
    }

    private void createVariable(VariableObjectId id, IExpressions.IExpressionDMContext exprCtx, DataRequestMonitor<MIVariableObject> rm) {
        final MIRootVariableObject newVarObj = new MIRootVariableObject(id);
        this.lruVariableList.put(id, newVarObj);
        newVarObj.create(exprCtx, new RequestMonitor((Executor)this.fSession.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm, id){
            final /* synthetic */ DataRequestMonitor val$rm;
            final /* synthetic */ VariableObjectId val$id;
            {
                this.val$rm = dataRequestMonitor;
                this.val$id = variableObjectId;
                super(x0, x1);
            }

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIVariableManager.this.updatedRootList.add(newVarObj);
                    this.val$rm.setData((Object)newVarObj);
                    this.val$rm.done();
                } else {
                    MIVariableManager.this.lruVariableList.remove(this.val$id);
                    this.val$rm.setStatus(this.getStatus());
                    this.val$rm.done();
                }
            }
        });
    }

    public void writeValue(IExpressions.IExpressionDMContext ctx, final String expressionValue, final String formatId, final RequestMonitor rm) {
        this.getVariable(ctx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), rm){

            protected void handleSuccess() {
                ((MIVariableObject)this.getData()).writeValue(expressionValue, formatId, rm);
            }
        });
    }

    public <V extends ICommandResult> ICommandToken queueCommand(final ICommand<V> command, DataRequestMonitor<V> rm) {
        final ICommandToken token = new ICommandToken(){

            public ICommand<? extends ICommandResult> getCommand() {
                return command;
            }
        };
        this.processCommandSent(token);
        if (command instanceof ExprMetaGetVar) {
            final DataRequestMonitor<V> drm = rm;
            final ExpressionService.MIExpressionDMC exprCtx = (ExpressionService.MIExpressionDMC)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), drm){

                protected void handleSuccess() {
                    drm.setData((Object)new ExprMetaGetVarInfo(exprCtx.getRelativeExpression(), ((MIVariableObject)this.getData()).getNumChildren(), ((MIVariableObject)this.getData()).getType(), !((MIVariableObject)this.getData()).isComplex()));
                    drm.done();
                    MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                }
            });
        } else if (command instanceof ExprMetaGetAttributes) {
            final DataRequestMonitor<V> drm = rm;
            IExpressions.IExpressionDMContext exprCtx = (IExpressions.IExpressionDMContext)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), drm){

                protected void handleSuccess() {
                    ((MIVariableObject)this.getData()).getAttributes((DataRequestMonitor<Boolean>)((DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            drm.setData((Object)new ExprMetaGetAttributesInfo((Boolean)this.getData()));
                            drm.done();
                            MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                        }
                    }));
                }
            });
        } else if (command instanceof ExprMetaGetValue) {
            final DataRequestMonitor<V> drm = rm;
            final IFormattedValues.FormattedValueDMContext valueCtx = (IFormattedValues.FormattedValueDMContext)command.getContext();
            IExpressions.IExpressionDMContext exprCtx = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)valueCtx, IExpressions.IExpressionDMContext.class);
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), drm){

                protected void handleSuccess() {
                    ((MIVariableObject)this.getData()).getValue(valueCtx, (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)((DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            drm.setData((Object)new ExprMetaGetValueInfo(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue()));
                            drm.done();
                            MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                        }
                    }));
                }
            });
        } else if (command instanceof ExprMetaGetChildren) {
            final DataRequestMonitor<V> drm = rm;
            final ExpressionService.MIExpressionDMC exprCtx = (ExpressionService.MIExpressionDMC)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), drm){

                protected void handleSuccess() {
                    ((MIVariableObject)this.getData()).getChildren(exprCtx, (DataRequestMonitor<ExpressionService.ExpressionInfo[]>)((DataRequestMonitor)new DataRequestMonitor<ExpressionService.ExpressionInfo[]>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            drm.setData((Object)new ExprMetaGetChildrenInfo((ExpressionService.ExpressionInfo[])this.getData()));
                            drm.done();
                            MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                        }
                    }));
                }
            });
        } else if (command instanceof ExprMetaGetChildCount) {
            final DataRequestMonitor<V> drm = rm;
            IExpressions.IExpressionDMContext exprCtx = (IExpressions.IExpressionDMContext)command.getContext();
            this.getVariable(exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.fSession.getExecutor(), drm){

                protected void handleSuccess() {
                    ((MIVariableObject)this.getData()).getChildrenCount((DataRequestMonitor<Integer>)((DataRequestMonitor)new DataRequestMonitor<Integer>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)drm){

                        protected void handleSuccess() {
                            drm.setData((Object)new ExprMetaGetChildCountInfo((Integer)this.getData()));
                            drm.done();
                            MIVariableManager.this.processCommandDone(token, (ICommandResult)drm.getData());
                        }
                    }));
                }
            });
        } else if (command instanceof MIDataEvaluateExpression) {
            this.fCommandControl.queueCommand(command, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, "Unexpected Expression Meta command", null));
            rm.done();
        }
        return token;
    }

    public void removeCommand(ICommandToken token) {
        assert (false);
    }

    public void addCommandListener(ICommandListener processor) {
        this.fCommandProcessors.add(processor);
    }

    public void removeCommandListener(ICommandListener processor) {
        this.fCommandProcessors.remove(processor);
    }

    public void addEventListener(IEventListener processor) {
    }

    public void removeEventListener(IEventListener processor) {
    }

    private void processCommandSent(ICommandToken token) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandSent(token);
        }
    }

    private void processCommandDone(ICommandToken token, ICommandResult result) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandDone(token, result);
        }
    }

    private void markAllOutOfDate() {
        MIRootVariableObject root;
        while ((root = this.updatedRootList.poll()) != null) {
            root.markAsOutOfDate();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.markAllOutOfDate();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMemory.IMemoryChangedEvent e) {
        this.markAllOutOfDate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LRUVariableCache
    extends LinkedHashMap<VariableObjectId, MIVariableObject> {
        public static final long serialVersionUID = 0L;
        private static final int MAX_VARIABLE_LIST = 1000;

        public LRUVariableCache() {
            super(0, 0.75f, true);
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<VariableObjectId, MIVariableObject> eldest) {
            return false;
        }

        @Override
        public MIVariableObject get(Object key) {
            Map.Entry eldest;
            MIVariableObject varObj = (MIVariableObject)super.get(key);
            this.touchAncestors(varObj);
            if (this.size() > 1000 && !((MIVariableObject)(eldest = this.entrySet().iterator().next()).getValue()).equals(varObj) && ((MIVariableObject)eldest.getValue()).currentState == 0) {
                this.remove(eldest.getKey());
            }
            return varObj;
        }

        private void touchAncestors(MIVariableObject varObj) {
            while (varObj != null) {
                if ((varObj = varObj.getParent()) == null) continue;
                super.get(varObj.getInternalId());
            }
        }

        @Override
        public MIVariableObject put(VariableObjectId key, MIVariableObject varObj) {
            MIVariableObject retVal = super.put(key, varObj);
            this.touchAncestors(varObj);
            return retVal;
        }

        @Override
        public MIVariableObject remove(Object key) {
            MIVariableObject varObj = (MIVariableObject)super.remove(key);
            varObj.deleteInGdb();
            return varObj;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MIRootVariableObject
    extends MIVariableObject {
        protected static final int STATE_NOT_CREATED = 10;
        protected static final int STATE_CREATING = 11;
        private boolean outOfDate;
        private Map<String, MIVariableObject> modifiableDescendants;

        public MIRootVariableObject(VariableObjectId id) {
            super(id, null);
            this.outOfDate = false;
            this.currentState = 10;
            this.modifiableDescendants = new HashMap<String, MIVariableObject>();
        }

        public boolean isUpdating() {
            return this.currentState == 1;
        }

        public boolean isOutOfDate() {
            return this.outOfDate;
        }

        public void markAsOutOfDate() {
            this.outOfDate = true;
        }

        public void addModifiableDescendant(String gdbName, MIVariableObject descendant) {
            this.modifiableDescendants.put(gdbName, descendant);
        }

        public void processChanges(MIVarChange[] updates) {
            for (MIVarChange update : updates) {
                MIVariableObject descendant = this.modifiableDescendants.get(update.getVarName());
                if (descendant == null) continue;
                descendant.resetValues(update.getValue());
            }
        }

        public void create(final IExpressions.IExpressionDMContext exprCtx, final RequestMonitor rm) {
            if (this.currentState == 10) {
                this.currentState = 11;
                MIVariableManager.this.fCommandControl.queueCommand((ICommand)new MIVarCreate(exprCtx, exprCtx.getExpression()), (DataRequestMonitor)new DataRequestMonitor<MIVarCreateInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            MIRootVariableObject.this.setGdbName(((MIVarCreateInfo)this.getData()).getName());
                            MIRootVariableObject.this.setExpressionData(exprCtx.getExpression(), ((MIVarCreateInfo)this.getData()).getType(), ((MIVarCreateInfo)this.getData()).getNumChildren());
                            if (((MIVarCreateInfo)this.getData()).getValue() != null && !MIRootVariableObject.this.isArray()) {
                                MIRootVariableObject.this.setValue(MIRootVariableObject.this.getCurrentFormat(), ((MIVarCreateInfo)this.getData()).getValue());
                            }
                            if (MIRootVariableObject.this.isModifiable()) {
                                MIRootVariableObject.this.addModifiableDescendant(((MIVarCreateInfo)this.getData()).getName(), MIRootVariableObject.this);
                            }
                            rm.done();
                            MIRootVariableObject.this.creationCompleted(true);
                        } else {
                            rm.setStatus(this.getStatus());
                            rm.done();
                            MIRootVariableObject.this.creationCompleted(false);
                        }
                    }
                });
            } else assert (false);
        }

        private void creationCompleted(boolean success) {
            if (success) {
                this.currentState = 0;
                while (this.updatesPending.size() > 0) {
                    DataRequestMonitor rm = (DataRequestMonitor)this.updatesPending.poll();
                    rm.setData((Object)false);
                    rm.done();
                }
            } else {
                this.currentState = 10;
                while (this.updatesPending.size() > 0) {
                    RequestMonitor rm = (RequestMonitor)this.updatesPending.poll();
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unable to create variable object", null));
                    rm.done();
                }
            }
        }

        @Override
        public void update(final DataRequestMonitor<Boolean> rm) {
            if (this.isOutOfScope()) {
                rm.setData((Object)false);
                rm.done();
            } else if (this.currentState != 0) {
                this.updatesPending.add(rm);
            } else if (!this.outOfDate) {
                rm.setData((Object)false);
                rm.done();
            } else {
                this.currentState = 1;
                MIVariableManager.this.fCommandControl.queueCommand((ICommand)new MIVarUpdate(MIVariableManager.this.fControlDmc, this.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<MIVarUpdateInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleCompleted() {
                        MIRootVariableObject.this.currentState = 0;
                        if (this.isSuccess()) {
                            MIRootVariableObject.this.outOfDate = false;
                            MIVarChange[] changes = ((MIVarUpdateInfo)this.getData()).getMIVarChanges();
                            if (changes.length > 0 && !changes[0].isInScope()) {
                                MIRootVariableObject.this.outOfScope = true;
                                MIVariableManager.this.lruVariableList.remove(MIRootVariableObject.this.getInternalId());
                                rm.setData((Object)true);
                                rm.done();
                            } else {
                                MIRootVariableObject.this.processChanges(changes);
                                MIVariableManager.this.updatedRootList.add(MIRootVariableObject.this);
                                rm.setData((Object)false);
                                rm.done();
                            }
                            while (MIRootVariableObject.this.updatesPending.size() > 0) {
                                DataRequestMonitor pendingRm = (DataRequestMonitor)MIRootVariableObject.this.updatesPending.poll();
                                pendingRm.setData((Object)false);
                                pendingRm.done();
                            }
                        } else {
                            rm.setData((Object)false);
                            rm.done();
                            while (MIRootVariableObject.this.updatesPending.size() > 0) {
                                DataRequestMonitor pendingRm = (DataRequestMonitor)MIRootVariableObject.this.updatesPending.poll();
                                pendingRm.setStatus(this.getStatus());
                                pendingRm.done();
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void deleteInGdb() {
            if (this.getGdbName() != null) {
                MIVariableManager.this.fCommandControl.queueCommand((ICommand)new MIVarDelete(MIVariableManager.this.fControlDmc, this.getGdbName()), new DataRequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), null));
                this.setGdbName(null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MIVariableObject {
        protected static final int STATE_READY = 0;
        protected static final int STATE_UPDATING = 1;
        protected int currentState = 0;
        private boolean locked = false;
        private final VariableObjectId internalId;
        private String gdbName = null;
        private String format = "NATURAL.Format";
        private String fullExp = null;
        private String type = null;
        private int numChildren = 0;
        private Boolean editable = null;
        private Map<String, String> valueMap = null;
        private LinkedList<RequestMonitor> operationsPending = new LinkedList();
        protected LinkedList<DataRequestMonitor<Boolean>> updatesPending = new LinkedList();
        private ExpressionService.ExpressionInfo[] children = null;
        private MIVariableObject parent = null;
        private MIRootVariableObject rootToUpdate = null;
        protected boolean outOfScope = false;

        public MIVariableObject(VariableObjectId id, MIVariableObject parentObj) {
            this.internalId = id;
            this.setParent(parentObj);
            this.valueMap = new HashMap<String, String>();
            this.resetValues();
        }

        public VariableObjectId getInternalId() {
            return this.internalId;
        }

        public String getGdbName() {
            return this.gdbName;
        }

        public String getCurrentFormat() {
            return this.format;
        }

        public MIVariableObject getParent() {
            return this.parent;
        }

        public MIRootVariableObject getRootToUpdate() {
            return this.rootToUpdate;
        }

        public String getExpression() {
            return this.fullExp;
        }

        public String getType() {
            return this.type;
        }

        public int getNumChildren() {
            return this.numChildren;
        }

        public String getValue(String format) {
            return this.valueMap.get(format);
        }

        public ExpressionService.ExpressionInfo[] getChildren() {
            return this.children;
        }

        public boolean isArray() {
            return this.getType() == null ? false : this.getType().endsWith("]") && !this.getType().contains("(*)");
        }

        public boolean isPointer() {
            return this.getType() == null ? false : this.getType().contains("*") && !this.isArray();
        }

        public boolean isMethod() {
            return this.getType() == null ? false : this.getType().contains("()");
        }

        public boolean isComplex() {
            return this.getType() == null ? false : this.getNumChildren() > 0 && !this.isPointer();
        }

        public void setGdbName(String n) {
            this.gdbName = n;
        }

        public void setCurrentFormat(String f) {
            this.format = f;
        }

        public void setExpressionData(String fullExpression, String t, int num) {
            this.fullExp = fullExpression;
            this.type = t;
            this.numChildren = num;
        }

        public void setValue(String format, String val) {
            this.valueMap.put(format, val);
        }

        public void resetValues(String valueInCurrentFormat) {
            this.resetValues();
            this.setValue(this.getCurrentFormat(), valueInCurrentFormat);
        }

        public void resetValues() {
            this.valueMap.put("NATURAL.Format", null);
            this.valueMap.put("BINARY.Format", null);
            this.valueMap.put("HEX.Format", null);
            this.valueMap.put("OCTAL.Format", null);
            this.valueMap.put("DECIMAL.Format", null);
        }

        public void setChildren(ExpressionService.ExpressionInfo[] c) {
            this.children = c;
        }

        public void setParent(MIVariableObject p) {
            this.parent = p;
            this.rootToUpdate = p == null ? (MIRootVariableObject)this : p.getRootToUpdate();
        }

        public void executeWhenNotUpdating(RequestMonitor rm) {
            this.getRootToUpdate().executeWhenNotUpdating(rm);
        }

        private void lock() {
            this.locked = true;
        }

        private void unlock() {
            this.locked = false;
            while (this.operationsPending.size() > 0) {
                this.operationsPending.poll().done();
            }
        }

        public boolean isOutOfScope() {
            return this.outOfScope;
        }

        public void update(final DataRequestMonitor<Boolean> rm) {
            if (this.isOutOfScope()) {
                rm.setData((Object)false);
                rm.done();
            } else if (this.currentState == 1) {
                this.updatesPending.add(rm);
            } else {
                this.currentState = 1;
                this.getRootToUpdate().update(new DataRequestMonitor<Boolean>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleCompleted() {
                        MIVariableObject.this.currentState = 0;
                        if (this.isSuccess()) {
                            MIVariableObject.this.outOfScope = MIVariableObject.this.getRootToUpdate().isOutOfScope();
                            rm.setData((Object)MIVariableObject.this.outOfScope);
                            rm.done();
                            while (MIVariableObject.this.updatesPending.size() > 0) {
                                DataRequestMonitor<Boolean> pendingRm = MIVariableObject.this.updatesPending.poll();
                                pendingRm.setData((Object)false);
                                pendingRm.done();
                            }
                        } else {
                            rm.setStatus(this.getStatus());
                            rm.done();
                            while (MIVariableObject.this.updatesPending.size() > 0) {
                                DataRequestMonitor<Boolean> pendingRm = MIVariableObject.this.updatesPending.poll();
                                pendingRm.setStatus(this.getStatus());
                                pendingRm.done();
                            }
                        }
                    }
                });
            }
        }

        public void deleteInGdb() {
        }

        private void getAttributes(final DataRequestMonitor<Boolean> rm) {
            if (this.editable != null) {
                rm.setData((Object)this.editable);
                rm.done();
            }
            if (this.isComplex()) {
                this.editable = false;
                rm.setData((Object)this.editable);
                rm.done();
            } else {
                MIVariableManager.this.fCommandControl.queueCommand((ICommand)new MIVarShowAttributes(MIVariableManager.this.fControlDmc, this.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<MIVarShowAttributesInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                    protected void handleSuccess() {
                        MIVariableObject.this.editable = ((MIVarShowAttributesInfo)this.getData()).isEditable();
                        rm.setData((Object)MIVariableObject.this.editable);
                        rm.done();
                    }
                });
            }
        }

        private void getValue(final IFormattedValues.FormattedValueDMContext dmc, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
            String value = this.getValue(dmc.getFormatID());
            if (value != null) {
                rm.setData((Object)new IFormattedValues.FormattedValueDMData(value));
                rm.done();
                return;
            }
            if (this.isComplex()) {
                if (this.isArray()) {
                    IExpressions.IExpressionDMContext exprCxt = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IExpressions.IExpressionDMContext.class);
                    IExpressions.IExpressionDMContext addrCxt = MIVariableManager.this.fExpressionService.createExpression((IDMContext)exprCxt, "&(" + exprCxt.getExpression() + ")");
                    final IFormattedValues.FormattedValueDMContext formatCxt = new IFormattedValues.FormattedValueDMContext(MIVariableManager.this.fSession.getId(), (IDMContext)addrCxt, dmc.getFormatID());
                    MIVariableManager.this.getVariable(addrCxt, (DataRequestMonitor<MIVariableObject>)((DataRequestMonitor)new DataRequestMonitor<MIVariableObject>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                        protected void handleSuccess() {
                            ((MIVariableObject)this.getData()).getValue(formatCxt, (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)rm);
                        }
                    }));
                } else {
                    String complexValue = "{...}";
                    this.setValue(dmc.getFormatID(), complexValue);
                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(complexValue));
                    rm.done();
                }
                return;
            }
            if (this.locked) {
                this.operationsPending.add(new RequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
                    final /* synthetic */ DataRequestMonitor val$rm;
                    {
                        this.val$rm = dataRequestMonitor;
                        super(x0, x1);
                    }

                    protected void handleSuccess() {
                        MIVariableObject.this.getValue(dmc, (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)this.val$rm);
                    }
                });
            } else {
                this.lock();
                if (dmc.getFormatID().equals(this.getCurrentFormat())) {
                    this.evaluate(rm);
                } else {
                    MIVariableManager.this.fCommandControl.queueCommand((ICommand)new MIVarSetFormat(MIVariableManager.this.fControlDmc, this.getGdbName(), dmc.getFormatID()), (DataRequestMonitor)new DataRequestMonitor<MIVarSetFormatInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                        protected void handleCompleted() {
                            if (this.isSuccess()) {
                                MIVariableObject.this.setCurrentFormat(dmc.getFormatID());
                                if (((MIVarSetFormatInfo)this.getData()).getValue() != null) {
                                    MIVariableObject.this.setValue(dmc.getFormatID(), ((MIVarSetFormatInfo)this.getData()).getValue());
                                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(((MIVarSetFormatInfo)this.getData()).getValue()));
                                    rm.done();
                                    MIVariableObject.this.resetFormatToNatural();
                                } else {
                                    MIVariableObject.this.evaluate((DataRequestMonitor<IFormattedValues.FormattedValueDMData>)rm);
                                }
                            } else {
                                rm.setStatus(this.getStatus());
                                rm.done();
                                MIVariableObject.this.unlock();
                            }
                        }
                    });
                }
            }
        }

        private void evaluate(final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
            MIVariableManager.this.fCommandControl.queueCommand((ICommand)new MIVarEvaluateExpression(MIVariableManager.this.fControlDmc, this.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<MIVarEvaluateExpressionInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        MIVariableObject.this.setValue(MIVariableObject.this.getCurrentFormat(), ((MIVarEvaluateExpressionInfo)this.getData()).getValue());
                        rm.setData((Object)new IFormattedValues.FormattedValueDMData(((MIVarEvaluateExpressionInfo)this.getData()).getValue()));
                        rm.done();
                    } else {
                        rm.setStatus(this.getStatus());
                        rm.done();
                    }
                    MIVariableObject.this.resetFormatToNatural();
                }
            });
        }

        private void resetFormatToNatural() {
            if (!this.getCurrentFormat().equals("NATURAL.Format")) {
                MIVariableManager.this.fCommandControl.queueCommand((ICommand)new MIVarSetFormat(MIVariableManager.this.fControlDmc, this.getGdbName(), "NATURAL.Format"), (DataRequestMonitor)new DataRequestMonitor<MIVarSetFormatInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            MIVariableObject.this.setCurrentFormat("NATURAL.Format");
                        }
                        MIVariableObject.this.unlock();
                    }
                });
            } else {
                this.unlock();
            }
        }

        private void getChildren(final ExpressionService.MIExpressionDMC exprDmc, final DataRequestMonitor<ExpressionService.ExpressionInfo[]> rm) {
            ExpressionService.ExpressionInfo[] childrenArray = this.getChildren();
            if (childrenArray != null) {
                rm.setData((Object)childrenArray);
                rm.done();
                return;
            }
            if (this.getNumChildren() == 0) {
                this.setChildren(new ExpressionService.ExpressionInfo[0]);
                rm.setData((Object)this.getChildren());
                rm.done();
                return;
            }
            if (this.isArray()) {
                ExpressionService.ExpressionInfo[] childrenOfArray = new ExpressionService.ExpressionInfo[this.getNumChildren()];
                for (int i = 0; i < childrenOfArray.length; ++i) {
                    String indexStr = "[" + i + "]";
                    String fullExpr = exprDmc.getExpression() + indexStr;
                    String relExpr = exprDmc.getRelativeExpression() + indexStr;
                    childrenOfArray[i] = new ExpressionService.ExpressionInfo(fullExpr, relExpr);
                }
                this.setChildren(childrenOfArray);
                rm.setData((Object)this.getChildren());
                rm.done();
                return;
            }
            MIVariableManager.this.fCommandControl.queueCommand((ICommand)new MIVarListChildren(MIVariableManager.this.fControlDmc, this.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<MIVarListChildrenInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleSuccess() {
                    MIVar[] children = ((MIVarListChildrenInfo)this.getData()).getMIVars();
                    final ArrayList realChildren = new ArrayList();
                    final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            MIVariableObject.this.setChildren(realChildren.toArray(new ExpressionService.ExpressionInfo[realChildren.size()]));
                            rm.setData((Object)MIVariableObject.this.getChildren());
                            rm.done();
                        }
                    };
                    int numSubRequests = 0;
                    for (final MIVar child : children) {
                        ++numSubRequests;
                        DataRequestMonitor<String> childPathRm = new DataRequestMonitor<String>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)countingRm){

                            protected void handleSuccess() {
                                String childFullExpression = (String)this.getData();
                                boolean fakeChild = false;
                                if (childFullExpression.length() == 0) {
                                    fakeChild = true;
                                    childFullExpression = child.getVarName();
                                }
                                VariableObjectId childId = new VariableObjectId();
                                childId.generateId(childFullExpression, MIVariableObject.this.getInternalId());
                                MIVariableObject childVar = MIVariableManager.this.lruVariableList.get(childId);
                                if (childVar != null && childVar.getRootToUpdate().isOutOfScope()) {
                                    childVar.deleteInGdb();
                                    childVar = null;
                                }
                                if (childVar == null) {
                                    childVar = new MIVariableObject(childId, MIVariableObject.this);
                                    childVar.setGdbName(child.getVarName());
                                    childVar.setExpressionData(childFullExpression, child.getType(), child.getNumChild());
                                    MIVariableManager.this.lruVariableList.put(childId, childVar);
                                    if (childVar.isModifiable()) {
                                        MIVariableObject.this.getRootToUpdate().addModifiableDescendant(child.getVarName(), childVar);
                                    }
                                }
                                if (fakeChild) {
                                    childVar.getChildren(exprDmc, (DataRequestMonitor<ExpressionService.ExpressionInfo[]>)((DataRequestMonitor)new DataRequestMonitor<ExpressionService.ExpressionInfo[]>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)countingRm){

                                        protected void handleSuccess() {
                                            ExpressionService.ExpressionInfo[] vars;
                                            for (ExpressionService.ExpressionInfo realChild : vars = (ExpressionService.ExpressionInfo[])this.getData()) {
                                                realChildren.add(realChild);
                                            }
                                            countingRm.done();
                                        }
                                    }));
                                } else {
                                    realChildren.add(new ExpressionService.ExpressionInfo(childFullExpression, child.getExp()));
                                    countingRm.done();
                                }
                            }
                        };
                        if (MIVariableObject.this.isAccessQualifier(child.getExp())) {
                            childPathRm.setData((Object)"");
                            childPathRm.done();
                            continue;
                        }
                        MIVariableManager.this.fCommandControl.queueCommand((ICommand)new MIVarInfoPathExpression(MIVariableManager.this.fControlDmc, child.getVarName()), (DataRequestMonitor)new DataRequestMonitor<MIVarInfoPathExpressionInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), (RequestMonitor)childPathRm, (DataRequestMonitor)childPathRm, child){
                            final /* synthetic */ DataRequestMonitor val$childPathRm;
                            final /* synthetic */ MIVar val$child;
                            {
                                this.val$childPathRm = dataRequestMonitor;
                                this.val$child = mIVar;
                                super(x0, x1);
                            }

                            protected void handleCompleted() {
                                if (this.isSuccess()) {
                                    this.val$childPathRm.setData((Object)((MIVarInfoPathExpressionInfo)this.getData()).getFullExpression());
                                } else {
                                    this.val$childPathRm.setData((Object)MIVariableObject.this.buildChildExpression(exprDmc.getExpression(), this.val$child.getExp()));
                                }
                                this.val$childPathRm.done();
                            }
                        });
                    }
                    countingRm.setDoneCount(numSubRequests);
                }
            });
        }

        private String buildChildExpression(String parentExp, String childExp) {
            return parentExp + "." + childExp;
        }

        private void getChildrenCount(DataRequestMonitor<Integer> rm) {
            rm.setData((Object)this.getNumChildren());
            rm.done();
        }

        private void writeValue(String value, String formatId, final RequestMonitor rm) {
            if (this.isComplex()) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Cannot change the value of a complex expression", null));
                rm.done();
                return;
            }
            if (formatId.equals("HEX.Format")) {
                if (!value.startsWith("0x")) {
                    value = "0x" + value;
                }
            } else if (formatId.equals("OCTAL.Format")) {
                if (!value.startsWith("0")) {
                    value = "0" + value;
                }
            } else if (formatId.equals("BINARY.Format")) {
                if (value.startsWith("0b")) {
                    value = value.substring(2, value.length());
                }
                try {
                    value = Integer.toString(Integer.parseInt(value, 2));
                }
                catch (NumberFormatException e) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid binary number: " + value, (Throwable)e));
                    rm.done();
                    return;
                }
                formatId = "DECIMAL.Format";
            } else if (!formatId.equals("DECIMAL.Format") && !formatId.equals("NATURAL.Format")) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown format: " + formatId, null));
                rm.done();
                return;
            }
            if (value.equals(this.getValue(formatId))) {
                rm.setStatus((IStatus)new Status(2, "org.eclipse.dsdp.debug.gdb.core", 10003, "Setting to the same value of: " + value, null));
                rm.done();
                return;
            }
            MIVariableManager.this.fCommandControl.queueCommand((ICommand)new MIVarAssign(MIVariableManager.this.fControlDmc, this.getGdbName(), value), (DataRequestMonitor)new DataRequestMonitor<MIVarAssignInfo>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleSuccess() {
                    MIVariableManager.this.markAllOutOfDate();
                    rm.done();
                }
            });
        }

        private boolean isAccessQualifier(String str) {
            return str.equals("private") || str.equals("public") || str.equals("protected");
        }

        public boolean isModifiable() {
            return !this.isComplex();
        }
    }

    private class VariableObjectId {
        String fExpression = null;
        Integer fThreadId = null;
        Integer fFrameId = null;

        private VariableObjectId() {
        }

        public boolean equals(Object other) {
            if (other instanceof VariableObjectId) {
                VariableObjectId otherId = (VariableObjectId)other;
                return (this.fExpression == null ? otherId.fExpression == null : this.fExpression.equals(otherId.fExpression)) && (this.fThreadId == null ? otherId.fThreadId == null : this.fThreadId.equals(otherId.fThreadId)) && (this.fFrameId == null ? otherId.fFrameId == null : this.fFrameId.equals(otherId.fFrameId));
            }
            return false;
        }

        public int hashCode() {
            return (this.fExpression == null ? 0 : this.fExpression.hashCode()) + (this.fThreadId == null ? 0 : this.fThreadId.hashCode()) + (this.fFrameId == null ? 0 : this.fFrameId.hashCode());
        }

        public void generateId(IExpressions.IExpressionDMContext exprCtx, final RequestMonitor rm) {
            this.fExpression = exprCtx.getExpression();
            IMIExecutionDMContext execCtx = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)exprCtx, IMIExecutionDMContext.class);
            if (execCtx == null) {
                rm.done();
                return;
            }
            this.fThreadId = new Integer(execCtx.getThreadId());
            final IStack.IFrameDMContext frameCtx = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)exprCtx, IStack.IFrameDMContext.class);
            if (frameCtx == null) {
                rm.done();
                return;
            }
            MIVariableManager.this.fStackService.getStackDepth((IDMContext)execCtx, 0, (DataRequestMonitor)new DataRequestMonitor<Integer>((Executor)MIVariableManager.this.fSession.getExecutor(), rm){

                protected void handleSuccess() {
                    VariableObjectId.this.fFrameId = new Integer((Integer)this.getData() - frameCtx.getLevel());
                    rm.done();
                }
            });
        }

        public void generateId(String childFullExp, VariableObjectId parentId) {
            this.fThreadId = parentId.fThreadId;
            this.fFrameId = parentId.fFrameId;
            this.fExpression = childFullExp;
        }
    }
}

