/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.math.BigInteger;
import org.eclipse.dd.dsf.debug.service.IInstruction;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIInstruction
implements IInstruction {
    BigInteger address;
    String function = "";
    long offset;
    String opcode = "";
    String args = "";

    public MIInstruction(MITuple tuple) {
        this.parse(tuple);
    }

    public BigInteger getAdress() {
        return this.address;
    }

    public String getFuntionName() {
        return this.function;
    }

    public long getOffset() {
        return this.offset;
    }

    public String getInstruction() {
        return this.opcode + " " + this.args;
    }

    public String getOpcode() {
        return this.opcode;
    }

    public String getArgs() {
        return this.args;
    }

    private void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            int index;
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("address")) {
                try {
                    this.address = new BigInteger(str.trim(), 16);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (var.equals("func-name")) {
                this.function = str;
                continue;
            }
            if (var.equals("offset")) {
                try {
                    this.offset = Long.decode(str.trim());
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!var.equals("inst")) continue;
            str = ((MIConst)value).getString();
            char[] chars = str.toCharArray();
            for (index = 0; index < chars.length && chars[index] > ' '; ++index) {
            }
            this.opcode = str.substring(0, index);
            while (index < chars.length && chars[index] >= '\u0000' && chars[index] <= ' ') {
                ++index;
            }
            if (index >= chars.length) continue;
            this.args = str.substring(index);
        }
    }
}

