/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.MIBreakpointDMData;
import org.eclipse.dd.mi.service.command.commands.MIBreakAfter;
import org.eclipse.dd.mi.service.command.commands.MIBreakCondition;
import org.eclipse.dd.mi.service.command.commands.MIBreakDelete;
import org.eclipse.dd.mi.service.command.commands.MIBreakDisable;
import org.eclipse.dd.mi.service.command.commands.MIBreakEnable;
import org.eclipse.dd.mi.service.command.commands.MIBreakInsert;
import org.eclipse.dd.mi.service.command.commands.MIBreakList;
import org.eclipse.dd.mi.service.command.commands.MIBreakWatch;
import org.eclipse.dd.mi.service.command.events.MIGDBExitEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointScopeEvent;
import org.eclipse.dd.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.dd.mi.service.command.output.MIBreakListInfo;
import org.eclipse.dd.mi.service.command.output.MIBreakpoint;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBreakpoints
extends AbstractDsfService
implements IBreakpoints {
    public static final String PREFIX = "org.eclipse.dd.dsf.debug.breakpoint";
    public static final String BREAKPOINT_TYPE = "org.eclipse.dd.dsf.debug.breakpoint.type";
    public static final String BREAKPOINT = "breakpoint";
    public static final String WATCHPOINT = "watchpoint";
    public static final String CATCHPOINT = "catchpoint";
    public static final String FILE_NAME = "org.eclipse.dd.dsf.debug.breakpoint.fileName";
    public static final String LINE_NUMBER = "org.eclipse.dd.dsf.debug.breakpoint.lineNumber";
    public static final String FUNCTION = "org.eclipse.dd.dsf.debug.breakpoint.function";
    public static final String ADDRESS = "org.eclipse.dd.dsf.debug.breakpoint.address";
    public static final String CONDITION = "org.eclipse.dd.dsf.debug.breakpoint.condition";
    public static final String IGNORE_COUNT = "org.eclipse.dd.dsf.debug.breakpoint.ignoreCount";
    public static final String IS_ENABLED = "org.eclipse.dd.dsf.debug.breakpoint.isEnabled";
    public static final String EXPRESSION = "org.eclipse.dd.dsf.debug.breakpoint.expression";
    public static final String READ = "org.eclipse.dd.dsf.debug.breakpoint.read";
    public static final String WRITE = "org.eclipse.dd.dsf.debug.breakpoint.write";
    ICommandControl fConnection;
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<Integer, MIBreakpointDMData>> fBreakpoints = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<Integer, MIBreakpointDMData>>();
    final String NULL_STRING = "";
    final String UNKNOWN_EXECUTION_CONTEXT = "Unknown execution context";
    final String UNKNOWN_BREAKPOINT_CONTEXT = "Unknown breakpoint context";
    final String UNKNOWN_BREAKPOINT_TYPE = "Unknown breakpoint type";
    final String UNKNOWN_BREAKPOINT = "Unknown breakpoint";
    final String BREAKPOINT_INSERTION_FAILURE = "Breakpoint insertion failure";
    final String WATCHPOINT_INSERTION_FAILURE = "Watchpoint insertion failure";
    final String INVALID_CONDITION = "Invalid condition";

    public MIBreakpoints(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MIBreakpoints.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IBreakpoints.class.getName(), MIBreakpoints.class.getName()}, new Hashtable());
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        rm.done();
    }

    protected BundleContext getBundleContext() {
        return MIPlugin.getBundleContext();
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIWatchpointScopeEvent e) {
        Map<Integer, MIBreakpointDMData> contextBps;
        IBreakpoints.IBreakpointsTargetDMContext bpContext = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)e.getDMContext(), IBreakpoints.IBreakpointsTargetDMContext.class);
        if (bpContext != null && (contextBps = this.fBreakpoints.get(bpContext)) != null) {
            contextBps.remove(e.getNumber());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIGDBExitEvent e) {
    }

    public void getBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext context, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext[]> drm) {
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown execution context", null));
            drm.done();
            return;
        }
        final Map<Integer, MIBreakpointDMData> breakpointContext = this.fBreakpoints.get(context);
        if (breakpointContext == null) {
            drm.setData((Object)new IBreakpoints.IBreakpointDMContext[0]);
            drm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new MIBreakList(context), (DataRequestMonitor)new DataRequestMonitor<MIBreakListInfo>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                breakpointContext.clear();
                MIBreakpoint[] breakpoints = ((MIBreakListInfo)this.getData()).getMIBreakpoints();
                IBreakpoints.IBreakpointDMContext[] result = new IBreakpoints.IBreakpointDMContext[breakpoints.length];
                for (int i = 0; i < breakpoints.length; ++i) {
                    MIBreakpointDMData breakpoint = new MIBreakpointDMData(breakpoints[i]);
                    int reference = breakpoint.getReference();
                    result[i] = new MIBreakpointDMContext(MIBreakpoints.this, new IDMContext[]{context}, reference);
                    breakpointContext.put(reference, breakpoint);
                }
                drm.setData((Object)result);
                drm.done();
            }
        });
    }

    public void getBreakpointDMData(IBreakpoints.IBreakpointDMContext dmc, DataRequestMonitor<IBreakpoints.IBreakpointDMData> drm) {
        if (dmc == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            drm.done();
            return;
        }
        if (!(dmc instanceof MIBreakpointDMContext)) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint type", null));
            drm.done();
            return;
        }
        MIBreakpointDMContext breakpoint = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)breakpoint, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown execution context", null));
            drm.done();
            return;
        }
        Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
            drm.done();
            return;
        }
        MIBreakpointDMData breakpointCopy = new MIBreakpointDMData(contextBreakpoints.get(breakpoint.getReference()));
        drm.setData((Object)breakpointCopy);
        drm.done();
    }

    public void insertBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, Map<String, Object> attributes, DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        String type;
        if (context == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown execution context", null));
            drm.done();
            return;
        }
        Map<Integer, MIBreakpointDMData> breakpointContext = this.fBreakpoints.get(context);
        if (breakpointContext == null) {
            breakpointContext = new HashMap<Integer, MIBreakpointDMData>();
            this.fBreakpoints.put(context, breakpointContext);
        }
        if ((type = (String)attributes.get(BREAKPOINT_TYPE)) == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint type", null));
            drm.done();
            return;
        }
        if (type.equals(BREAKPOINT)) {
            this.addBreakpoint(context, attributes, drm);
        } else if (type.equals(WATCHPOINT)) {
            this.addWatchpoint(context, attributes, drm);
        } else {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint type", null));
            drm.done();
        }
    }

    public Object getProperty(Map<String, Object> map, String key, Object defaultValue) {
        return map.containsKey(key) && map.get(key) != null ? map.get(key) : defaultValue;
    }

    private String formatLocation(Map<String, Object> attributes) {
        String location = (String)this.getProperty(attributes, ADDRESS, "");
        String fileName = (String)this.getProperty(attributes, FILE_NAME, "");
        Integer lineNumber = (Integer)this.getProperty(attributes, LINE_NUMBER, -1);
        String function = (String)this.getProperty(attributes, FUNCTION, "");
        if (!fileName.equals("")) {
            location = lineNumber != -1 ? fileName + ":" + lineNumber : fileName + ":" + function;
        } else if (!function.equals("")) {
            location = function;
        } else if (location.length() > 0 && Character.isDigit(location.charAt(0))) {
            location = '*' + location;
        }
        return location;
    }

    private void addBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            drm.done();
            return;
        }
        String location = this.formatLocation(attributes);
        if (location.equals("")) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            drm.done();
            return;
        }
        Boolean isTemporary = (Boolean)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.mi.isTemporary", false);
        Boolean isHardware = (Boolean)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.mi.isHardware", false);
        String condition = (String)this.getProperty(attributes, CONDITION, "");
        Integer ignoreCount = (Integer)this.getProperty(attributes, IGNORE_COUNT, 0);
        String threadId = (String)this.getProperty(attributes, "org.eclipse.dd.dsf.debug.breakpoint.mi.threadId", "0");
        int tid = Integer.parseInt(threadId);
        DataRequestMonitor<MIBreakInsertInfo> addBreakpointDRM = new DataRequestMonitor<MIBreakInsertInfo>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                if (((MIBreakInsertInfo)this.getData()).getMIBreakpoints().length == 0) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Breakpoint insertion failure", null));
                    drm.done();
                    return;
                }
                MIBreakpointDMData newBreakpoint = new MIBreakpointDMData(((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0]);
                int reference = newBreakpoint.getNumber();
                if (reference == -1) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Breakpoint insertion failure", null));
                    drm.done();
                    return;
                }
                contextBreakpoints.put(reference, newBreakpoint);
                MIBreakpointDMContext dmc = new MIBreakpointDMContext(MIBreakpoints.this, new IDMContext[]{context}, reference);
                drm.setData((Object)dmc);
                MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointAddedEvent(dmc), MIBreakpoints.this.getProperties());
                HashMap<String, Object> delta = new HashMap<String, Object>();
                delta.put(MIBreakpoints.IS_ENABLED, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.IS_ENABLED, true));
                MIBreakpoints.this.modifyBreakpoint(dmc, delta, (RequestMonitor)drm, false);
            }

            protected void handleError() {
                drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Breakpoint insertion failure", null));
                drm.done();
            }
        };
        this.fConnection.queueCommand((ICommand)new MIBreakInsert(context, isTemporary, isHardware, condition, ignoreCount, location, tid), (DataRequestMonitor)addBreakpointDRM);
    }

    private void addWatchpoint(final IBreakpoints.IBreakpointsTargetDMContext context, final Map<String, Object> attributes, final DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            drm.done();
            return;
        }
        String expression = (String)this.getProperty(attributes, EXPRESSION, "");
        boolean isRead = (Boolean)this.getProperty(attributes, READ, false);
        boolean isWrite = (Boolean)this.getProperty(attributes, WRITE, false);
        DataRequestMonitor<MIBreakInsertInfo> addWatchpointDRM = new DataRequestMonitor<MIBreakInsertInfo>((Executor)this.getExecutor(), drm){

            protected void handleSuccess() {
                if (((MIBreakInsertInfo)this.getData()).getMIBreakpoints().length == 0) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Watchpoint insertion failure", null));
                    drm.done();
                    return;
                }
                MIBreakpointDMData newBreakpoint = new MIBreakpointDMData(((MIBreakInsertInfo)this.getData()).getMIBreakpoints()[0]);
                int reference = newBreakpoint.getNumber();
                if (reference == -1) {
                    drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Watchpoint insertion failure", null));
                    drm.done();
                    return;
                }
                contextBreakpoints.put(reference, newBreakpoint);
                MIBreakpointDMContext dmc = new MIBreakpointDMContext(MIBreakpoints.this, new IDMContext[]{context}, reference);
                drm.setData((Object)dmc);
                MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointAddedEvent(dmc), MIBreakpoints.this.getProperties());
                HashMap<String, Object> delta = new HashMap<String, Object>();
                delta.put(MIBreakpoints.CONDITION, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.CONDITION, ""));
                delta.put(MIBreakpoints.IGNORE_COUNT, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.IGNORE_COUNT, 0));
                delta.put(MIBreakpoints.IS_ENABLED, MIBreakpoints.this.getProperty(attributes, MIBreakpoints.IS_ENABLED, true));
                MIBreakpoints.this.modifyBreakpoint(dmc, delta, (RequestMonitor)drm, false);
            }

            protected void handleError() {
                drm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Watchpoint insertion failure", null));
                drm.done();
            }
        };
        this.fConnection.queueCommand((ICommand)new MIBreakWatch(context, isRead, isWrite, expression), (DataRequestMonitor)addWatchpointDRM);
    }

    public void removeBreakpoint(final IBreakpoints.IBreakpointDMContext dmc, final RequestMonitor rm) {
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        if (!(dmc instanceof MIBreakpointDMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint type", null));
            rm.done();
            return;
        }
        MIBreakpointDMContext breakpointCtx = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown execution context", null));
            rm.done();
            return;
        }
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
            rm.done();
            return;
        }
        final int reference = breakpointCtx.getReference();
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        if (breakpoint == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new MIBreakDelete(context, new int[]{reference}), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (this.isSuccess()) {
                    MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointRemovedEvent(dmc), MIBreakpoints.this.getProperties());
                    contextBreakpoints.remove(reference);
                }
                rm.done();
            }
        });
    }

    public void updateBreakpoint(IBreakpoints.IBreakpointDMContext dmc, Map<String, Object> properties, RequestMonitor rm) {
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        if (!(dmc instanceof MIBreakpointDMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint type", null));
            rm.done();
            return;
        }
        MIBreakpointDMContext breakpointCtx = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
        if (context == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown execution context", null));
            rm.done();
            return;
        }
        Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
            rm.done();
            return;
        }
        int reference = breakpointCtx.getReference();
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        if (breakpoint == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
            rm.done();
            return;
        }
        this.modifyBreakpoint(dmc, properties, rm, true);
    }

    private void modifyBreakpoint(final IBreakpoints.IBreakpointDMContext dmc, Map<String, Object> attributes, final RequestMonitor rm, final boolean generateUpdateEvent) {
        String enableAttribute;
        String ignoreCountAttribute;
        HashMap<String, Object> properties = new HashMap<String, Object>(attributes);
        MIBreakpointDMContext breakpointCtx = (MIBreakpointDMContext)dmc;
        IBreakpoints.IBreakpointsTargetDMContext context = (IBreakpoints.IBreakpointsTargetDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IBreakpoints.IBreakpointsTargetDMContext.class);
        Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        int reference = breakpointCtx.getReference();
        MIBreakpointDMData breakpoint = contextBreakpoints.get(reference);
        int numberOfChanges = 0;
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (generateUpdateEvent) {
                    MIBreakpoints.this.getSession().dispatchEvent((Object)new BreakpointUpdatedEvent(dmc), MIBreakpoints.this.getProperties());
                }
                rm.done();
            }
        };
        String conditionAttribute = CONDITION;
        if (properties.containsKey(conditionAttribute)) {
            String oldValue = breakpoint.getCondition();
            String newValue = (String)properties.get(conditionAttribute);
            if (newValue == null) {
                newValue = "";
            }
            if (!oldValue.equals(newValue)) {
                this.changeCondition(context, reference, newValue, (RequestMonitor)countingRm);
                ++numberOfChanges;
            }
            properties.remove(conditionAttribute);
        }
        if (properties.containsKey(ignoreCountAttribute = IGNORE_COUNT)) {
            Integer oldValue = breakpoint.getIgnoreCount();
            Integer newValue = (Integer)properties.get(ignoreCountAttribute);
            if (newValue == null) {
                newValue = 0;
            }
            if (!oldValue.equals(newValue)) {
                this.changeIgnoreCount(context, reference, newValue, (RequestMonitor)countingRm);
                ++numberOfChanges;
            }
            properties.remove(ignoreCountAttribute);
        }
        if (properties.containsKey(enableAttribute = IS_ENABLED)) {
            Boolean oldValue = breakpoint.isEnabled();
            Boolean newValue = (Boolean)properties.get(enableAttribute);
            if (newValue == null) {
                newValue = false;
            }
            if (!oldValue.equals(newValue)) {
                ++numberOfChanges;
                if (newValue.booleanValue()) {
                    this.enableBreakpoint(context, reference, (RequestMonitor)countingRm);
                } else {
                    this.disableBreakpoint(context, reference, (RequestMonitor)countingRm);
                }
            }
            properties.remove(enableAttribute);
        }
        countingRm.setDoneCount(numberOfChanges);
    }

    private void changeCondition(final IBreakpoints.IBreakpointsTargetDMContext context, final int reference, final String condition, final RequestMonitor rm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new MIBreakCondition(context, reference, condition), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                if (breakpoint == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
                    rm.done();
                    return;
                }
                breakpoint.setCondition(condition);
                rm.done();
            }

            protected void handleError() {
                MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                if (breakpoint == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
                    rm.done();
                    return;
                }
                breakpoint.setCondition("");
                MIBreakpoints.this.fConnection.queueCommand((ICommand)new MIBreakCondition(context, reference, ""), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)MIBreakpoints.this.getExecutor(), rm){

                    protected void handleCompleted() {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Invalid condition", null));
                        rm.done();
                    }
                });
            }
        });
    }

    private void changeIgnoreCount(IBreakpoints.IBreakpointsTargetDMContext context, final int reference, final int ignoreCount, final RequestMonitor rm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new MIBreakAfter(context, reference, ignoreCount), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                if (breakpoint == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
                    rm.done();
                    return;
                }
                breakpoint.setIgnoreCount(ignoreCount);
                rm.done();
            }
        });
    }

    private void enableBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, final int reference, final RequestMonitor rm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new MIBreakEnable(context, new int[]{reference}), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                if (breakpoint == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
                    rm.done();
                    return;
                }
                breakpoint.setEnabled(true);
                rm.done();
            }
        });
    }

    private void disableBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, final int reference, final RequestMonitor rm) {
        final Map<Integer, MIBreakpointDMData> contextBreakpoints = this.fBreakpoints.get(context);
        if (contextBreakpoints == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint context", null));
            rm.done();
            return;
        }
        this.fConnection.queueCommand((ICommand)new MIBreakDisable(context, new int[]{reference}), (DataRequestMonitor)new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MIBreakpointDMData breakpoint = (MIBreakpointDMData)contextBreakpoints.get(reference);
                if (breakpoint == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Unknown breakpoint", null));
                    rm.done();
                    return;
                }
                breakpoint.setEnabled(false);
                rm.done();
            }
        });
    }

    public class BreakpointAddedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointsAddedEvent {
        public BreakpointAddedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }
    }

    public class BreakpointRemovedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointsRemovedEvent {
        public BreakpointRemovedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }
    }

    public class BreakpointUpdatedEvent
    extends BreakpointsChangedEvent
    implements IBreakpoints.IBreakpointsUpdatedEvent {
        public BreakpointUpdatedEvent(IBreakpoints.IBreakpointDMContext context) {
            super(context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BreakpointsChangedEvent
    extends AbstractDMEvent<IBreakpoints.IBreakpointsTargetDMContext>
    implements IBreakpoints.IBreakpointsChangedEvent {
        private IBreakpoints.IBreakpointDMContext[] fEventBreakpoints;

        public BreakpointsChangedEvent(IBreakpoints.IBreakpointDMContext bp) {
            super(DMContexts.getAncestorOfType((IDMContext)bp, IBreakpoints.IBreakpointsTargetDMContext.class));
            this.fEventBreakpoints = new IBreakpoints.IBreakpointDMContext[]{bp};
        }

        public IBreakpoints.IBreakpointDMContext[] getBreakpoints() {
            return this.fEventBreakpoints;
        }
    }

    @Immutable
    public static final class MIBreakpointDMContext
    extends AbstractDMContext
    implements IBreakpoints.IBreakpointDMContext {
        private final Integer fReference;

        public MIBreakpointDMContext(MIBreakpoints service, IDMContext[] parents, int reference) {
            super(service.getSession().getId(), parents);
            this.fReference = reference;
        }

        public int getReference() {
            return this.fReference;
        }

        public boolean equals(Object obj) {
            return this.baseEquals(obj) && this.fReference == ((MIBreakpointDMContext)((Object)obj)).fReference;
        }

        public int hashCode() {
            return this.baseHashCode() + this.fReference.hashCode();
        }

        public String toString() {
            return this.baseToString() + ".reference(" + this.fReference + ")";
        }
    }
}

