/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.events;

import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MILogStreamOutput;
import org.eclipse.dd.mi.service.command.output.MIOOBRecord;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIStreamRecord;
import org.eclipse.dd.mi.service.command.output.MIValue;

@Immutable
public class MIErrorEvent
extends MIStoppedEvent {
    private final String msg;
    private final String log;
    private final MIOOBRecord[] oobs;

    protected MIErrorEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIOOBRecord[] oobs, String msg, String log) {
        super(ctx, token, results, null);
        this.msg = msg;
        this.log = log;
        this.oobs = oobs;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getLogMessage() {
        return this.log;
    }

    public static MIErrorEvent parse(IRunControl.IContainerDMContext containerDmc, int token, MIResult[] results, MIOOBRecord[] oobs) {
        String msg = "";
        String log = "";
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof MIConst) {
                    str = ((MIConst)value).getString();
                }
                if (!var.equals("msg")) continue;
                msg = str;
            }
        }
        if (oobs != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < oobs.length; ++i) {
                if (!(oobs[i] instanceof MILogStreamOutput)) continue;
                MIStreamRecord o = (MIStreamRecord)oobs[i];
                sb.append(o.getString());
            }
            log = sb.toString();
        }
        return new MIErrorEvent((IRunControl.IExecutionDMContext)containerDmc, token, results, oobs, msg, log);
    }

    public String toString() {
        if (this.oobs != null) {
            StringBuilder builder = new StringBuilder();
            for (MIOOBRecord oob : this.oobs) {
                builder.append(oob.toString());
            }
            builder.append(super.toString());
            return builder.toString();
        }
        return super.toString();
    }
}

