/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;
import org.eclipse.dd.mi.service.command.output.MIVarChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIVarUpdateInfo
extends MIInfo {
    MIVarChange[] changeList;

    public MIVarUpdateInfo(MIOutput record) {
        super(record);
        MIOutput out;
        MIResultRecord rr;
        ArrayList<MIVarChange> aList = new ArrayList<MIVarChange>();
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                if (!var.equals("changelist")) continue;
                MIValue value = results[i].getMIValue();
                if (value instanceof MITuple) {
                    this.parseChangeList((MITuple)value, aList);
                    continue;
                }
                if (!(value instanceof MIList)) continue;
                this.parseChangeList((MIList)value, aList);
            }
        }
        this.changeList = aList.toArray(new MIVarChange[aList.size()]);
    }

    public MIVarChange[] getMIVarChanges() {
        return this.changeList;
    }

    void parseChangeList(MIList miList, List<MIVarChange> aList) {
        MIValue[] values = miList.getMIValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof MITuple) {
                this.parseChangeList((MITuple)values[i], aList);
                continue;
            }
            if (!(values[i] instanceof MIList)) continue;
            this.parseChangeList((MIList)values[i], aList);
        }
    }

    void parseChangeList(MITuple tuple, List<MIVarChange> aList) {
        MIResult[] results = tuple.getMIResults();
        MIVarChange change = null;
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            if (value instanceof MITuple) {
                this.parseChangeList((MITuple)value, aList);
                continue;
            }
            String str = "";
            if (value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("name")) {
                change = new MIVarChange(str);
                aList.add(change);
                continue;
            }
            if (var.equals("value")) {
                if (change == null) continue;
                change.setValue(str);
                continue;
            }
            if (var.equals("in_scope")) {
                if (change == null) continue;
                change.setInScope("true".equals(str));
                continue;
            }
            if (!var.equals("type_changed") || change == null) continue;
            change.setChanged("true".equals(str));
        }
    }
}

