/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.mi.service.command.output.MIBreakpoint;

public class MIBreakpointDMData
implements IBreakpoints.IBreakpointDMData {
    public static final String DSFMIBREAKPOINT = "org.eclipse.dd.dsf.debug.breakpoint.mi";
    public static final String NUMBER = "org.eclipse.dd.dsf.debug.breakpoint.mi.number";
    public static final String TYPE = "org.eclipse.dd.dsf.debug.breakpoint.mi.type";
    public static final String THREAD_ID = "org.eclipse.dd.dsf.debug.breakpoint.mi.threadId";
    public static final String FULL_NAME = "org.eclipse.dd.dsf.debug.breakpoint.mi.fullName";
    public static final String HITS = "org.eclipse.dd.dsf.debug.breakpoint.mi.hits";
    public static final String IS_TEMPORARY = "org.eclipse.dd.dsf.debug.breakpoint.mi.isTemporary";
    public static final String IS_HARDWARE = "org.eclipse.dd.dsf.debug.breakpoint.mi.isHardware";
    public static final String LOCATION = "org.eclipse.dd.dsf.debug.breakpoint.mi.location";
    private final MIBreakpoint fBreakpoint;
    private final Map<String, Object> fProperties;
    private final MIBreakpointNature fNature;

    public MIBreakpointDMData(MIBreakpointDMData other) {
        this.fBreakpoint = new MIBreakpoint(other.fBreakpoint);
        this.fProperties = new HashMap<String, Object>(other.fProperties);
        this.fNature = other.fNature;
    }

    public MIBreakpointDMData(MIBreakpoint dsfMIBreakpoint) {
        this.fBreakpoint = dsfMIBreakpoint;
        this.fNature = dsfMIBreakpoint.isWatchpoint() ? MIBreakpointNature.WATCHPOINT : MIBreakpointNature.BREAKPOINT;
        this.fProperties = new HashMap<String, Object>();
        switch (this.fNature) {
            case BREAKPOINT: {
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", dsfMIBreakpoint.getFile());
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", dsfMIBreakpoint.getLine());
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.function", dsfMIBreakpoint.getFunction());
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.address", dsfMIBreakpoint.getAddress());
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.condition", dsfMIBreakpoint.getCondition());
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", dsfMIBreakpoint.getIgnoreCount());
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", new Boolean(dsfMIBreakpoint.isEnabled()));
                this.fProperties.put(NUMBER, dsfMIBreakpoint.getNumber());
                this.fProperties.put(TYPE, dsfMIBreakpoint.getType());
                this.fProperties.put(THREAD_ID, dsfMIBreakpoint.getThreadId());
                this.fProperties.put(FULL_NAME, dsfMIBreakpoint.getFullName());
                this.fProperties.put(HITS, dsfMIBreakpoint.getTimes());
                this.fProperties.put(IS_TEMPORARY, new Boolean(dsfMIBreakpoint.isTemporary()));
                this.fProperties.put(IS_HARDWARE, new Boolean(dsfMIBreakpoint.isHardware()));
                this.fProperties.put(LOCATION, this.formatLocation());
                break;
            }
            case WATCHPOINT: {
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.expression", dsfMIBreakpoint.getExpression());
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.read", dsfMIBreakpoint.isAccessWatchpoint() || dsfMIBreakpoint.isReadWatchpoint());
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.write", dsfMIBreakpoint.isAccessWatchpoint() || dsfMIBreakpoint.isWriteWatchpoint());
                this.fProperties.put(NUMBER, dsfMIBreakpoint.getNumber());
                break;
            }
            default: {
                this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.type", null);
            }
        }
    }

    private String formatLocation() {
        String location = this.fBreakpoint.getAddress();
        String fileName = this.fBreakpoint.getFile();
        Integer lineNumber = this.fBreakpoint.getLine();
        String function = this.fBreakpoint.getFunction();
        if (!fileName.equals("")) {
            location = lineNumber != -1 ? fileName + ":" + lineNumber : fileName + ":" + function;
        }
        return location;
    }

    public boolean equals(MIBreakpointDMData other) {
        return this.fNature == other.fNature && ((Object)this.fProperties).equals(other.fProperties);
    }

    public String getBreakpointType() {
        return (String)this.fProperties.get("org.eclipse.dd.dsf.debug.breakpoint.type");
    }

    public int getReference() {
        return this.fBreakpoint.getNumber();
    }

    public IAddress[] getAddresses() {
        IAddress[] addresses = new IAddress[]{new Addr64(this.fBreakpoint.getAddress())};
        return addresses;
    }

    public String getCondition() {
        return this.fBreakpoint.getCondition();
    }

    public String getExpression() {
        return this.fBreakpoint.getExpression();
    }

    public String getFileName() {
        return this.fBreakpoint.getFile();
    }

    public String getFunctionName() {
        return this.fBreakpoint.getFunction();
    }

    public int getIgnoreCount() {
        return this.fBreakpoint.getIgnoreCount();
    }

    public int getLineNumber() {
        return this.fBreakpoint.getLine();
    }

    public boolean isEnabled() {
        return this.fBreakpoint.isEnabled();
    }

    public int getNumber() {
        return this.fBreakpoint.getNumber();
    }

    public String getThreadId() {
        return this.fBreakpoint.getThreadId();
    }

    public boolean isTemporary() {
        return this.fBreakpoint.isTemporary();
    }

    public boolean isHardware() {
        return this.fBreakpoint.isHardware();
    }

    public String getLocation() {
        return (String)this.fProperties.get(LOCATION);
    }

    public int getHits() {
        return this.fBreakpoint.getTimes();
    }

    public String getFullName() {
        return this.fBreakpoint.getFullName();
    }

    public String getType() {
        return this.fBreakpoint.getType();
    }

    public void setCondition(String condition) {
        this.fBreakpoint.setCondition(condition);
        this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.condition", condition);
    }

    public void setIgnoreCount(int ignoreCount) {
        this.fBreakpoint.setIgnoreCount(ignoreCount);
        this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", ignoreCount);
    }

    public void setEnabled(boolean isEnabled) {
        this.fBreakpoint.setEnabled(isEnabled);
        this.fProperties.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", isEnabled);
    }

    public boolean isReadWatchpoint() {
        return this.fBreakpoint.isReadWatchpoint();
    }

    public boolean isWriteWatchpoint() {
        return this.fBreakpoint.isWriteWatchpoint();
    }

    public boolean isAccessWatchpoint() {
        return this.fBreakpoint.isAccessWatchpoint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MIBreakpointNature {
        UNKNOWN,
        BREAKPOINT,
        WATCHPOINT,
        CATCHPOINT;

    }
}

