/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.viewmodel.launch;

import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.AbstractThreadVMNode;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.IMemento;

public class ThreadVMNode
extends AbstractThreadVMNode
implements IElementLabelProvider,
IElementMementoProvider {
    private static final String MEMENTO_NAME = "THREAD_MEMENTO_NAME";

    public ThreadVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    public String toString() {
        return "ThreadVMNode(" + this.getSession().getId() + ")";
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            boolean threadSuspended;
            IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
            if (runControl == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IMIExecutionDMContext.class);
            String imageKey = null;
            if (runControl.isSuspended((IRunControl.IExecutionDMContext)execDmc)) {
                threadSuspended = true;
                imageKey = "IMG_OBJS_THREAD_SUSPENDED";
            } else {
                threadSuspended = false;
                imageKey = "IMG_OBJS_THREAD_RUNNING";
            }
            update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
            runControl.getExecutionData((IRunControl.IExecutionDMContext)execDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IRunControl.IExecutionDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        update.setLabel("<unavailable>", 0);
                        update.done();
                        return;
                    }
                    IProcesses procService = (IProcesses)ThreadVMNode.this.getServicesTracker().getService(IProcesses.class);
                    if (procService == null) {
                        ThreadVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    final IRunControl.StateChangeReason reason = ((IRunControl.IExecutionDMData)this.getData()).getStateChangeReason();
                    IProcesses.IThreadDMContext threadDmc = (IProcesses.IThreadDMContext)ThreadVMNode.this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IProcesses.IThreadDMContext.class);
                    procService.getExecutionData(threadDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IProcesses.IThreadDMData>((Executor)ThreadVMNode.this.getSession().getExecutor(), (IViewerUpdate)update){

                        public void handleCompleted() {
                            StringBuilder builder = new StringBuilder("Thread[");
                            builder.append(execDmc.getThreadId());
                            builder.append("] ");
                            if (this.isSuccess()) {
                                builder.append(((IProcesses.IThreadDMData)this.getData()).getId());
                                builder.append(((IProcesses.IThreadDMData)this.getData()).getName());
                            }
                            if (threadSuspended) {
                                builder.append(" (Suspended");
                            } else {
                                builder.append(" (Running");
                            }
                            if (reason != null) {
                                builder.append(" : ");
                                builder.append(reason);
                            }
                            builder.append(")");
                            update.setLabel(builder.toString(), 0);
                            update.done();
                        }
                    });
                }
            });
        }
    }

    private String produceThreadElementName(String viewName, IMIExecutionDMContext execCtx) {
        return "Thread." + execCtx.getThreadId();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        for (IElementCompareRequest request : requests) {
            IDMContext dmc;
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString(MEMENTO_NAME);
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IMIExecutionDMContext) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (IMIExecutionDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        for (IElementMementoRequest request : requests) {
            IDMContext dmc;
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IMIExecutionDMContext) {
                String elementName = this.produceThreadElementName(request.getPresentationContext().getId(), (IMIExecutionDMContext)dmc);
                memento.putString(MEMENTO_NAME, elementName);
            }
            request.done();
        }
    }
}

