/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.breakpointactions.BreakpointActionManager;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpoint;
import org.eclipse.cdt.debug.core.model.ICBreakpointExtension;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.ICWatchpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IDsfBreakpointExtension;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.MIBreakpoints;
import org.eclipse.dd.mi.service.breakpoint.actions.BreakpointActionAdapter;
import org.eclipse.dd.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.dd.mi.service.command.events.MIGDBExitEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointScopeEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBreakpointsManager
extends AbstractDsfService
implements IBreakpointManagerListener,
IBreakpointListener {
    public static final String GDB_DEBUG_MODEL_ID = "org.eclipse.dd.gdb";
    private static final String ATTR_DEBUGGER_PATH = "org.eclipse.dsdp.debug.gdb.core.debuggerPath";
    private static final String ATTR_THREAD_FILTER = "org.eclipse.dsdp.debug.gdb.core.threadFilter";
    private static final String ATTR_THREAD_ID = "org.eclipse.dsdp.debug.gdb.core.threadID";
    ICommandControl fConnection;
    IRunControl fRunControl;
    ISourceLookup fSourceLookup;
    IBreakpoints fBreakpoints;
    IBreakpointManager fBreakpointManager;
    BreakpointActionManager fBreakpointActionManager;
    private String fDebugModelId;
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Map<String, Object>>> fPlatformBPs = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Map<String, Object>>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint>> fTargetBPs = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>>> fBreakpointIDs = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>>>();
    private Map<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Set<String>>> fBreakpointThreads = new HashMap<IBreakpoints.IBreakpointsTargetDMContext, Map<ICBreakpoint, Set<String>>>();
    private Set<IBreakpoint> fPendingRequests = new HashSet<IBreakpoint>();
    private Set<IBreakpoint> fPendingBreakpoints = new HashSet<IBreakpoint>();
    private Map<ICBreakpoint, IMarker> fBreakpointMarkerProblems = new HashMap<ICBreakpoint, IMarker>();
    private static final String NULL_STRING = "";
    static final String CONTEXT_ALREADY_INITIALIZED = "Context already initialized";
    static final String INVALID_CONTEXT_TYPE = "Invalid context type";
    static final String INVALID_CONTEXT = "Invalid context";
    static final String UNABLE_TO_READ_BREAKPOINT = "Unable to read initial breakpoint attributes";
    static final String BREAKPOINT_NOT_INSTALLED = "Breakpoints not installed for given context";
    static final String BREAKPOINT_ALREADY_INSTALLED = "Breakpoint already installed";
    static final String BREAKPOINT_ALREADY_REMOVED = "Breakpoint already removed";
    static final String INVALID_BREAKPOINT = "Invalid breakpoint";
    static final String UNKNOWN_BREAKPOINT = "Unknown breakpoint";
    static final String INVALID_PARAMETER = "Invalid breakpoint parameter(s)";
    static final String NO_DEBUGGER_PATH = "No debugger path for breakpoint";
    static final String NO_MARKER_FOR_BREAKPOINT = "No marker associated with breakpoint";

    public MIBreakpointsManager(DsfSession session, String debugModelId) {
        super(session);
        this.fDebugModelId = debugModelId;
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                MIBreakpointsManager.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fRunControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        this.fSourceLookup = (ISourceLookup)this.getServicesTracker().getService(ISourceLookup.class);
        this.fBreakpoints = (IBreakpoints)this.getServicesTracker().getService(IBreakpoints.class);
        this.fBreakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.fBreakpointActionManager = CDebugCorePlugin.getDefault().getBreakpointActionManager();
        this.getSession().addServiceEventListener((Object)this, null);
        this.fBreakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        this.register(new String[]{MIBreakpointsManager.class.getName()}, new Hashtable());
        rm.done();
    }

    public void shutdown(final RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        this.fBreakpointManager.removeBreakpointListener((IBreakpointListener)this);
        this.fBreakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                MIBreakpointsManager.super.shutdown(rm);
            }
        };
        ArrayList<IBreakpoints.IBreakpointsTargetDMContext> targetBPKeys = new ArrayList<IBreakpoints.IBreakpointsTargetDMContext>(this.fTargetBPs.size());
        targetBPKeys.addAll(0, this.fTargetBPs.keySet());
        for (IBreakpoints.IBreakpointsTargetDMContext dmc : targetBPKeys) {
            this.stopTrackingBreakpoints(dmc, (RequestMonitor)countingRm);
        }
        countingRm.setDoneCount(targetBPKeys.size());
    }

    protected BundleContext getBundleContext() {
        return MIPlugin.getBundleContext();
    }

    public void startTrackingBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext dmc, final RequestMonitor rm) {
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, INVALID_CONTEXT, null));
            rm.done();
            return;
        }
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.get(dmc);
        Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fBreakpointIDs.get(dmc);
        Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> targetIDs = this.fTargetBPs.get(dmc);
        Map<ICBreakpoint, Set<String>> threadIDs = this.fBreakpointThreads.get(dmc);
        if (platformBPs != null || breakpointIDs != null || targetIDs != null || threadIDs != null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, CONTEXT_ALREADY_INITIALIZED, null));
            rm.done();
            return;
        }
        this.fPlatformBPs.put(dmc, new HashMap());
        this.fBreakpointIDs.put(dmc, new HashMap());
        this.fTargetBPs.put(dmc, new HashMap());
        this.fBreakpointThreads.put(dmc, new HashMap());
        new Job("DSF BreakpointsManager: Install initial breakpoints on target"){

            protected IStatus run(IProgressMonitor monitor) {
                MIBreakpointsManager.this.getExecutor().submit(new Runnable(){

                    public void run() {
                        MIBreakpointsManager.this.installInitialBreakpoints(dmc, rm);
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void installInitialBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext dmc, RequestMonitor rm) {
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, INVALID_CONTEXT, null));
            rm.done();
            return;
        }
        try {
            IBreakpoint[] breakpoints;
            for (IBreakpoint breakpoint : breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.fDebugModelId)) {
                if (!this.supportsBreakpoint(breakpoint)) continue;
                Map attributes = breakpoint.getMarker().getAttributes();
                attributes.put(ATTR_DEBUGGER_PATH, NULL_STRING);
                attributes.put(ATTR_THREAD_FILTER, this.extractThreads(dmc, (ICBreakpoint)breakpoint));
                attributes.put(ATTR_THREAD_ID, NULL_STRING);
                platformBPs.put((ICBreakpoint)breakpoint, attributes);
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, UNABLE_TO_READ_BREAKPOINT, (Throwable)e);
            rm.setStatus((IStatus)status);
            rm.done();
        }
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm);
        countingRm.setDoneCount(platformBPs.size());
        for (final ICBreakpoint breakpoint : platformBPs.keySet()) {
            final Map<String, Object> attributes = platformBPs.get(breakpoint);
            this.determineDebuggerPath(dmc, attributes, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm){

                protected void handleSuccess() {
                    MIBreakpointsManager.this.installBreakpoint(dmc, breakpoint, attributes, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm));
                }
            });
        }
    }

    public void stopTrackingBreakpoints(final IBreakpoints.IBreakpointsTargetDMContext dmc, final RequestMonitor rm) {
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, INVALID_CONTEXT, null));
            rm.done();
            return;
        }
        Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.get(dmc);
        if (platformBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, INVALID_CONTEXT, null));
            rm.done();
            return;
        }
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                MIBreakpointsManager.this.fPlatformBPs.remove(dmc);
                MIBreakpointsManager.this.fBreakpointIDs.remove(dmc);
                MIBreakpointsManager.this.fTargetBPs.remove(dmc);
                MIBreakpointsManager.this.fBreakpointThreads.remove(dmc);
                rm.done();
            }
        };
        countingRm.setDoneCount(platformBPs.size());
        for (ICBreakpoint breakpoint : platformBPs.keySet()) {
            this.uninstallBreakpoint(dmc, breakpoint, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)countingRm){

                protected void handleCompleted() {
                    countingRm.done();
                }
            });
        }
    }

    private void installBreakpoint(IBreakpoints.IBreakpointsTargetDMContext dmc, final ICBreakpoint breakpoint, final Map<String, Object> attributes, final RequestMonitor rm) {
        String debuggerPath;
        final Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.get(dmc);
        assert (platformBPs != null);
        final Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fBreakpointIDs.get(dmc);
        assert (breakpointIDs != null);
        final Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> targetBPs = this.fTargetBPs.get(dmc);
        assert (targetBPs != null);
        final Map<ICBreakpoint, Set<String>> threadsIDs = this.fBreakpointThreads.get(dmc);
        assert (threadsIDs != null);
        if (breakpointIDs.containsKey(breakpoint) || targetBPs.containsValue(breakpoint)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, BREAKPOINT_ALREADY_INSTALLED, null));
            rm.done();
            return;
        }
        if (breakpoint instanceof ICLineBreakpoint && !(breakpoint instanceof ICAddressBreakpoint) && ((debuggerPath = (String)attributes.get(ATTR_DEBUGGER_PATH)) == null || debuggerPath == NULL_STRING)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, NO_DEBUGGER_PATH, null));
            rm.done();
            return;
        }
        Set<String> threads = this.getThreads(attributes);
        final CountingRequestMonitor installRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                platformBPs.put(breakpoint, attributes);
                rm.done();
            }
        };
        installRM.setDoneCount(threads.size());
        for (final String thread : threads) {
            DataRequestMonitor<IBreakpoints.IBreakpointDMContext> drm = new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), (RequestMonitor)installRM){

                protected void handleSuccess() {
                    Vector<IBreakpoints.IBreakpointDMContext> list = (Vector<IBreakpoints.IBreakpointDMContext>)breakpointIDs.get(breakpoint);
                    if (list == null) {
                        list = new Vector<IBreakpoints.IBreakpointDMContext>();
                    }
                    IBreakpoints.IBreakpointDMContext targetBP = (IBreakpoints.IBreakpointDMContext)this.getData();
                    list.add(targetBP);
                    breakpointIDs.put(breakpoint, list);
                    targetBPs.put(targetBP, breakpoint);
                    HashSet<String> thrds = (HashSet<String>)threadsIDs.get(breakpoint);
                    if (thrds == null) {
                        thrds = new HashSet<String>();
                    }
                    thrds.add(thread);
                    threadsIDs.put(breakpoint, thrds);
                    attributes.remove(MIBreakpointsManager.ATTR_THREAD_ID);
                    try {
                        breakpoint.incrementInstallCount();
                    }
                    catch (CoreException e) {
                        // empty catch block
                    }
                    installRM.done();
                }

                protected void handleError() {
                    MIBreakpointsManager.this.addBreakpointProblemMarker(breakpoint, "Breakpoint attribute problem: installation failed", 1);
                    installRM.done();
                }
            };
            attributes.put(ATTR_THREAD_ID, thread);
            Map<String, Object> targetAttributes = this.convertToTargetBreakpoint(breakpoint, attributes);
            this.fBreakpoints.insertBreakpoint(dmc, targetAttributes, (DataRequestMonitor)drm);
        }
    }

    private void addBreakpointProblemMarker(final ICBreakpoint breakpoint, final String description, final int severity) {
        new Job("Add Breakpoint Problem Marker"){

            protected IStatus run(IProgressMonitor monitor) {
                if (breakpoint instanceof ICLineBreakpoint) {
                    ICLineBreakpoint lineBreakpoint = (ICLineBreakpoint)breakpoint;
                    try {
                        IMarker breakpoint_marker = lineBreakpoint.getMarker();
                        IResource resource = breakpoint_marker.getResource();
                        IMarker problem_marker = resource.createMarker("org.eclipse.cdt.debug.core.breakpointproblem");
                        int line_number = lineBreakpoint.getLineNumber();
                        problem_marker.setAttribute("location", (Object)String.valueOf(line_number));
                        problem_marker.setAttribute("message", (Object)description);
                        problem_marker.setAttribute("severity", severity);
                        problem_marker.setAttribute("lineNumber", line_number);
                        MIBreakpointsManager.this.fBreakpointMarkerProblems.put(breakpoint, problem_marker);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void removeBreakpointProblemMarker(final ICBreakpoint breakpoint) {
        new Job("Remove Breakpoint Problem Marker"){

            protected IStatus run(IProgressMonitor monitor) {
                IMarker marker = (IMarker)MIBreakpointsManager.this.fBreakpointMarkerProblems.remove(breakpoint);
                if (marker != null) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void uninstallBreakpoint(IBreakpoints.IBreakpointsTargetDMContext dmc, final ICBreakpoint breakpoint, final RequestMonitor rm) {
        final Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.get(dmc);
        assert (platformBPs != null);
        final Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fBreakpointIDs.get(dmc);
        assert (breakpointIDs != null);
        final Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> targetBPs = this.fTargetBPs.get(dmc);
        assert (targetBPs != null);
        final Map<ICBreakpoint, Set<String>> threadsIDs = this.fBreakpointThreads.get(dmc);
        assert (threadsIDs != null);
        this.removeBreakpointProblemMarker(breakpoint);
        if (!(platformBPs.containsKey(breakpoint) && breakpointIDs.containsKey(breakpoint) && targetBPs.containsValue(breakpoint))) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, BREAKPOINT_ALREADY_REMOVED, null));
            rm.done();
            return;
        }
        CountingRequestMonitor removeRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                platformBPs.remove(breakpoint);
                threadsIDs.remove(breakpoint);
                Vector contexts = (Vector)breakpointIDs.get(breakpoint);
                if (contexts != null) {
                    for (IBreakpoints.IBreakpointDMContext context : contexts) {
                        targetBPs.remove(context);
                    }
                }
                ((Vector)breakpointIDs.get(breakpoint)).clear();
                breakpointIDs.remove(breakpoint);
                MIBreakpointsManager.this.fPendingRequests.remove(breakpoint);
                rm.done();
            }
        };
        Vector<IBreakpoints.IBreakpointDMContext> list = breakpointIDs.get(breakpoint);
        int count = 0;
        if (list != null) {
            for (IBreakpoints.IBreakpointDMContext bp : list) {
                this.fBreakpoints.removeBreakpoint(bp, (RequestMonitor)removeRM);
                try {
                    breakpoint.decrementInstallCount();
                }
                catch (CoreException e) {}
            }
            count = list.size();
        }
        removeRM.setDoneCount(count);
    }

    private void modifyBreakpoint(final IBreakpoints.IBreakpointsTargetDMContext dmc, final ICBreakpoint breakpoint, final Map<String, Object> attributes, final IMarkerDelta oldValues, final RequestMonitor rm) {
        final Map<ICBreakpoint, Map<String, Object>> platformBPs = this.fPlatformBPs.get(dmc);
        assert (platformBPs != null);
        Map<ICBreakpoint, Vector<IBreakpoints.IBreakpointDMContext>> breakpointIDs = this.fBreakpointIDs.get(dmc);
        assert (breakpointIDs != null);
        Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> targetBPs = this.fTargetBPs.get(dmc);
        assert (targetBPs != null);
        final Map<ICBreakpoint, Set<String>> threadsIDs = this.fBreakpointThreads.get(dmc);
        assert (threadsIDs != null);
        if (!(platformBPs.containsKey(breakpoint) && breakpointIDs.containsKey(breakpoint) && targetBPs.containsValue(breakpoint))) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10005, BREAKPOINT_NOT_INSTALLED, null));
            rm.done();
            return;
        }
        Map<String, Object> original_attributes = platformBPs.get(breakpoint);
        if (original_attributes == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, INVALID_BREAKPOINT, null));
            rm.done();
            return;
        }
        HashMap<String, Object> oldAttributes = new HashMap<String, Object>(original_attributes);
        oldAttributes.put(ATTR_THREAD_FILTER, threadsIDs.get(breakpoint));
        final Set<String> newThreads = this.extractThreads(dmc, breakpoint);
        HashMap<String, Object> newAttributes = new HashMap<String, Object>(attributes);
        newAttributes.put(ATTR_THREAD_FILTER, newThreads);
        final Map<String, Object> attributesDelta = this.determineAttributesDelta(oldAttributes, newAttributes);
        final Vector oldTargetBPs = new Vector(breakpointIDs.get(breakpoint));
        if (oldTargetBPs == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, INVALID_BREAKPOINT, null));
            rm.done();
            return;
        }
        final CountingRequestMonitor updateRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                platformBPs.put(breakpoint, attributes);
                rm.done();
            }

            protected void handleError() {
                MIBreakpointsManager.this.rollbackAttributes(breakpoint, oldValues);
                platformBPs.put(breakpoint, attributes);
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, MIBreakpointsManager.INVALID_PARAMETER, null));
                rm.done();
            }
        };
        final Vector newTargetBPs = new Vector();
        final CountingRequestMonitor removeRM = new CountingRequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                Map breakpointIDs = (Map)MIBreakpointsManager.this.fBreakpointIDs.get(dmc);
                if (breakpointIDs == null) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, MIBreakpointsManager.INVALID_BREAKPOINT, null));
                    rm.done();
                    return;
                }
                breakpointIDs.put(breakpoint, newTargetBPs);
                for (IBreakpoints.IBreakpointDMContext ref : newTargetBPs) {
                    MIBreakpointsManager.this.fBreakpoints.updateBreakpoint(ref, attributesDelta, (RequestMonitor)updateRM);
                }
                updateRM.setDoneCount(newTargetBPs.size());
            }
        };
        DataRequestMonitor<Vector<IBreakpoints.IBreakpointDMContext>> insertRM = new DataRequestMonitor<Vector<IBreakpoints.IBreakpointDMContext>>((Executor)this.getExecutor(), null){

            protected void handleSuccess() {
                newTargetBPs.addAll((Collection)this.getData());
                threadsIDs.put(breakpoint, newThreads);
                for (IBreakpoints.IBreakpointDMContext ref : oldTargetBPs) {
                    MIBreakpointsManager.this.fBreakpoints.removeBreakpoint(ref, (RequestMonitor)removeRM);
                    try {
                        breakpoint.decrementInstallCount();
                    }
                    catch (CoreException coreException) {}
                }
                removeRM.setDoneCount(oldTargetBPs.size());
            }

            protected void handleError() {
                updateRM.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, MIBreakpointsManager.INVALID_PARAMETER, null));
                updateRM.setDoneCount(0);
            }
        };
        if (this.needsResinstallation(attributesDelta)) {
            this.reinstallBreakpoint(dmc, breakpoint, attributes, newThreads, insertRM);
        } else {
            for (IBreakpoints.IBreakpointDMContext ref : oldTargetBPs) {
                this.fBreakpoints.updateBreakpoint(ref, attributesDelta, (RequestMonitor)updateRM);
            }
            updateRM.setDoneCount(oldTargetBPs.size());
        }
    }

    private void reinstallBreakpoint(IBreakpoints.IBreakpointsTargetDMContext context, final ICBreakpoint breakpoint, Map<String, Object> attributes, Set<String> threads, DataRequestMonitor<Vector<IBreakpoints.IBreakpointDMContext>> drm) {
        final Vector breakpointList = new Vector();
        final CountingRequestMonitor installRM = new CountingRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)drm, (DataRequestMonitor)drm, breakpointList){
            final /* synthetic */ DataRequestMonitor val$drm;
            final /* synthetic */ Vector val$breakpointList;
            {
                this.val$drm = dataRequestMonitor;
                this.val$breakpointList = vector;
                super(x0, x1);
            }

            protected void handleSuccess() {
                this.val$drm.setData((Object)this.val$breakpointList);
                this.val$drm.done();
            }
        };
        installRM.setDoneCount(threads.size());
        for (String thread : threads) {
            Map<String, Object> attrs = this.convertToTargetBreakpoint(breakpoint, attributes);
            if (!this.fBreakpointManager.isEnabled()) {
                attrs.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", false);
            }
            attrs.put("org.eclipse.dd.dsf.debug.breakpoint.mi.threadId", thread);
            this.fBreakpoints.insertBreakpoint(context, attrs, (DataRequestMonitor)new DataRequestMonitor<IBreakpoints.IBreakpointDMContext>((Executor)this.getExecutor(), (RequestMonitor)installRM){

                protected void handleSuccess() {
                    breakpointList.add(this.getData());
                    try {
                        breakpoint.incrementInstallCount();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    installRM.done();
                }

                protected void handleError() {
                    installRM.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, MIBreakpointsManager.INVALID_PARAMETER, null));
                    installRM.done();
                }
            });
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        for (IBreakpoints.IBreakpointsTargetDMContext context : this.fBreakpointIDs.keySet()) {
            for (ICBreakpoint breakpoint : this.fBreakpointIDs.get(context).keySet()) {
                try {
                    if (!breakpoint.isEnabled()) continue;
                    for (IBreakpoints.IBreakpointDMContext ref : this.fBreakpointIDs.get(context).get(breakpoint)) {
                        HashMap<String, Boolean> delta = new HashMap<String, Boolean>();
                        delta.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", enabled);
                        this.fBreakpoints.updateBreakpoint(ref, delta, new RequestMonitor((Executor)this.getExecutor(), null));
                    }
                }
                catch (CoreException e) {
                }
            }
        }
    }

    @ThreadSafe
    public void breakpointAdded(final IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                final Map attrs = breakpoint.getMarker().getAttributes();
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), null){

                            protected void handleError() {
                                if (this.getStatus().getSeverity() == 4) {
                                    MIPlugin.getDefault().getLog().log(this.getStatus());
                                }
                            }
                        };
                        countingRm.setDoneCount(MIBreakpointsManager.this.fPlatformBPs.size());
                        for (final IBreakpoints.IBreakpointsTargetDMContext dmc : MIBreakpointsManager.this.fPlatformBPs.keySet()) {
                            MIBreakpointsManager.this.determineDebuggerPath(dmc, attrs, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm){

                                protected void handleSuccess() {
                                    MIBreakpointsManager.this.installBreakpoint(dmc, (ICBreakpoint)breakpoint, attrs, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm));
                                }
                            });
                        }
                    }
                });
            }
            catch (CoreException e) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private IDsfBreakpointExtension getFilterExtension(ICBreakpoint bp) throws CoreException {
        return (IDsfBreakpointExtension)bp.getExtension(GDB_DEBUG_MODEL_ID, ICBreakpointExtension.class);
    }

    public void breakpointChanged(final IBreakpoint breakpoint, final IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                final Map attrs = breakpoint.getMarker().getAttributes();
                if (!this.fBreakpointManager.isEnabled()) {
                    attrs.put("org.eclipse.debug.core.enabled", false);
                }
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        if (MIBreakpointsManager.this.fPendingRequests.contains(breakpoint)) {
                            MIBreakpointsManager.this.fPendingBreakpoints.add(breakpoint);
                            return;
                        }
                        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), null){

                            protected void handleCompleted() {
                                if (!this.isSuccess() && this.getStatus().getSeverity() == 4) {
                                    MIPlugin.getDefault().getLog().log(this.getStatus());
                                }
                                MIBreakpointsManager.this.fPendingRequests.remove(breakpoint);
                                if (MIBreakpointsManager.this.fPendingBreakpoints.contains(breakpoint)) {
                                    MIBreakpointsManager.this.fPendingBreakpoints.remove(breakpoint);
                                    MIBreakpointsManager.this.breakpointChanged(breakpoint, delta);
                                }
                            }
                        };
                        countingRm.setDoneCount(MIBreakpointsManager.this.fPlatformBPs.size());
                        MIBreakpointsManager.this.fPendingRequests.add(breakpoint);
                        for (final IBreakpoints.IBreakpointsTargetDMContext dmc : MIBreakpointsManager.this.fPlatformBPs.keySet()) {
                            MIBreakpointsManager.this.determineDebuggerPath(dmc, attrs, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm){

                                protected void handleSuccess() {
                                    MIBreakpointsManager.this.modifyBreakpoint(dmc, (ICBreakpoint)breakpoint, attrs, delta, new RequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), (RequestMonitor)countingRm));
                                }
                            });
                        }
                    }
                });
            }
            catch (CoreException e) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    public void breakpointRemoved(final IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIBreakpointsManager.this.getExecutor(), null){

                            protected void handleError() {
                                if (this.getStatus().getSeverity() == 4) {
                                    MIPlugin.getDefault().getLog().log(this.getStatus());
                                }
                            }
                        };
                        countingRm.setDoneCount(MIBreakpointsManager.this.fPlatformBPs.size());
                        for (IBreakpoints.IBreakpointsTargetDMContext dmc : MIBreakpointsManager.this.fPlatformBPs.keySet()) {
                            if (!((Map)MIBreakpointsManager.this.fPlatformBPs.get(dmc)).containsKey(breakpoint)) continue;
                            MIBreakpointsManager.this.uninstallBreakpoint(dmc, (ICBreakpoint)breakpoint, (RequestMonitor)countingRm);
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIBreakpoints.BreakpointAddedEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIBreakpoints.BreakpointUpdatedEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIBreakpoints.BreakpointRemovedEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIWatchpointScopeEvent e) {
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIBreakpointHitEvent e) {
        this.performBreakpointAction(e.getNumber());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIWatchpointTriggerEvent e) {
        this.performBreakpointAction(e.getNumber());
    }

    private void performBreakpointAction(int number) {
        final ICBreakpoint breakpoint = this.findPlatformBreakpoint(number);
        Object[] contexts = this.fTargetBPs.keySet().toArray();
        final IBreakpoints.IBreakpointsTargetDMContext context = (IBreakpoints.IBreakpointsTargetDMContext)contexts[0];
        new Job("Breakpoint action"){
            {
                super(x0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor monitor) {
                MIBreakpointsManager.this.fBreakpointActionManager.executeActions((IBreakpoint)breakpoint, (IAdaptable)new BreakpointActionAdapter(MIBreakpointsManager.this.getExecutor(), MIBreakpointsManager.this.getServicesTracker(), (IDMContext)context));
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private ICBreakpoint findPlatformBreakpoint(int targetBreakpointID) {
        Set<IBreakpoints.IBreakpointsTargetDMContext> targets = this.fTargetBPs.keySet();
        for (IBreakpoints.IBreakpointsTargetDMContext target : targets) {
            Map<IBreakpoints.IBreakpointDMContext, ICBreakpoint> bps = this.fTargetBPs.get(target);
            Set<IBreakpoints.IBreakpointDMContext> contexts = bps.keySet();
            for (IBreakpoints.IBreakpointDMContext context : contexts) {
                MIBreakpoints.MIBreakpointDMContext ctx;
                if (!(context instanceof MIBreakpoints.MIBreakpointDMContext) || (ctx = (MIBreakpoints.MIBreakpointDMContext)context).getReference() != targetBreakpointID) continue;
                return bps.get(context);
            }
        }
        return null;
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIGDBExitEvent e) {
        this.terminated();
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
    }

    private void terminated() {
        this.clearBreakpointStatus(this.fPlatformBPs.keySet().toArray(new ICBreakpoint[this.fPlatformBPs.size()]));
        this.fPlatformBPs.clear();
    }

    private void clearBreakpointStatus(final ICBreakpoint[] bps) {
        new Job("Clear Breakpoints Status"){

            protected IStatus run(IProgressMonitor monitor) {
                IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        for (ICBreakpoint breakpoint : bps) {
                            breakpoint.resetInstallCount();
                        }
                    }
                };
                ISchedulingRule rule = null;
                ArrayList<ISchedulingRule> markerRules = new ArrayList<ISchedulingRule>();
                for (ICBreakpoint bp : bps) {
                    IMarker marker = bp.getMarker();
                    if (marker == null) continue;
                    ISchedulingRule markerRule = ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(marker.getResource());
                    if (markerRule == null) {
                        markerRules = null;
                        break;
                    }
                    markerRules.add(markerRule);
                }
                if (markerRules != null) {
                    rule = MultiRule.combine((ISchedulingRule[])markerRules.toArray(new ISchedulingRule[markerRules.size()]));
                }
                try {
                    ResourcesPlugin.getWorkspace().run(wr, rule, 0, null);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private boolean supportsBreakpoint(IBreakpoint bp) {
        IMarker marker;
        return bp instanceof ICBreakpoint && bp.getModelIdentifier().equals(this.fDebugModelId) && (marker = bp.getMarker()) != null;
    }

    private void determineDebuggerPath(IBreakpoints.IBreakpointsTargetDMContext dmc, final Map<String, Object> attributes, final RequestMonitor rm) {
        String hostPath = (String)attributes.get("org.eclipse.cdt.debug.core.sourceHandle");
        if (hostPath != null) {
            ISourceLookup.ISourceLookupDMContext srcDmc = (ISourceLookup.ISourceLookupDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, ISourceLookup.ISourceLookupDMContext.class);
            if (srcDmc != null) {
                this.fSourceLookup.getDebuggerPath(srcDmc, (Object)hostPath, (DataRequestMonitor)new DataRequestMonitor<String>((Executor)this.getExecutor(), rm){

                    protected void handleSuccess() {
                        attributes.put(MIBreakpointsManager.ATTR_DEBUGGER_PATH, MIBreakpointsManager.this.adjustDebuggerPath((String)this.getData()));
                        rm.done();
                    }
                });
            } else {
                attributes.put(ATTR_DEBUGGER_PATH, this.adjustDebuggerPath(hostPath));
                rm.done();
            }
        } else {
            rm.done();
        }
    }

    private String adjustDebuggerPath(String path) {
        String result = path;
        if (Platform.getOS().startsWith("win") && !path.startsWith("/")) {
            result = path.substring(path.lastIndexOf(92) + 1);
        }
        return result;
    }

    private Map<String, Object> determineAttributesDelta(Map<String, Object> oldAttributes, Map<String, Object> newAttributes) {
        HashMap<String, Object> delta = new HashMap<String, Object>();
        Set<String> oldKeySet = oldAttributes.keySet();
        Set<String> newKeySet = newAttributes.keySet();
        HashSet<String> commonKeys = new HashSet<String>(newKeySet);
        commonKeys.retainAll(oldKeySet);
        HashSet<String> addedKeys = new HashSet<String>(newKeySet);
        addedKeys.removeAll(oldKeySet);
        HashSet<String> removedKeys = new HashSet<String>(oldKeySet);
        removedKeys.removeAll(newKeySet);
        for (String key : commonKeys) {
            if (oldAttributes.get(key).equals(newAttributes.get(key))) continue;
            delta.put(key, newAttributes.get(key));
        }
        for (String key : addedKeys) {
            delta.put(key, newAttributes.get(key));
        }
        for (String key : removedKeys) {
            delta.put(key, null);
        }
        return this.convertedAttributes(delta);
    }

    private Map<String, Object> convertedAttributes(Map<String, Object> cdt_attributes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (cdt_attributes.containsKey(ATTR_DEBUGGER_PATH)) {
            result.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", cdt_attributes.get(ATTR_DEBUGGER_PATH));
        }
        if (cdt_attributes.containsKey("lineNumber")) {
            result.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", cdt_attributes.get("lineNumber"));
        }
        if (cdt_attributes.containsKey("org.eclipse.cdt.debug.core.function")) {
            result.put("org.eclipse.dd.dsf.debug.breakpoint.function", cdt_attributes.get("org.eclipse.cdt.debug.core.function"));
        }
        if (cdt_attributes.containsKey("org.eclipse.cdt.debug.core.address")) {
            result.put("org.eclipse.dd.dsf.debug.breakpoint.address", cdt_attributes.get("org.eclipse.cdt.debug.core.address"));
        }
        if (cdt_attributes.containsKey("org.eclipse.cdt.debug.core.condition")) {
            result.put("org.eclipse.dd.dsf.debug.breakpoint.condition", cdt_attributes.get("org.eclipse.cdt.debug.core.condition"));
        }
        if (cdt_attributes.containsKey("org.eclipse.cdt.debug.core.ignoreCount")) {
            result.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", cdt_attributes.get("org.eclipse.cdt.debug.core.ignoreCount"));
        }
        if (cdt_attributes.containsKey("org.eclipse.debug.core.enabled")) {
            result.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", cdt_attributes.get("org.eclipse.debug.core.enabled"));
        }
        if (cdt_attributes.containsKey("org.eclipse.cdt.debug.core.expression")) {
            result.put("org.eclipse.dd.dsf.debug.breakpoint.expression", cdt_attributes.get("org.eclipse.cdt.debug.core.expression"));
        }
        if (cdt_attributes.containsKey("org.eclipse.cdt.debug.core.read")) {
            result.put("org.eclipse.dd.dsf.debug.breakpoint.read", cdt_attributes.get("org.eclipse.cdt.debug.core.read"));
        }
        if (cdt_attributes.containsKey("org.eclipse.cdt.debug.core.write")) {
            result.put("org.eclipse.dd.dsf.debug.breakpoint.write", cdt_attributes.get("org.eclipse.cdt.debug.core.write"));
        }
        if (cdt_attributes.containsKey(ATTR_THREAD_FILTER)) {
            result.put(ATTR_THREAD_FILTER, cdt_attributes.get(ATTR_THREAD_FILTER));
        }
        return result;
    }

    private Set<String> getThreads(Map<String, Object> attributes) {
        HashSet<String> threads = (HashSet<String>)attributes.get(ATTR_THREAD_FILTER);
        if (threads == null) {
            threads = new HashSet<String>();
            threads.add("0");
        }
        return threads;
    }

    private Set<String> extractThreads(IBreakpoints.IBreakpointsTargetDMContext context, ICBreakpoint breakpoint) {
        HashSet<String> results = new HashSet<String>();
        ArrayList<IRunControl.IExecutionDMContext[]> threads = new ArrayList<IRunControl.IExecutionDMContext[]>(1);
        try {
            IDsfBreakpointExtension filterExtension = this.getFilterExtension(breakpoint);
            IRunControl.IContainerDMContext[] targets = filterExtension.getTargetFilters();
            if (targets.length == 0) {
                results.add("0");
                return results;
            }
            for (IRunControl.IContainerDMContext iContainerDMContext : targets) {
                if (!DMContexts.isAncestorOf((IDMContext)iContainerDMContext, (IDMContext)context)) continue;
                threads.add(filterExtension.getThreadFilters(iContainerDMContext));
            }
        }
        catch (CoreException e1) {
            // empty catch block
        }
        if (this.supportsThreads(breakpoint)) {
            for (IRunControl.IExecutionDMContext[] targetThreads : threads) {
                if (targetThreads != null) {
                    for (IRunControl.IContainerDMContext iContainerDMContext : targetThreads) {
                        if (!(iContainerDMContext instanceof IMIExecutionDMContext)) continue;
                        IMIExecutionDMContext dmc = (IMIExecutionDMContext)iContainerDMContext;
                        results.add(Integer.valueOf(dmc.getThreadId()).toString());
                    }
                    continue;
                }
                results.add("0");
                break;
            }
        } else {
            results.add("0");
        }
        return results;
    }

    protected Map<String, Object> convertToTargetBreakpoint(ICBreakpoint breakpoint, Map<String, Object> attributes) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (breakpoint instanceof ICWatchpoint) {
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.type", "watchpoint");
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.expression", attributes.get("org.eclipse.cdt.debug.core.expression"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.read", attributes.get("org.eclipse.cdt.debug.core.read"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.write", attributes.get("org.eclipse.cdt.debug.core.write"));
        } else if (breakpoint instanceof ICLineBreakpoint) {
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.type", "breakpoint");
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.fileName", attributes.get(ATTR_DEBUGGER_PATH));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.lineNumber", attributes.get("lineNumber"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.function", attributes.get("org.eclipse.cdt.debug.core.function"));
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.address", attributes.get("org.eclipse.cdt.debug.core.address"));
        }
        properties.put("org.eclipse.dd.dsf.debug.breakpoint.condition", attributes.get("org.eclipse.cdt.debug.core.condition"));
        properties.put("org.eclipse.dd.dsf.debug.breakpoint.ignoreCount", attributes.get("org.eclipse.cdt.debug.core.ignoreCount"));
        properties.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", attributes.get("org.eclipse.debug.core.enabled"));
        properties.put("org.eclipse.dd.dsf.debug.breakpoint.mi.threadId", attributes.get(ATTR_THREAD_ID));
        if (!this.fBreakpointManager.isEnabled()) {
            properties.put("org.eclipse.dd.dsf.debug.breakpoint.isEnabled", false);
        }
        return properties;
    }

    protected boolean needsResinstallation(Map<String, Object> delta) {
        if (delta == null) {
            return false;
        }
        return delta.containsKey(ATTR_DEBUGGER_PATH) || delta.containsKey("lineNumber") || delta.containsKey("org.eclipse.cdt.debug.core.function") || delta.containsKey("org.eclipse.cdt.debug.core.address") || delta.containsKey(ATTR_THREAD_FILTER) || delta.containsKey("org.eclipse.cdt.debug.core.expression") || delta.containsKey("org.eclipse.cdt.debug.core.read") || delta.containsKey("org.eclipse.cdt.debug.core.write");
    }

    protected void rollbackAttributes(ICBreakpoint breakpoint, IMarkerDelta oldValues) {
        try {
            String old_condition;
            String new_condition = breakpoint.getCondition();
            if (new_condition == null) {
                new_condition = NULL_STRING;
            }
            String string = old_condition = oldValues != null ? oldValues.getAttribute("org.eclipse.cdt.debug.core.condition", NULL_STRING) : NULL_STRING;
            if (!old_condition.equals(new_condition)) {
                breakpoint.setCondition(old_condition);
            } else {
                breakpoint.setCondition(NULL_STRING);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected boolean supportsThreads(ICBreakpoint breakpoint) {
        return !(breakpoint instanceof ICWatchpoint);
    }
}

