/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.mi.service.command.MIControlDMContext;
import org.eclipse.dd.mi.service.command.commands.Adjustable;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MICommand<V extends MIInfo>
implements ICommand<V> {
    static final String[] empty = new String[0];
    List<Adjustable> fOptions = new ArrayList<Adjustable>();
    List<Adjustable> fParameters = new ArrayList<Adjustable>();
    String fOperation = new String();
    IDMContext fCtx;

    public MICommand(IDMContext ctx, String operation) {
        this(ctx, operation, empty, empty);
    }

    public MICommand(IDMContext ctx, String operation, String[] options) {
        this(ctx, operation, options, empty);
    }

    public MICommand(IDMContext ctx, String operation, String[] options, String[] params) {
        assert (ctx != null && DMContexts.getAncestorOfType((IDMContext)ctx, MIControlDMContext.class) != null);
        this.fCtx = ctx;
        this.fOperation = operation;
        this.fOptions = this.optionsToAdjustables(options);
        this.fParameters = this.parametersToAdjustables(params);
    }

    private final List<Adjustable> optionsToAdjustables(String[] options) {
        ArrayList<Adjustable> result = new ArrayList<Adjustable>();
        if (options != null) {
            for (String option : options) {
                result.add(new MIStandardOptionAdjustable(option));
            }
        }
        return result;
    }

    private final List<Adjustable> parametersToAdjustables(String[] parameters) {
        ArrayList<Adjustable> result = new ArrayList<Adjustable>();
        if (parameters != null) {
            for (String parameter : parameters) {
                result.add(new MIStandardParameterAdjustable(parameter));
            }
        }
        return result;
    }

    public String getCommandControlFilter() {
        MIControlDMContext controlDmc = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContext(), MIControlDMContext.class);
        return controlDmc.getCommandControlFilter();
    }

    public String getOperation() {
        return this.fOperation;
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        for (Adjustable option : this.fOptions) {
            result.add(option.getValue());
        }
        return result.toArray(new String[this.fOptions.size()]);
    }

    public void setOptions(String[] options) {
        this.fOptions = this.optionsToAdjustables(options);
    }

    public String[] getParameters() {
        ArrayList<String> result = new ArrayList<String>();
        for (Adjustable parameter : this.fParameters) {
            result.add(parameter.getValue());
        }
        return result.toArray(new String[this.fParameters.size()]);
    }

    public void setParameters(String[] params) {
        this.fParameters = this.parametersToAdjustables(params);
    }

    public void setParameters(Adjustable ... params) {
        this.fParameters = Arrays.asList(params);
    }

    public String constructCommand() {
        return this.constructCommand(null, -1);
    }

    public String constructCommand(String threadId, int frameId) {
        String p;
        String opt;
        StringBuffer command = new StringBuffer(this.getOperation());
        if (threadId != null) {
            command.append(" --thread " + threadId);
            if (frameId >= 0) {
                command.append(" --frame " + frameId);
            }
        }
        if ((opt = this.optionsToString()).length() > 0) {
            command.append(' ').append(opt);
        }
        if ((p = this.parametersToString()).length() > 0) {
            command.append(' ').append(p);
        }
        command.append('\n');
        return command.toString();
    }

    public ICommand<? extends ICommandResult> coalesceWith(ICommand<? extends ICommandResult> command) {
        return null;
    }

    public IDMContext getContext() {
        return this.fCtx;
    }

    public MIInfo getResult(MIOutput MIresult) {
        return new MIInfo(MIresult);
    }

    protected String optionsToString() {
        StringBuffer sb = new StringBuffer();
        if (this.fOptions != null && this.fOptions.size() > 0) {
            for (Adjustable option : this.fOptions) {
                sb.append(option.getAdjustedValue());
            }
        }
        return sb.toString().trim();
    }

    protected String parametersToString() {
        String[] options = this.getOptions();
        StringBuffer buffer = new StringBuffer();
        if (this.fParameters != null && this.fParameters.size() > 0) {
            if (options != null && options.length > 0) {
                for (Adjustable parameter : this.fParameters) {
                    if (!parameter.getValue().startsWith("-")) continue;
                    buffer.append('-').append('-');
                    break;
                }
            }
            for (Adjustable parameter : this.fParameters) {
                buffer.append(' ').append(parameter.getAdjustedValue());
            }
        }
        return buffer.toString().trim();
    }

    protected static boolean containsWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean supportsThreadAndFrameOptions() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MICommand) {
            MICommand otherCmd = (MICommand)obj;
            return (this.fCtx == null && otherCmd.fCtx == null || this.fCtx != null && this.fCtx.equals(otherCmd.fCtx)) && this.constructCommand().equals(otherCmd.constructCommand());
        }
        return false;
    }

    public int hashCode() {
        return this.constructCommand().hashCode();
    }

    public String toString() {
        return this.constructCommand();
    }

    public static abstract class MICommandAdjustable
    implements Adjustable {
        protected final String value;

        public MICommandAdjustable(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class MIStandardOptionAdjustable
    extends MICommandAdjustable {
        public MIStandardOptionAdjustable(String option) {
            super(option);
        }

        public String getAdjustedValue() {
            StringBuilder builder = new StringBuilder();
            String option = this.value;
            if (option.indexOf(34) != -1 || option.indexOf(92) != -1) {
                StringBuilder buf = new StringBuilder();
                for (int j = 0; j < option.length(); ++j) {
                    char c = option.charAt(j);
                    if (c == '\"' || c == '\\') {
                        buf.append('\\');
                    }
                    buf.append(c);
                }
                option = buf.toString();
            }
            if (option.indexOf(9) != -1 || option.indexOf(32) != -1) {
                builder.append(' ').append('\"').append(option).append('\"');
            } else {
                builder.append(' ').append(option);
            }
            return builder.toString();
        }
    }

    public static class MIStandardParameterAdjustable
    extends MICommandAdjustable {
        public MIStandardParameterAdjustable(String parameter) {
            super(parameter);
        }

        public String getAdjustedValue() {
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < this.value.length(); ++j) {
                char c = this.value.charAt(j);
                if (c == '\"' || c == '\\') {
                    builder.append('\\');
                }
                builder.append(c);
            }
            if (MICommand.containsWhitespace(this.value)) {
                builder.insert(0, '\"');
                builder.append('\"');
            }
            return builder.toString();
        }
    }
}

