/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIConst
extends MIValue {
    String cstring = "";

    public String getCString() {
        return this.cstring;
    }

    public void setCString(String str) {
        this.cstring = str;
    }

    public String getString() {
        return MIConst.getString(this.cstring);
    }

    public static String getString(String str) {
        StringBuffer buffer = new StringBuffer();
        boolean escape = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                if (escape) {
                    buffer.append(c);
                    escape = false;
                    continue;
                }
                escape = true;
                continue;
            }
            if (escape) {
                if (MIConst.isIsoCSpecialChar(c)) {
                    buffer.append(MIConst.isoC(c));
                } else {
                    buffer.append('\\');
                    buffer.append(c);
                }
            } else {
                buffer.append(c);
            }
            escape = false;
        }
        if (escape) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    public String toString() {
        return this.getCString();
    }

    private static String isoC(char c) {
        String s = new Character(c).toString();
        if (c == '\"') {
            s = "\"";
        } else if (c == '\'') {
            s = "'";
        } else if (c == '?') {
            s = "?";
        } else if (c == 'a') {
            s = "\u0007";
        } else if (c == 'b') {
            s = "\b";
        } else if (c == 'f') {
            s = "\f";
        } else if (c == 'n') {
            s = System.getProperty("line.separator", "\n");
        } else if (c == 'r') {
            s = "\r";
        } else if (c == 't') {
            s = "\t";
        } else if (c == 'v') {
            s = "\u000b";
        }
        return s;
    }

    private static boolean isIsoCSpecialChar(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '?': 
            case 'a': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'v': {
                return true;
            }
        }
        return false;
    }
}

