/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.DocumentChecker;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.dd.ipxact.editor.core.utils.VlnvReferences;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CheckVlnv {
    public static int checkVlnv(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        Vlnv vlnv = theDoc.getVlnv();
        if (vlnv == null) {
            ++nErrors;
            checker.getReporter().report(CheckList.CHECK_1, theDoc, Messages.CheckVlnv_20);
        }
        if (checker.getLibrary().hasDuplicates(vlnv)) {
            ++nErrors;
            checker.getReporter().report(CheckList.CHECK_1, theDoc, Messages.CheckVlnv_21);
        }
        return nErrors;
    }

    public static int checkLinkTypes(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        NodeList nodes = theDoc.getDescendants("*");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !VlnvReferences.isReferenceElement((Element)((Element)node)).booleanValue()) continue;
            SpiritDocument linkedDoc = null;
            try {
                linkedDoc = checker.getLinkedDocument(SpiritDocument.createSpiritNode((Element)((Element)node)));
            }
            catch (Exception e) {
                checker.getReporter().report(CheckList.CHECK_2, theDoc, e.getMessage(), node);
                ++nErrors;
                continue;
            }
            String linkedType = linkedDoc.getRootTagName();
            String thisType = node.getLocalName();
            if (VlnvReferences.checkReferenceValid((Element)((Element)node), (SpiritDocument)linkedDoc).booleanValue()) continue;
            checker.getReporter().report(CheckList.CHECKS_3_11, theDoc, MessageFormat.format(Messages.CheckVlnv_24, thisType, linkedType, VlnvReferences.getExpectedDocumentTypes((Element)((Element)node))), node);
            ++nErrors;
        }
        return nErrors;
    }

    public static int checkFileRefs(DocumentChecker checker) {
        int nErrors = 0;
        SpiritDocument theDoc = checker.getSpiritDocument();
        NodeList nodes = theDoc.getDescendants("file");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element fileNode = (Element)nodes.item(i);
            String name = SpiritNode.createSpiritNode((Element)fileNode).getName();
            File resourceLocation = checker.getFilePathResolver().resolveFilePath(name, fileNode);
            if (resourceLocation != null) continue;
            checker.getReporter().report(CheckList.CHECK_76, theDoc, MessageFormat.format(Messages.CheckVlnv_26, name), fileNode);
            ++nErrors;
        }
        return nErrors;
    }
}

