/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.models;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.dd.ipxact.checker.core.CheckList;
import org.eclipse.dd.ipxact.checker.core.ICheckerReporter;
import org.eclipse.dd.ipxact.checker.core.Messages;
import org.eclipse.dd.ipxact.checker.core.models.CheckVisitor;
import org.eclipse.dd.ipxact.checker.core.models.HierarchicalConnection;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.ComponentSignal;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SignalMapElement;

public class Check68Visitor
extends CheckVisitor {
    public Check68Visitor(ICheckerReporter reporter) {
        super(reporter);
    }

    public boolean visit(HierarchicalConnection hierarchicalConnection) {
        String message = Messages.Check68Visitor_0;
        Map signalMapElements = hierarchicalConnection.busInterface.getSignalNames();
        Map refSignalNames = hierarchicalConnection.refBusInterface.getSignalNames();
        if (signalMapElements != null && refSignalNames != null) {
            Map<String, ComponentSignal> componentSignals = Utilities.getComponentSignals((SpiritDocument)hierarchicalConnection.busInterfaceDoc);
            Map<String, ComponentSignal> refComponentSignals = Utilities.getComponentSignals((SpiritDocument)hierarchicalConnection.refBusInterfaceDoc);
            for (SignalMapElement signalMapElement : signalMapElements.values()) {
                String refValue;
                String componentSignalName = signalMapElement.getName();
                ComponentSignal componentSignal = componentSignals.get(componentSignalName);
                ComponentSignal refComponentSignal = refComponentSignals.get(componentSignalName);
                if (componentSignal == null || refComponentSignal == null) continue;
                String value = componentSignal.getStrength();
                if (!value.equals(refValue = refComponentSignal.getStrength())) {
                    this.reporter.report(CheckList.CHECK_68, null, MessageFormat.format(message, "strength", value, componentSignal, hierarchicalConnection.busInterfaceDoc.getVlnv(), refValue, refComponentSignal, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
                    ++this.problems;
                }
                if ((value = componentSignal.getDefaultValue()).equals(refValue = refComponentSignal.getDefaultValue())) continue;
                this.reporter.report(CheckList.CHECK_68, null, MessageFormat.format(message, "defaultValue", value, componentSignal, hierarchicalConnection.busInterfaceDoc.getVlnv(), refValue, refComponentSignal, hierarchicalConnection.refBusInterfaceDoc.getVlnv()));
                ++this.problems;
            }
        }
        return true;
    }
}

