/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.service.ICachingService;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.GdbPlugin;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.dd.mi.service.MIStack;
import org.eclipse.dd.mi.service.command.commands.MIExecContinue;
import org.eclipse.dd.mi.service.command.commands.MIExecFinish;
import org.eclipse.dd.mi.service.command.commands.MIExecInterrupt;
import org.eclipse.dd.mi.service.command.commands.MIExecNext;
import org.eclipse.dd.mi.service.command.commands.MIExecNextInstruction;
import org.eclipse.dd.mi.service.command.commands.MIExecStep;
import org.eclipse.dd.mi.service.command.commands.MIExecStepInstruction;
import org.eclipse.dd.mi.service.command.commands.MIExecUntil;
import org.eclipse.dd.mi.service.command.events.IMIDMEvent;
import org.eclipse.dd.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.dd.mi.service.command.events.MIErrorEvent;
import org.eclipse.dd.mi.service.command.events.MIEvent;
import org.eclipse.dd.mi.service.command.events.MIRunningEvent;
import org.eclipse.dd.mi.service.command.events.MISharedLibEvent;
import org.eclipse.dd.mi.service.command.events.MISignalEvent;
import org.eclipse.dd.mi.service.command.events.MISteppingRangeEvent;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.events.MIThreadCreatedEvent;
import org.eclipse.dd.mi.service.command.events.MIThreadExitEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GDBRunControl_7_0_NS
extends AbstractDsfService
implements IRunControl,
ICachingService {
    private ICommandControlService fConnection;
    private boolean fTerminated = false;
    protected Map<IMIExecutionDMContext, MIThreadRunState> fThreadRunStates = new HashMap<IMIExecutionDMContext, MIThreadRunState>();

    public GDBRunControl_7_0_NS(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GDBRunControl_7_0_NS.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.register(new String[]{IRunControl.class.getName()}, new Hashtable());
        this.fConnection = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        this.getSession().addServiceEventListener((Object)this, null);
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(rm);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void getModelData(IDMContext dmc, DataRequestMonitor<?> rm) {
        if (dmc instanceof IRunControl.IExecutionDMContext) {
            this.getExecutionData((IRunControl.IExecutionDMContext)dmc, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Unknown DMC type", null));
            rm.done();
        }
    }

    public boolean isSuspended(IRunControl.IExecutionDMContext context) {
        if (context instanceof IMIExecutionDMContext) {
            MIThreadRunState threadState = this.fThreadRunStates.get(context);
            return threadState == null ? false : !this.fTerminated && threadState.fSuspended;
        }
        if (context instanceof IRunControl.IContainerDMContext) {
            boolean isSuspended = false;
            for (IMIExecutionDMContext threadContext : this.fThreadRunStates.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)threadContext, (IDMContext)context)) continue;
                isSuspended |= this.isSuspended((IRunControl.IExecutionDMContext)threadContext);
            }
            return isSuspended;
        }
        return false;
    }

    public void canSuspend(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (context instanceof IMIExecutionDMContext) {
            rm.setData((Object)this.doCanSuspend(context));
            rm.done();
            return;
        }
        if (context instanceof IRunControl.IContainerDMContext) {
            boolean canSuspend = false;
            for (IMIExecutionDMContext threadContext : this.fThreadRunStates.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)threadContext, (IDMContext)context)) continue;
                canSuspend |= this.doCanSuspend((IRunControl.IExecutionDMContext)threadContext);
            }
            rm.setData((Object)canSuspend);
            rm.done();
            return;
        }
        rm.setData((Object)false);
        rm.done();
    }

    private boolean doCanSuspend(IRunControl.IExecutionDMContext context) {
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        return threadState == null ? false : !this.fTerminated && !threadState.fSuspended;
    }

    public void suspend(IRunControl.IExecutionDMContext context, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext thread = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (thread != null) {
            this.doSuspendThread(thread, rm);
            return;
        }
        IRunControl.IContainerDMContext container = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)context, IRunControl.IContainerDMContext.class);
        if (container != null) {
            this.doSuspendContainer(container, rm);
            return;
        }
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Invalid context type.", null));
        rm.done();
    }

    private void doSuspendThread(IMIExecutionDMContext context, RequestMonitor rm) {
        if (!this.doCanSuspend((IRunControl.IExecutionDMContext)context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Given context: " + context + ", is already suspended.", null));
            rm.done();
            return;
        }
        MIExecInterrupt cmd = new MIExecInterrupt((IRunControl.IExecutionDMContext)context);
        this.fConnection.queueCommand((ICommand)cmd, new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    private void doSuspendContainer(IRunControl.IContainerDMContext context, RequestMonitor rm) {
        MIExecInterrupt cmd = new MIExecInterrupt((IRunControl.IExecutionDMContext)context, true);
        this.fConnection.queueCommand((ICommand)cmd, new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    public void canResume(IRunControl.IExecutionDMContext context, DataRequestMonitor<Boolean> rm) {
        if (context instanceof IMIExecutionDMContext) {
            rm.setData((Object)this.doCanResume(context));
            rm.done();
            return;
        }
        if (context instanceof IRunControl.IContainerDMContext) {
            boolean canSuspend = false;
            for (IMIExecutionDMContext threadContext : this.fThreadRunStates.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)threadContext, (IDMContext)context)) continue;
                canSuspend |= this.doCanResume((IRunControl.IExecutionDMContext)threadContext);
            }
            rm.setData((Object)canSuspend);
            rm.done();
            return;
        }
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Invalid context type.", null));
        rm.done();
    }

    private boolean doCanResume(IRunControl.IExecutionDMContext context) {
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        return threadState == null ? false : !this.fTerminated && threadState.fSuspended && !threadState.fResumePending;
    }

    public void resume(IRunControl.IExecutionDMContext context, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext thread = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (thread != null) {
            this.doResumeThread(thread, rm);
            return;
        }
        IRunControl.IContainerDMContext container = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)context, IRunControl.IContainerDMContext.class);
        if (container != null) {
            this.doResumeContainer(container, rm);
            return;
        }
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Invalid context type.", null));
        rm.done();
    }

    private void doResumeThread(IMIExecutionDMContext context, RequestMonitor rm) {
        if (!this.doCanResume((IRunControl.IExecutionDMContext)context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10001, "Given context: " + context + ", is already running.", null));
            rm.done();
            return;
        }
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        if (threadState == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10001, "Given context: " + context + " is not an MI execution context.", null));
            rm.done();
            return;
        }
        threadState.fResumePending = true;
        MIExecContinue cmd = new MIExecContinue((IRunControl.IExecutionDMContext)context);
        this.fConnection.queueCommand((ICommand)cmd, new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    private void doResumeContainer(IRunControl.IContainerDMContext context, RequestMonitor rm) {
        MIExecContinue cmd = new MIExecContinue((IRunControl.IExecutionDMContext)context, true);
        this.fConnection.queueCommand((ICommand)cmd, new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    public boolean isStepping(IRunControl.IExecutionDMContext context) {
        if (context instanceof IMIExecutionDMContext) {
            MIThreadRunState threadState = this.fThreadRunStates.get(context);
            return threadState == null ? false : !this.fTerminated && threadState.fStepping;
        }
        return false;
    }

    public void canStep(IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, DataRequestMonitor<Boolean> rm) {
        if (context instanceof IMIExecutionDMContext) {
            this.canResume(context, rm);
            return;
        }
        rm.setData((Object)false);
        rm.done();
    }

    public void step(IRunControl.IExecutionDMContext context, IRunControl.StepType stepType, RequestMonitor rm) {
        assert (context != null);
        IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Given context: " + context + " is not an MI execution context.", null));
            rm.done();
            return;
        }
        if (!this.doCanResume(context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        if (threadState == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10001, "Given context: " + context + " can't be found.", null));
            rm.done();
            return;
        }
        threadState.fResumePending = true;
        threadState.fStepping = true;
        switch (stepType) {
            case STEP_INTO: {
                this.fConnection.queueCommand((ICommand)new MIExecStep((IRunControl.IExecutionDMContext)dmc), new DataRequestMonitor((Executor)this.getExecutor(), rm));
                break;
            }
            case STEP_OVER: {
                this.fConnection.queueCommand((ICommand)new MIExecNext((IRunControl.IExecutionDMContext)dmc), new DataRequestMonitor((Executor)this.getExecutor(), rm));
                break;
            }
            case STEP_RETURN: {
                MIStack stackService = (MIStack)this.getServicesTracker().getService(MIStack.class);
                if (stackService != null) {
                    IStack.IFrameDMContext topFrameDmc = stackService.createFrameDMContext((IRunControl.IExecutionDMContext)dmc, 0);
                    this.fConnection.queueCommand((ICommand)new MIExecFinish(topFrameDmc), new DataRequestMonitor((Executor)this.getExecutor(), rm));
                    break;
                }
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Cannot create context for command, stack service not available.", null));
                rm.done();
                break;
            }
            case INSTRUCTION_STEP_INTO: {
                this.fConnection.queueCommand((ICommand)new MIExecStepInstruction((IRunControl.IExecutionDMContext)dmc), new DataRequestMonitor((Executor)this.getExecutor(), rm));
                break;
            }
            case INSTRUCTION_STEP_OVER: {
                this.fConnection.queueCommand((ICommand)new MIExecNextInstruction((IRunControl.IExecutionDMContext)dmc), new DataRequestMonitor((Executor)this.getExecutor(), rm));
                break;
            }
            default: {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Given step type not supported", null));
                rm.done();
            }
        }
    }

    public void runToLine(IRunControl.IExecutionDMContext context, String fileName, String lineNo, boolean skipBreakpoints, DataRequestMonitor<MIInfo> rm) {
        assert (context != null);
        IMIExecutionDMContext dmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Given context: " + context + " is not an MI execution context.", null));
            rm.done();
            return;
        }
        if (!this.doCanResume(context)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10001, "Cannot resume context", null));
            rm.done();
            return;
        }
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        if (threadState == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10001, "Given context: " + context + " is not an MI execution context.", null));
            rm.done();
            return;
        }
        threadState.fResumePending = true;
        this.fConnection.queueCommand((ICommand)new MIExecUntil((IRunControl.IExecutionDMContext)dmc, fileName + ":" + lineNo), new DataRequestMonitor((Executor)this.getExecutor(), rm));
    }

    public void getExecutionContexts(IRunControl.IContainerDMContext containerDmc, final DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
        IMIProcesses procService = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
        procService.getProcessesBeingDebugged((IDMContext)containerDmc, (DataRequestMonitor)new DataRequestMonitor<IDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                if (this.getData() instanceof IRunControl.IExecutionDMContext[]) {
                    rm.setData((Object)((IRunControl.IExecutionDMContext[])this.getData()));
                } else {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Invalid contexts", null));
                }
                rm.done();
            }
        });
    }

    public void getExecutionData(IRunControl.IExecutionDMContext dmc, DataRequestMonitor<IRunControl.IExecutionDMData> rm) {
        MIThreadRunState threadState = this.fThreadRunStates.get(dmc);
        if (threadState == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Given context: " + dmc + " is not a recognized execution context.", null));
            rm.done();
            return;
        }
        if (dmc instanceof IMIExecutionDMContext) {
            rm.setData((Object)new ExecutionData(threadState.fSuspended ? threadState.fStateChangeReason : null));
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Given context: " + dmc + " is not a recognized execution context.", null));
        }
        rm.done();
    }

    private IMIExecutionDMContext createMIExecutionContext(IRunControl.IContainerDMContext container, String threadId) {
        IMIProcesses procService = (IMIProcesses)this.getServicesTracker().getService(IMIProcesses.class);
        IProcesses.IProcessDMContext procDmc = (IProcesses.IProcessDMContext)DMContexts.getAncestorOfType((IDMContext)container, IProcesses.IProcessDMContext.class);
        IProcesses.IThreadDMContext threadDmc = null;
        if (procDmc != null) {
            threadDmc = procService.createThreadContext(procDmc, threadId);
        }
        return procService.createExecutionContext(container, threadDmc, threadId);
    }

    private void updateThreadState(IMIExecutionDMContext context, ResumedEvent event) {
        IRunControl.StateChangeReason reason = event.getReason();
        boolean isStepping = reason.equals((Object)IRunControl.StateChangeReason.STEP);
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        if (threadState == null) {
            threadState = new MIThreadRunState();
            this.fThreadRunStates.put(context, threadState);
        }
        threadState.fSuspended = false;
        threadState.fResumePending = false;
        threadState.fStateChangeReason = reason;
        threadState.fStepping = isStepping;
    }

    private void updateThreadState(IMIExecutionDMContext context, SuspendedEvent event) {
        IRunControl.StateChangeReason reason = event.getReason();
        MIThreadRunState threadState = this.fThreadRunStates.get(context);
        if (threadState == null) {
            threadState = new MIThreadRunState();
            this.fThreadRunStates.put(context, threadState);
        }
        threadState.fSuspended = true;
        threadState.fResumePending = false;
        threadState.fStepping = false;
        threadState.fStateChangeReason = reason;
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIRunningEvent e) {
        this.getSession().dispatchEvent((Object)new ResumedEvent((IRunControl.IExecutionDMContext)e.getDMContext(), e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIStoppedEvent e) {
        this.getSession().dispatchEvent((Object)new SuspendedEvent((IRunControl.IExecutionDMContext)e.getDMContext(), e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadCreatedEvent e) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)e.getDMContext();
        IMIExecutionDMContext executionCtx = null;
        if (e.getStrId() != null) {
            executionCtx = this.createMIExecutionContext(containerDmc, e.getStrId());
        }
        this.getSession().dispatchEvent((Object)new StartedDMEvent(executionCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(MIThreadExitEvent e) {
        IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)e.getDMContext();
        IMIExecutionDMContext executionCtx = null;
        if (e.getStrId() != null) {
            executionCtx = this.createMIExecutionContext(containerDmc, e.getStrId());
        }
        this.getSession().dispatchEvent((Object)new ExitedDMEvent(executionCtx, e), this.getProperties());
    }

    @DsfServiceEventHandler
    public void eventDispatched(ResumedEvent e) {
        IRunControl.IExecutionDMContext ctx = (IRunControl.IExecutionDMContext)e.getDMContext();
        if (ctx instanceof IMIExecutionDMContext) {
            this.updateThreadState((IMIExecutionDMContext)ctx, e);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(SuspendedEvent e) {
        IRunControl.IExecutionDMContext ctx = (IRunControl.IExecutionDMContext)e.getDMContext();
        if (ctx instanceof IMIExecutionDMContext) {
            this.updateThreadState((IMIExecutionDMContext)ctx, e);
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(StartedDMEvent e) {
        IRunControl.IExecutionDMContext executionCtx = (IRunControl.IExecutionDMContext)e.getDMContext();
        if (executionCtx instanceof IMIExecutionDMContext && this.fThreadRunStates.get(executionCtx) == null) {
            this.fThreadRunStates.put((IMIExecutionDMContext)executionCtx, new MIThreadRunState());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ExitedDMEvent e) {
        this.fThreadRunStates.remove(e.getDMContext());
    }

    @DsfServiceEventHandler
    public void eventDispatched(ICommandControlService.ICommandControlShutdownDMEvent e) {
        this.fTerminated = true;
    }

    public void flushCache(IDMContext context) {
    }

    @Immutable
    private static class ExecutionData
    implements IRunControl.IExecutionDMData {
        private final IRunControl.StateChangeReason fReason;

        ExecutionData(IRunControl.StateChangeReason reason) {
            this.fReason = reason;
        }

        public IRunControl.StateChangeReason getStateChangeReason() {
            return this.fReason;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    private static class ExitedDMEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIThreadExitEvent>
    implements IRunControl.IExitedDMEvent {
        ExitedDMEvent(IMIExecutionDMContext executionDmc, MIThreadExitEvent miInfo) {
            super(executionDmc, miInfo);
        }
    }

    protected class MIThreadRunState {
        boolean fSuspended = false;
        boolean fResumePending = false;
        boolean fStepping = false;
        IRunControl.StateChangeReason fStateChangeReason;

        protected MIThreadRunState() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    private static class ResumedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIRunningEvent>
    implements IRunControl.IResumedDMEvent {
        ResumedEvent(IRunControl.IExecutionDMContext ctx, MIRunningEvent miInfo) {
            super(ctx, miInfo);
        }

        public IRunControl.StateChangeReason getReason() {
            switch (((MIRunningEvent)this.getMIEvent()).getType()) {
                case 0: {
                    return IRunControl.StateChangeReason.USER_REQUEST;
                }
                case 1: 
                case 2: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 3: 
                case 4: {
                    return IRunControl.StateChangeReason.STEP;
                }
                case 5: {
                    return IRunControl.StateChangeReason.STEP;
                }
            }
            return IRunControl.StateChangeReason.UNKNOWN;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    private static class RunControlEvent<V extends IDMContext, T extends MIEvent<? extends IDMContext>>
    extends AbstractDMEvent<V>
    implements IDMEvent<V>,
    IMIDMEvent {
        private final T fMIInfo;

        public RunControlEvent(V dmc, T miInfo) {
            super(dmc);
            this.fMIInfo = miInfo;
        }

        public T getMIEvent() {
            return this.fMIInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    private static class StartedDMEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIThreadCreatedEvent>
    implements IRunControl.IStartedDMEvent {
        StartedDMEvent(IMIExecutionDMContext executionDmc, MIThreadCreatedEvent miInfo) {
            super(executionDmc, miInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    private static class SuspendedEvent
    extends RunControlEvent<IRunControl.IExecutionDMContext, MIStoppedEvent>
    implements IRunControl.ISuspendedDMEvent {
        SuspendedEvent(IRunControl.IExecutionDMContext ctx, MIStoppedEvent miInfo) {
            super(ctx, miInfo);
        }

        public IRunControl.StateChangeReason getReason() {
            if (this.getMIEvent() instanceof MIBreakpointHitEvent) {
                return IRunControl.StateChangeReason.BREAKPOINT;
            }
            if (this.getMIEvent() instanceof MISteppingRangeEvent) {
                return IRunControl.StateChangeReason.STEP;
            }
            if (this.getMIEvent() instanceof MISharedLibEvent) {
                return IRunControl.StateChangeReason.SHAREDLIB;
            }
            if (this.getMIEvent() instanceof MISignalEvent) {
                return IRunControl.StateChangeReason.SIGNAL;
            }
            if (this.getMIEvent() instanceof MIWatchpointTriggerEvent) {
                return IRunControl.StateChangeReason.WATCHPOINT;
            }
            if (this.getMIEvent() instanceof MIErrorEvent) {
                return IRunControl.StateChangeReason.ERROR;
            }
            return IRunControl.StateChangeReason.USER_REQUEST;
        }
    }
}

