/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMEvent;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStepQueueManager;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SteppingController
implements IStepQueueManager {
    public static final int STEPPING_TIMEOUT = 500;
    public static final int STEP_QUEUE_DEPTH = 2;
    public static final int MAX_STEP_DELAY = 5000;
    private static final boolean DEBUG = "true".equals(Platform.getDebugOption((String)"org.eclipse.dd.dsf.debug.ui/stepping"));
    private final DsfSession fSession;
    private final DsfServicesTracker fServicesTracker;
    private IRunControl fRunControl;
    private int fQueueDepth = 2;
    private final Map<IRunControl.IExecutionDMContext, List<StepRequest>> fStepQueues = new HashMap<IRunControl.IExecutionDMContext, List<StepRequest>>();
    private final Map<IRunControl.IExecutionDMContext, Boolean> fTimedOutFlags = new HashMap<IRunControl.IExecutionDMContext, Boolean>();
    private final Map<IRunControl.IExecutionDMContext, ScheduledFuture<?>> fTimedOutFutures = new HashMap();
    private final Map<IRunControl.IExecutionDMContext, Long> fLastStepTimes = new HashMap<IRunControl.IExecutionDMContext, Long>();
    private int fMinStepInterval = 0;
    private final Map<IRunControl.IExecutionDMContext, List<ISteppingControlParticipant>> fStepInProgress = new HashMap<IRunControl.IExecutionDMContext, List<ISteppingControlParticipant>>();
    private final List<ISteppingControlParticipant> fParticipants = Collections.synchronizedList(new ArrayList());
    private IPropertyChangeListener fPreferencesListener;

    public SteppingController(DsfSession session) {
        this.fSession = session;
        this.fServicesTracker = new DsfServicesTracker(DsfDebugUIPlugin.getBundleContext(), session.getId());
        final IPreferenceStore store = DsfDebugUIPlugin.getDefault().getPreferenceStore();
        this.fPreferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SteppingController.this.handlePropertyChanged(store, event);
            }
        };
        store.addPropertyChangeListener(this.fPreferencesListener);
        this.setMinimumStepInterval(store.getInt("minStepInterval"));
    }

    public void dispose() {
        if (this.fRunControl != null) {
            this.getSession().removeServiceEventListener((Object)this);
        }
        IPreferenceStore store = DsfDebugUIPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener(this.fPreferencesListener);
        this.fServicesTracker.dispose();
    }

    public void setMinimumStepInterval(int interval) {
        this.fMinStepInterval = interval;
    }

    public void addSteppingControlParticipant(ISteppingControlParticipant participant) {
        this.fParticipants.add(participant);
    }

    public void removeSteppingControlParticipant(ISteppingControlParticipant participant) {
        this.fParticipants.remove(participant);
    }

    public void doneStepping(IRunControl.IExecutionDMContext execCtx, ISteppingControlParticipant participant) {
        List<ISteppingControlParticipant> participants;
        if (DEBUG) {
            System.out.println("[SteppingController] doneStepping participant=" + participant.getClass().getSimpleName());
        }
        if ((participants = this.fStepInProgress.get(execCtx)) != null) {
            participants.remove(participant);
            if (participants.isEmpty()) {
                this.doneStepping(execCtx);
            }
        } else {
            for (IRunControl.IExecutionDMContext disabledCtx : this.fStepInProgress.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)disabledCtx, (IDMContext)execCtx) || (participants = this.fStepInProgress.get(disabledCtx)) == null) continue;
                participants.remove(participant);
                if (!participants.isEmpty()) continue;
                this.doneStepping(disabledCtx);
            }
        }
    }

    public DsfSession getSession() {
        return this.fSession;
    }

    public DsfExecutor getExecutor() {
        return this.getSession().getExecutor();
    }

    private DsfServicesTracker getServicesTracker() {
        return this.fServicesTracker;
    }

    private IRunControl getRunControl() {
        if (this.fRunControl == null) {
            this.fRunControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
            this.getSession().addServiceEventListener((Object)this, null);
        }
        return this.fRunControl;
    }

    public void canEnqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType, DataRequestMonitor<Boolean> rm) {
        if (this.doCanEnqueueStep(execCtx, stepType)) {
            rm.setData((Object)true);
            rm.done();
        } else {
            this.getRunControl().canStep(execCtx, stepType, rm);
        }
    }

    private boolean doCanEnqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        return this.getRunControl().isStepping(execCtx) && !this.isSteppingTimedOut(execCtx);
    }

    private boolean shouldDelayStep(IRunControl.IExecutionDMContext execCtx) {
        int stepDelay = this.getStepDelay(execCtx);
        if (DEBUG) {
            System.out.println("[SteppingController] shouldDelayStep delay=" + stepDelay);
        }
        return stepDelay > 0;
    }

    private int getStepDelay(IRunControl.IExecutionDMContext execCtx) {
        if (this.fMinStepInterval > 0) {
            for (IRunControl.IExecutionDMContext lastStepCtx : this.fLastStepTimes.keySet()) {
                if (!execCtx.equals(lastStepCtx) && !DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)lastStepCtx)) continue;
                long now = System.currentTimeMillis();
                int delay = (int)(this.fLastStepTimes.get(lastStepCtx) + (long)this.fMinStepInterval - now);
                return Math.max(delay, 0);
            }
        }
        return 0;
    }

    private void updateLastStepTime(IRunControl.IExecutionDMContext execCtx) {
        long now = System.currentTimeMillis();
        this.fLastStepTimes.put(execCtx, now);
        for (IRunControl.IExecutionDMContext lastStepCtx : this.fLastStepTimes.keySet()) {
            if (execCtx.equals(lastStepCtx) || !DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)lastStepCtx)) continue;
            this.fLastStepTimes.put(lastStepCtx, now);
        }
    }

    private long getLastStepTime(IRunControl.IExecutionDMContext execCtx) {
        if (this.fLastStepTimes.containsKey(execCtx)) {
            return this.fLastStepTimes.get(execCtx);
        }
        for (IRunControl.IExecutionDMContext lastStepCtx : this.fLastStepTimes.keySet()) {
            if (!DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)lastStepCtx)) continue;
            return this.fLastStepTimes.get(lastStepCtx);
        }
        return 0L;
    }

    public int getPendingStepCount(IRunControl.IExecutionDMContext execCtx) {
        List<StepRequest> stepQueue = this.getStepQueue(execCtx);
        if (stepQueue == null) {
            return 0;
        }
        return stepQueue.size();
    }

    public void enqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        if (DEBUG) {
            System.out.println("[SteppingController] enqueueStep ctx=" + execCtx);
        }
        if (!this.shouldDelayStep(execCtx) || this.doCanEnqueueStep(execCtx, stepType)) {
            this.doEnqueueStep(execCtx, stepType);
            this.processStepQueue(execCtx);
        }
    }

    private void doStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        if (DEBUG) {
            System.out.println("[SteppingController] doStep ctx=" + execCtx);
        }
        this.disableStepping(execCtx);
        this.updateLastStepTime(execCtx);
        this.getRunControl().step(execCtx, stepType, new RequestMonitor((Executor)this.getExecutor(), null){

            protected void handleFailure() {
                if (this.getStatus().getCode() == 10001) {
                    return;
                }
                super.handleFailure();
            }
        });
    }

    private void doEnqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        List<StepRequest> stepQueue = this.fStepQueues.get(execCtx);
        if (stepQueue == null) {
            stepQueue = new LinkedList<StepRequest>();
            this.fStepQueues.put(execCtx, stepQueue);
        }
        if (stepQueue.size() < this.fQueueDepth) {
            stepQueue.add(new StepRequest(execCtx, stepType));
        }
    }

    public boolean isSteppingTimedOut(IRunControl.IExecutionDMContext execCtx) {
        for (IRunControl.IExecutionDMContext timedOutCtx : this.fTimedOutFlags.keySet()) {
            if (!execCtx.equals(timedOutCtx) && !DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)timedOutCtx)) continue;
            return this.fTimedOutFlags.get(timedOutCtx);
        }
        return false;
    }

    private void processStepQueue(final IRunControl.IExecutionDMContext execCtx) {
        final List<StepRequest> queue = this.getStepQueue(execCtx);
        if (queue != null) {
            int stepDelay = this.getStepDelay(execCtx);
            if (stepDelay > 0) {
                this.getExecutor().schedule((Runnable)new DsfRunnable(){

                    public void run() {
                        SteppingController.this.processStepQueue(execCtx);
                    }
                }, (long)stepDelay, TimeUnit.MILLISECONDS);
                return;
            }
            final StepRequest request = queue.get(0);
            if (DEBUG) {
                System.out.println("[SteppingController] processStepQueue request-in-progress=" + request.inProgress);
            }
            if (!request.inProgress) {
                if (this.isSteppingDisabled(request.fContext)) {
                    return;
                }
                request.inProgress = true;
                this.getRunControl().canStep(request.fContext, request.fStepType, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)this.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                            queue.remove(0);
                            if (queue.isEmpty()) {
                                SteppingController.this.fStepQueues.remove(request.fContext);
                            }
                            SteppingController.this.doStep(request.fContext, request.fStepType);
                        } else {
                            SteppingController.this.fStepQueues.remove(request.fContext);
                        }
                    }
                });
            }
        }
    }

    private List<StepRequest> getStepQueue(IRunControl.IExecutionDMContext execCtx) {
        List<StepRequest> queue = this.fStepQueues.get(execCtx);
        if (queue == null) {
            for (IRunControl.IExecutionDMContext stepCtx : this.fStepQueues.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)stepCtx, (IDMContext)execCtx)) continue;
                queue = this.fStepQueues.get(stepCtx);
                break;
            }
        }
        return queue;
    }

    private void disableStepping(IRunControl.IExecutionDMContext execCtx) {
        this.fStepInProgress.put(execCtx, new ArrayList<ISteppingControlParticipant>(this.fParticipants));
    }

    private void doneStepping(IRunControl.IExecutionDMContext execCtx) {
        if (DEBUG) {
            System.out.println("[SteppingController] doneStepping ctx=" + execCtx);
        }
        this.enableStepping(execCtx);
        this.processStepQueue(execCtx);
    }

    private void enableStepping(IRunControl.IExecutionDMContext execCtx) {
        this.fStepInProgress.remove(execCtx);
        for (IRunControl.IExecutionDMContext disabledCtx : this.fStepInProgress.keySet()) {
            if (!DMContexts.isAncestorOf((IDMContext)disabledCtx, (IDMContext)execCtx)) continue;
            this.fStepInProgress.remove(disabledCtx);
        }
    }

    private boolean isSteppingDisabled(IRunControl.IExecutionDMContext execCtx) {
        long lastStepTime;
        long now;
        boolean disabled = this.fStepInProgress.containsKey(execCtx);
        if (!disabled) {
            for (IRunControl.IExecutionDMContext disabledCtx : this.fStepInProgress.keySet()) {
                if (!DMContexts.isAncestorOf((IDMContext)execCtx, (IDMContext)disabledCtx)) continue;
                disabled = true;
                break;
            }
        }
        if (disabled && (now = System.currentTimeMillis()) - (lastStepTime = this.getLastStepTime(execCtx)) > 5000L) {
            if (DEBUG) {
                System.out.println("[SteppingController] stepping control participant(s) timed out");
            }
            this.enableStepping(execCtx);
            disabled = false;
        }
        return disabled;
    }

    protected void handlePropertyChanged(IPreferenceStore store, PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("minStepInterval".equals(property)) {
            this.setMinimumStepInterval(store.getInt(property));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fTimedOutFlags.remove(e.getDMContext());
        ScheduledFuture<?> future = this.fTimedOutFutures.remove(e.getDMContext());
        if (future != null) {
            future.cancel(false);
        }
        this.processStepQueue((IRunControl.IExecutionDMContext)e.getDMContext());
    }

    @DsfServiceEventHandler
    public void eventDispatched(final IRunControl.IResumedDMEvent e) {
        if (e.getReason().equals((Object)IRunControl.StateChangeReason.STEP)) {
            this.fTimedOutFlags.put((IRunControl.IExecutionDMContext)e.getDMContext(), Boolean.FALSE);
            assert (!this.fTimedOutFutures.containsKey(e.getDMContext()));
            this.fTimedOutFutures.put((IRunControl.IExecutionDMContext)e.getDMContext(), this.getExecutor().schedule((Runnable)new DsfRunnable(){

                public void run() {
                    SteppingController.this.fTimedOutFutures.remove(e.getDMContext());
                    if (SteppingController.this.getSession().isActive()) {
                        SteppingController.this.getSession().dispatchEvent((Object)new SteppingTimedOutEvent((IRunControl.IExecutionDMContext)e.getDMContext()), null);
                    }
                }
            }, 500L, TimeUnit.MILLISECONDS));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(SteppingTimedOutEvent e) {
        this.fTimedOutFlags.put((IRunControl.IExecutionDMContext)e.getDMContext(), Boolean.TRUE);
        this.enableStepping((IRunControl.IExecutionDMContext)e.getDMContext());
    }

    public static interface ISteppingControlParticipant {
    }

    private static class StepRequest {
        IRunControl.IExecutionDMContext fContext;
        IRunControl.StepType fStepType;
        boolean inProgress = false;

        StepRequest(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType type) {
            this.fContext = execCtx;
            this.fStepType = type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SteppingTimedOutEvent
    extends AbstractDMEvent<IRunControl.IExecutionDMContext> {
        private SteppingTimedOutEvent(IRunControl.IExecutionDMContext execCtx) {
            super((IDMContext)execCtx);
        }
    }
}

