/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.viewmodel.actions;

import java.util.ArrayList;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions.VMHandlerUtils;
import org.eclipse.dd.dsf.debug.internal.ui.viewmodel.actions.MessagesForVMActions;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class UpdatePoliciesContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator fServiceLocator;
    private static IContributionItem[] NO_UPDATE_POLICIES_CONTRIBUTION_ITEMS = new IContributionItem[]{new ContributionItem(){

        public void fill(Menu menu, int index) {
            MenuItem item = new MenuItem(menu, 0);
            item.setEnabled(false);
            item.setText(MessagesForVMActions.UpdatePoliciesContribution_EmptyPoliciesList_label);
        }

        public boolean isEnabled() {
            return false;
        }
    }};

    protected IContributionItem[] getContributionItems() {
        IVMProvider provider = VMHandlerUtils.getActiveVMProvider(this.fServiceLocator);
        if (provider == null || !(provider instanceof ICachingVMProvider)) {
            return NO_UPDATE_POLICIES_CONTRIBUTION_ITEMS;
        }
        ICachingVMProvider cachingProvider = (ICachingVMProvider)provider;
        IVMUpdatePolicy[] policies = cachingProvider.getAvailableUpdatePolicies();
        IVMUpdatePolicy activePolicy = cachingProvider.getActiveUpdatePolicy();
        ArrayList<SelectUpdatePolicyAction> actions = new ArrayList<SelectUpdatePolicyAction>(policies.length);
        for (IVMUpdatePolicy policy : policies) {
            SelectUpdatePolicyAction action = new SelectUpdatePolicyAction(cachingProvider, policy);
            if (policy.getID().equals(activePolicy.getID())) {
                action.setChecked(true);
            }
            actions.add(action);
        }
        if (actions.isEmpty()) {
            return NO_UPDATE_POLICIES_CONTRIBUTION_ITEMS;
        }
        IContributionItem[] items = new IContributionItem[actions.size()];
        for (int i = 0; i < actions.size(); ++i) {
            items[i] = new ActionContributionItem((IAction)actions.get(i));
        }
        return items;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    private class SelectUpdatePolicyAction
    extends Action {
        private final ICachingVMProvider fProvider;
        private final IVMUpdatePolicy fPolicy;

        SelectUpdatePolicyAction(ICachingVMProvider provider, IVMUpdatePolicy policy) {
            super(policy.getName(), 8);
            this.fProvider = provider;
            this.fPolicy = policy;
        }

        public void run() {
            if (this.isChecked()) {
                this.fProvider.setActiveUpdatePolicy(this.fPolicy);
            }
        }
    }
}

