/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.document;

import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.AbstractorInterface;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritSignal;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritAbstractorDocument
extends SpiritDocument {
    public static final String DOCUMENT_TYPE = "abstractor";

    public SpiritAbstractorDocument(Document xmlDoc) {
        super(xmlDoc);
    }

    @Override
    public String getRootTagName() {
        return DOCUMENT_TYPE;
    }

    public static String getRootTag() {
        return DOCUMENT_TYPE;
    }

    public List<SpiritSignal> getSignals() {
        ArrayList<SpiritSignal> signals = new ArrayList<SpiritSignal>();
        try {
            XPathExpression e = null;
            XPath xPath = this.createXPath();
            e = xPath.compile("//spirit:signals/spirit:signal");
            NodeList signalNodes = (NodeList)e.evaluate(this.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < signalNodes.getLength(); ++i) {
                Element signalNode = (Element)signalNodes.item(i);
                signals.add(new SpiritSignal(signalNode));
            }
        }
        catch (XPathExpressionException e1) {
            e1.printStackTrace();
        }
        return signals;
    }

    @Override
    public String[] attributeValueSuggestions(Node node, String attribute) {
        ArrayList resultsList = new ArrayList();
        while (node != null && node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        if (node != null) {
            // empty if block
        }
        if (resultsList.size() == 0) {
            return super.attributeValueSuggestions(node, attribute);
        }
        String[] dummy = new String[]{};
        return resultsList.toArray(dummy);
    }

    @Override
    public String[] elementValueSuggestions(Node node, String name) {
        ArrayList resultsList = new ArrayList();
        while (node != null && node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        if (node != null) {
            // empty if block
        }
        if (resultsList.size() == 0) {
            return super.elementValueSuggestions(node, name);
        }
        String[] dummy = new String[]{};
        return resultsList.toArray(dummy);
    }

    public SpiritNode getBusType() {
        return this.getUniqueChildElement("busType", SpiritNode.class);
    }

    public String getMode() {
        return this.getUniqueDescendantText("abstractorMode");
    }

    public AbstractorInterface getPrimaryAbstractorInterface() {
        NodeList abstractorInterfaces = this.getDescendants("abstractorInterface");
        String abstractorMode = this.getMode();
        String mode = abstractorMode.equals("master") || abstractorMode.equals("direct") ? "mirroredMaster" : (abstractorMode.endsWith("slave") ? "slave" : "mirroredSystem");
        return new AbstractorInterface((Element)abstractorInterfaces.item(0), mode, this.getGroup());
    }

    public AbstractorInterface getSecondaryAbstractorInterface() {
        NodeList abstractorInterfaces = this.getDescendants("abstractorInterface");
        String abstractorMode = this.getMode();
        String mode = abstractorMode.equals("slave") || abstractorMode.equals("direct") ? "mirroredSlave" : (abstractorMode.endsWith("master") ? "master" : "system");
        return new AbstractorInterface((Element)abstractorInterfaces.item(1), mode, this.getGroup());
    }

    private String getGroup() {
        return this.getUniqueDescendantElement("abstractorMode", SpiritNode.class).getSpiritAttribute("group");
    }
}

