/*******************************************************************************
 * Copyright 2005, 2006 FUJITSU LIMITED
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License (EPL). 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Fujitsu Ltd. - Initial API and implementation
 *******************************************************************************/

package org.eclipse.nab.core;

import java.util.ArrayList;

//import org.eclipse.swt.widgets.Display;


public interface INtkInstanceManager{
    long readInstanceDataFile(String folder,String fname,int flag);
    int  saveInstanceDataFile(String path,long inst,int encoding);
    
    int setNewInstanceClassName(String className);
    long getNewInstance(String className,String instanceName,long parent);
    long getInstance(String className,String instanceName);
    
    long checkInstanceName(long id,String name);
    long checkProcedureName(String pname);
    
    int setNewInstancePositionMode(boolean fl);
    int loadLibrary(String libname);

    void setSelectedInstance(long inst); 
    boolean existInstance(long inst);
    int pasteInstance(long inst,long inst2);
    int deleteInstance(long inst);
    
    int redraw(long inst);
    int getInstanceType(long inst);
    String getClassName(long inst);
    
    int setProperty(long inst, String prop,int val);
    int setProperty(long inst, String prop,String val);
    int getProperty(long inst, String prop);
    String getProperty(long inst, String prop, int encoding);
    boolean existProperty(long inst, String prop);
    boolean existTrigger(long id, int trig);
    
    int getExtTriggerList(long id,ArrayList namelist,ArrayList trglist);
    
    int setUserLongData(long inst,String prop,long val);
    long getUserLongData(long inst,String prop);
    
    int setUserStringData(long inst, String prop,String val);
    String getUserStringData(long inst, String prop);
    
    int setVisible(long inst,boolean fl);
    boolean getVisible(long inst);
    
    long getParentWindow(long inst);
    long getParent(long inst);
    int  addProcedure(long id, String procedureName, String functionName, int triggerNum);
    int  delProcedure(long id,long procid);
    int configureProcedure(long procId,String procedureName, String functionName, int triggerNum);
    String getProcedureName(long procId);
    String getFunctionName(long procId);
    int  getTrigger(long procId);
    String  getProcedureAttribute(long procId,String attr);
    int setFunctionName(long procId,String fname);
    int setProcedureName(long procId,String pname);
    int setTrigger(long procId,int trigger);
    int setProcedureAttribute(long procId,String attr,String val);
    
    int setInstanceId(int kind, long id);
    long getInstanceId(long id, int kind,long val);
    int setupInstance(long inst);
    String getInstanceData(long id,int kind,long val,int encode);
    long getTargetInstance();
    int setTargetInstance(long inst);
    boolean isParent(long parent,long child);
    
    ArrayList setCopyList(ArrayList inst);
    ArrayList getCopyList();
    ArrayList setDeleteList(ArrayList inst);
    ArrayList getDeleteList();   
}
